/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindPolicyType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindPolicyType;
import java.io.IOException;
import java.util.Collections;
import org.junit.jupiter.api.Test;
import us.ihmc.idl.generated.test.StatusMessage;
import us.ihmc.idl.generated.test.StatusMessagePubSubType;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantProfile;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.impl.fastRTPS.FastRTPSDomain;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class PublishSubscribeUInt64SharedMemoryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublishSubscribeUInt32SharedMemory() throws IOException {
        FastRTPSDomain domain = DomainFactory.getDomain();
        try {
            domain.setLogLevel(LogLevel.INFO);
            ParticipantProfile attributes = ParticipantProfile.create().domainId(219).useOnlyIntraProcessDelivery().discoveryLeaseDuration(Time.Infinite).name("StatusTest");
            Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
            StatusMessagePubSubType dataType = new StatusMessagePubSubType();
            domain.registerType(participant, (TopicDataType)dataType);
            PublisherAttributes genericPublisherAttributes = (PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicDataType((TopicDataType)dataType)).topicName("Status")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindPolicyType.TRANSIENT_LOCAL)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_LAST)).historyDepth(50L);
            StatusMessagePubSubType dataType2 = new StatusMessagePubSubType();
            SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicDataType((TopicDataType)dataType2)).topicName("Status")).reliabilityKind(ReliabilityQosKindPolicyType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindPolicyType.TRANSIENT_LOCAL)).historyQosPolicyKind(HistoryQosKindPolicyType.KEEP_LAST)).historyDepth(50L);
            Subscriber subscriber = domain.createSubscriber(participant, subscriberAttributes, (SubscriberListener)new SubscriberListenerImpl());
            Publisher publisher = domain.createPublisher(participant, genericPublisherAttributes, (PublisherListener)new PublisherListenerImpl());
            StatusMessage msg = new StatusMessage();
            msg.setPause(false);
            msg.setSequenceId(0L);
            for (int i = 0; i < 10; ++i) {
                try {
                    msg.setPause(i % 2 == 0);
                    msg.setSequenceId(i);
                    publisher.write((Object)msg);
                    System.out.println("Publishing: " + msg.toString());
                    Thread.sleep(1000L);
                    ++i;
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        finally {
            domain.stopAll();
        }
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            System.out.println("New participant discovered");
            System.out.println("Status: " + String.valueOf(info.getStatus()));
            System.out.println("Guid: " + info.getGuid().toString());
            System.out.println("Name: " + info.getName());
        }
    }

    private class SubscriberListenerImpl
    implements SubscriberListener {
        private final StatusMessage data = new StatusMessage();
        private final SampleInfo info = new SampleInfo();

        private SubscriberListenerImpl() {
        }

        public void onNewDataMessage(Subscriber subscriber) {
            if (subscriber.takeNextData((Object)this.data, this.info)) {
                System.out.println("Received: " + this.data.toString());
            }
        }

        public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
            System.out.println("New publisher matched");
            System.out.println("Status: " + String.valueOf(info.getStatus()));
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }

    private class PublisherListenerImpl
    implements PublisherListener {
        private PublisherListenerImpl() {
        }

        public void onPublicationMatched(Publisher publisher, MatchingInfo info) {
            System.out.println("New subscriber matched");
            System.out.println("Status: " + String.valueOf(info.getStatus()));
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }
}

