/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.idl.generated.nested.NestedElement;
import us.ihmc.idl.generated.test.Color;
import us.ihmc.idl.generated.test.IDLElementTest;
import us.ihmc.idl.generated.test.IDLElementTestPubSubType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.pubsub.test.IDLElementTestCPPData;

public class IDLElementTestTest {
    private void populateIDLElementTest(IDLElementTest test) {
        int i;
        test.setCharTest('3');
        test.setWcharTest('\u03a9');
        test.setOctetTest((byte)10);
        test.setShortTest((short)-16);
        test.setUshortTest(15);
        test.setLongTest(-58102);
        test.setUlongTest(914L);
        test.setLonglongTest(-90224141L);
        test.setUlonglongTest(582142L);
        test.setFloatTest(258145.22f);
        test.setDoubleTest(9.1842890511241E9);
        test.setBooleanTest(true);
        test.setColorTest(Color.blue);
        test.getNestedElementTest().setLongTest(518);
        test.getNestedElementTest().getStringTest().append("Nested");
        test.getStringTest().append("Wolololo");
        for (i = 0; i < 10; ++i) {
            test.getLongArray()[i] = i * 124;
        }
        for (int a = 0; a < 5; ++a) {
            for (int b = 0; b < 3; ++b) {
                test.getNestedArray()[a][b].setLongTest(a + a * b * 3 + b + 24);
                test.getNestedArray()[a][b].getStringTest().append("arrayDim:" + a + b);
            }
        }
        for (i = 0; i < 4; ++i) {
            test.getStringArray()[i].append("arrayDim:" + i);
        }
        for (int s = 1; s < 4; ++s) {
            for (int w = 0; w < 5; ++w) {
                int i2 = s + s * w;
                switch (s) {
                    case 1: {
                        test.getCharSeqTest().add(String.valueOf(i2).charAt(0));
                        test.getWcharSeqTest().add('\u03a9');
                        test.getOctetSeqTest().add((byte)(i2 * 2));
                        test.getShortSeqTest().add((short)(-2 * i2 + 1));
                        test.getBooleanSeqTest().add(i2 % 2 == 0);
                    }
                    case 2: {
                        test.getUshortSeqTest().add(i2 + 4);
                        test.getLongSeqTest().add(i2 * 124 - 98);
                        test.getUlongSeqTest().add((long)(i2 * 11561));
                        test.getLonglongSeqtest().add(-2143125L + (long)(i2 * 1251));
                    }
                    case 3: {
                        test.getUlonglongSeqTest().add(241L + (long)i2 * 100421410L);
                        test.getFloatSeqTest().add(325.25f * (float)i2);
                        test.getDoubleSeqTest().add(15095.921 * (double)i2);
                        NestedElement elem = (NestedElement)((Object)test.getNestedSeqTest().add());
                        elem.setLongTest(i2 * 541);
                        elem.getStringTest().append("dim:" + s + w);
                        StringBuilder builder = (StringBuilder)test.getStringSeqTest().add();
                        builder.append("sdim:" + s + w);
                    }
                }
            }
        }
    }

    public IDLElementTest createPopulatedIDLElementTest() {
        IDLElementTest idlElementTest = new IDLElementTest();
        this.populateIDLElementTest(idlElementTest);
        return idlElementTest;
    }

    @Test
    public void testIDLElementEquals() {
        int i;
        IDLElementTest orig = this.createPopulatedIDLElementTest();
        IDLElementTest test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setCharTest('4');
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setWcharTest('z');
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setOctetTest((byte)11);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setShortTest((short)-1);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setUshortTest(1);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setLongTest(-5102);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setUlongTest(14L);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setLonglongTest(-9024141L);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setUlonglongTest(58142L);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setFloatTest(25814.215f);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setDoubleTest(9.182890511241E8);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setBooleanTest(false);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.setColorTest(Color.green);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.getNestedElementTest().setLongTest(58);
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.getNestedElementTest().getStringTest().setLength(0);
        test.getNestedElementTest().getStringTest().append("Wested");
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        test.getStringTest().setLength(0);
        test.getStringTest().append("Lolololo");
        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
        test = this.createPopulatedIDLElementTest();
        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        for (i = 0; i < 10; ++i) {
            test.getLongArray()[i] = i * 14 + 1;
            Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
            test = this.createPopulatedIDLElementTest();
            Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        }
        for (int a = 0; a < 5; ++a) {
            for (int b = 0; b < 3; ++b) {
                test.getNestedArray()[a][b].setLongTest(a + a * b * 3 + b + 25);
                Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                test = this.createPopulatedIDLElementTest();
                Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                test.getNestedArray()[a][b].getStringTest().setLength(0);
                test.getNestedArray()[a][b].getStringTest().append("arrayDim:" + a + b + "invalid");
                Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                test = this.createPopulatedIDLElementTest();
                Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
            }
        }
        for (i = 0; i < 4; ++i) {
            test.getStringArray()[i].setLength(0);
            test.getStringArray()[i].append("arrayDimNew:" + i);
            Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
            test = this.createPopulatedIDLElementTest();
            Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
        }
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        for (int s = 1; s < 4; ++s) {
            for (int w = 0; w < 5; ++w) {
                int i2 = s + s * w;
                switch (s) {
                    case 1: {
                        test.getCharSeqTest().set(c1, String.valueOf(i2 * 2).charAt(0));
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        test.getWcharSeqTest().set(c1, 'b');
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        test.getOctetSeqTest().set(c1, (byte)(i2 * 3));
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        test.getShortSeqTest().set(c1, (short)(-4 * i2 + 1));
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        test.getBooleanSeqTest().set(c1, !test.getBooleanSeqTest().getBoolean(c1));
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        ++c1;
                    }
                    case 2: {
                        test.getUshortSeqTest().set(c2, i2 + 5);
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        test.getLongSeqTest().set(c2, i2 * 124 - 99);
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        test.getUlongSeqTest().set(c2, (long)(i2 * 1161));
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        test.getLonglongSeqtest().set(c2, -243125L + (long)(i2 * 1251));
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        ++c2;
                    }
                    case 3: {
                        test.getUlonglongSeqTest().set(c3, 242L + (long)i2 * 100421410L);
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        test.getFloatSeqTest().set(c3, 525.25f * (float)i2);
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        test.getDoubleSeqTest().set(c3, 19095.921 * (double)i2);
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        NestedElement elem = (NestedElement)((Object)test.getNestedSeqTest().add());
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        elem = (NestedElement)((Object)test.getNestedSeqTest().get(c3));
                        elem.setLongTest(i2 * 541 + 18);
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        elem = (NestedElement)((Object)test.getNestedSeqTest().get(c3));
                        elem.getStringTest().setLength(0);
                        elem.getStringTest().append("dimnew:" + s + w);
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        StringBuilder builder = (StringBuilder)test.getStringSeqTest().add();
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        builder = (StringBuilder)test.getStringSeqTest().get(c3);
                        builder.append("newsdim:" + s + w);
                        Assertions.assertNotEquals((Object)((Object)orig), (Object)((Object)test));
                        test = this.createPopulatedIDLElementTest();
                        Assertions.assertEquals((Object)((Object)orig), (Object)((Object)test));
                        ++c3;
                    }
                }
            }
        }
    }

    @Test
    public void testIDLElementTestSet() {
        IDLElementTest a = this.createPopulatedIDLElementTest();
        IDLElementTest b = new IDLElementTest();
        Assertions.assertNotEquals((Object)((Object)a), (Object)((Object)b));
        b.set(a);
        Assertions.assertEquals((Object)((Object)a), (Object)((Object)b));
    }

    @Test
    public void testIDLElementSerializeDeserialize() throws IOException {
        IDLElementTest test = new IDLElementTest();
        this.populateIDLElementTest(test);
        IDLElementTestPubSubType type = new IDLElementTestPubSubType();
        SerializedPayload payload = new SerializedPayload(type.getTypeSize());
        type.serialize(test, payload);
        IDLElementTest other = new IDLElementTest();
        type.deserialize(payload, other);
        Assertions.assertEquals((Object)((Object)test), (Object)((Object)other));
    }

    @Disabled
    @Test
    public void testIDLElementWithFastRTPSGenCPPCode() throws IOException {
        IDLElementTest test = new IDLElementTest();
        this.populateIDLElementTest(test);
        IDLElementTestPubSubType type = new IDLElementTestPubSubType();
        SerializedPayload payload = new SerializedPayload(type.getTypeSize());
        type.serialize(test, payload);
        byte[] javadata = new byte[payload.getLength()];
        payload.getData().get(javadata);
        IDLElementTest cppElement = new IDLElementTest();
        SerializedPayload cppPayload = new SerializedPayload(type.getTypeSize());
        cppPayload.getData().put(IDLElementTestCPPData.cppData);
        cppPayload.getData().flip();
        cppPayload.setLength(IDLElementTestCPPData.cppData.length);
        type.deserialize(cppPayload, cppElement);
        Assertions.assertArrayEquals((byte[])IDLElementTestCPPData.cppData, (byte[])javadata);
        Assertions.assertEquals((Object)((Object)cppElement), (Object)((Object)test));
    }
}

