/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import com.eprosima.xmlschemas.fastrtps_profiles.DurabilityQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.HistoryQosKindType;
import com.eprosima.xmlschemas.fastrtps_profiles.ReliabilityQosKindType;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.idl.generated.chat.ChatMessage;
import us.ihmc.idl.generated.chat.ChatMessagePubSubType;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class MultipleParticipantsInSameProcessTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestMulitpleParticipantsInSameProcess() throws IOException, InterruptedException {
        AtomicInteger counter = new AtomicInteger(0);
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
        try {
            ChatMessagePubSubType topicDataType = new ChatMessagePubSubType();
            PublisherAttributes genericPublisherAttributes = (PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)((PublisherAttributes)PublisherAttributes.create().topicDataType((TopicDataType)topicDataType)).topicName("Status")).reliabilityKind(ReliabilityQosKindType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindType.TRANSIENT_LOCAL)).historyQosPolicyKind(HistoryQosKindType.KEEP_LAST)).historyDepth(10);
            SubscriberAttributes subscriberAttributes = (SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)((SubscriberAttributes)SubscriberAttributes.create().topicDataType((TopicDataType)topicDataType)).topicName("Status")).reliabilityKind(ReliabilityQosKindType.RELIABLE)).partitions(Collections.singletonList("us/ihmc"))).durabilityKind(DurabilityQosKindType.TRANSIENT_LOCAL)).historyQosPolicyKind(HistoryQosKindType.KEEP_ALL);
            List participants = IntStream.rangeClosed(1, 100).mapToObj(i -> ParticipantAttributes.create().domainId(217).discoveryLeaseDuration(Time.Infinite).name("StatusTest" + i).useOnlySharedMemoryTransport()).map(attrs -> {
                try {
                    return domain.createParticipant(attrs);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            List publishers = participants.stream().map(p -> {
                try {
                    return domain.createPublisher(p, genericPublisherAttributes, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            Subscriber subscriber = domain.createSubscriber((Participant)participants.get(0), subscriberAttributes, (SubscriberListener)new SubscriberListenerImpl(counter));
            Thread t = new Thread(() -> {
                AtomicInteger msgCounter = new AtomicInteger();
                publishers.forEach(p -> {
                    try {
                        ChatMessage msg = new ChatMessage();
                        msg.setMsg("" + msgCounter.get());
                        p.write((Object)msg);
                        Thread.sleep(1L);
                        msgCounter.incrementAndGet();
                    }
                    catch (IOException | InterruptedException e) {
                        e.printStackTrace();
                    }
                });
            });
            t.start();
            t.join();
            Assertions.assertEquals((int)100, (int)counter.get());
        }
        finally {
            domain.stopAll();
        }
    }

    private class SubscriberListenerImpl
    implements SubscriberListener {
        AtomicInteger counter;

        public SubscriberListenerImpl(AtomicInteger counter) {
            this.counter = counter;
        }

        public void onNewDataMessage(Subscriber subscriber) {
            ChatMessage chatMessage = (ChatMessage)((Object)subscriber.takeNextData());
            Assertions.assertEquals((int)Integer.parseInt(chatMessage.getMsgAsString()), (int)this.counter.getAndIncrement());
        }

        public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
        }
    }
}

