/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import java.io.IOException;
import org.junit.jupiter.api.Test;
import us.ihmc.idl.generated.test.StatusMessage;
import us.ihmc.idl.generated.test.StatusMessagePubSubType;
import us.ihmc.pubsub.Domain;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.DurabilityKind;
import us.ihmc.pubsub.attributes.HistoryQosPolicy;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublishModeKind;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.common.Time;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;

public class PublishSubscribeUInt64Test {
    @Test
    public void testPublishSubscribeUInt32() throws IOException {
        Domain domain = DomainFactory.getDomain((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
        domain.setLogLevel(LogLevel.INFO);
        ParticipantAttributes attributes = domain.createParticipantAttributes();
        attributes.setDomainId(215);
        attributes.setLeaseDuration(Time.Infinite);
        attributes.setName("StatusTest");
        Participant participant = domain.createParticipant(attributes, (ParticipantListener)new ParticipantListenerImpl());
        StatusMessagePubSubType dataType = new StatusMessagePubSubType();
        domain.registerType(participant, (TopicDataType)dataType);
        PublisherAttributes publisherAttributes = domain.createPublisherAttributes(participant, (TopicDataType)dataType, "Status", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"});
        publisherAttributes.getQos().setDurabilityKind(DurabilityKind.TRANSIENT_LOCAL_DURABILITY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_LAST_HISTORY_QOS);
        publisherAttributes.getTopic().getHistoryQos().setDepth(50);
        publisherAttributes.getQos().setPublishMode(PublishModeKind.ASYNCHRONOUS_PUBLISH_MODE);
        StatusMessagePubSubType dataType2 = new StatusMessagePubSubType();
        SubscriberAttributes subscriberAttributes = domain.createSubscriberAttributes(participant, (TopicDataType)dataType2, "Status", ReliabilityKind.RELIABLE, new String[]{"us/ihmc"});
        subscriberAttributes.getQos().setDurabilityKind(DurabilityKind.TRANSIENT_LOCAL_DURABILITY_QOS);
        subscriberAttributes.getTopic().getHistoryQos().setKind(HistoryQosPolicy.HistoryQosPolicyKind.KEEP_ALL_HISTORY_QOS);
        Subscriber subscriber = domain.createSubscriber(participant, subscriberAttributes, (SubscriberListener)new SubscriberListenerImpl());
        Publisher publisher = domain.createPublisher(participant, publisherAttributes, (PublisherListener)new PublisherListenerImpl());
        StatusMessage msg = new StatusMessage();
        msg.setPause(false);
        msg.setSequenceId(0L);
        for (int i = 0; i < 10; ++i) {
            try {
                msg.setPause(i % 2 == 0);
                msg.setSequenceId(i);
                publisher.write((Object)msg);
                System.out.println("Publishing: " + msg.toString());
                Thread.sleep(1000L);
                ++i;
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class PublisherListenerImpl
    implements PublisherListener {
        private PublisherListenerImpl() {
        }

        public void onPublicationMatched(Publisher publisher, MatchingInfo info) {
            System.out.println("New subscriber matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }

    private class ParticipantListenerImpl
    implements ParticipantListener {
        private ParticipantListenerImpl() {
        }

        public void onParticipantDiscovery(Participant participant, ParticipantDiscoveryInfo info) {
            System.out.println("New participant discovered");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
            System.out.println("Name: " + info.getName());
        }
    }

    private class SubscriberListenerImpl
    implements SubscriberListener {
        private final StatusMessage data = new StatusMessage();
        private final SampleInfo info = new SampleInfo();

        private SubscriberListenerImpl() {
        }

        public void onNewDataMessage(Subscriber subscriber) {
            if (subscriber.takeNextData((Object)this.data, this.info)) {
                System.out.println("Received: " + this.data.toString());
            }
        }

        public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
            System.out.println("New publisher matched");
            System.out.println("Status: " + info.getStatus());
            System.out.println("Guid: " + info.getGuid().toString());
        }
    }
}

