/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pubsub.test;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.idl.generated.chat.ChatMessage;
import us.ihmc.idl.generated.chat.ChatMessagePubSubType;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.attributes.ParticipantAttributes;
import us.ihmc.pubsub.attributes.PublisherAttributes;
import us.ihmc.pubsub.attributes.ReliabilityKind;
import us.ihmc.pubsub.attributes.SubscriberAttributes;
import us.ihmc.pubsub.common.ChangeKind;
import us.ihmc.pubsub.common.DiscoveryStatus;
import us.ihmc.pubsub.common.Guid;
import us.ihmc.pubsub.common.LogLevel;
import us.ihmc.pubsub.common.MatchingInfo;
import us.ihmc.pubsub.common.SampleInfo;
import us.ihmc.pubsub.impl.intraprocess.IntraProcessDomain;
import us.ihmc.pubsub.participant.Participant;
import us.ihmc.pubsub.participant.ParticipantDiscoveryInfo;
import us.ihmc.pubsub.participant.ParticipantListener;
import us.ihmc.pubsub.participant.PublisherEndpointDiscoveryListener;
import us.ihmc.pubsub.participant.SubscriberEndpointDiscoveryListener;
import us.ihmc.pubsub.publisher.Publisher;
import us.ihmc.pubsub.publisher.PublisherListener;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.pubsub.subscriber.SubscriberListener;
import us.ihmc.pubsub.types.ByteBufferPubSubType;

public class IntraProcessDomainTest {
    private void checkMatchingInfo(MatchingInfo.MatchingStatus expectedStatus, Guid expectedGuid, MatchingInfo info) {
        Assertions.assertNotNull((Object)info);
        Assertions.assertEquals((Object)expectedStatus, (Object)info.getStatus());
        Assertions.assertEquals((Object)expectedGuid, (Object)info.getGuid());
    }

    private void checkMatchingInfo(MatchingInfo.MatchingStatus expectedStatus, Guid.GuidPrefix expectedGuidPrefix, MatchingInfo info) {
        Assertions.assertNotNull((Object)info);
        Assertions.assertEquals((Object)expectedStatus, (Object)info.getStatus());
        Assertions.assertEquals((Object)expectedGuidPrefix, (Object)info.getGuid().getGuidPrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessagePassing() throws IOException, InterruptedException {
        ChatMessagePubSubType typeOfTheDay = new ChatMessagePubSubType();
        String topic = "chat";
        String partition = "us.ihmc";
        IntraProcessDomain domain = IntraProcessDomain.getInstance();
        domain.setLogLevel(LogLevel.INFO);
        ParticipantAttributes participantAttributes = domain.createParticipantAttributes(1, "participant");
        Participant participant = domain.createParticipant(participantAttributes);
        try {
            int k;
            final ArrayBlockingQueue messageQueue = new ArrayBlockingQueue(10);
            SubscriberListener listener = new SubscriberListener(){

                public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
                }

                public void onNewDataMessage(Subscriber subscriber) {
                    ChatMessage data = new ChatMessage();
                    if (subscriber.takeNextData((Object)data, null)) {
                        messageQueue.add(data);
                    }
                }
            };
            PublisherAttributes publisherAttributes = domain.createPublisherAttributes(participant, (TopicDataType)typeOfTheDay, topic, ReliabilityKind.RELIABLE, new String[]{partition});
            Publisher publisher1 = domain.createPublisher(participant, publisherAttributes);
            SubscriberAttributes subscriberAttributes = domain.createSubscriberAttributes(participant, (TopicDataType)typeOfTheDay, topic, ReliabilityKind.RELIABLE, new String[]{partition});
            Subscriber subscriber1 = domain.createSubscriber(participant, subscriberAttributes);
            SubscriberAttributes subscriberAttributes2 = domain.createSubscriberAttributes(participant, (TopicDataType)typeOfTheDay, topic, ReliabilityKind.RELIABLE, new String[]{partition});
            Subscriber subscriber2 = domain.createSubscriber(participant, subscriberAttributes2, listener);
            SubscriberAttributes subscriberAttributes3 = domain.createSubscriberAttributes(participant, (TopicDataType)typeOfTheDay, topic, ReliabilityKind.RELIABLE, new String[0]);
            Subscriber subscriber3 = domain.createSubscriber(participant, subscriberAttributes3);
            ChatMessage msg = new ChatMessage();
            msg.setMsg("Test");
            msg.setSender("JUnit");
            publisher1.write((Object)msg);
            subscriber1.waitForUnreadMessage(100);
            ChatMessage rec = new ChatMessage();
            SampleInfo info = new SampleInfo();
            for (k = 0; k < 5 && !subscriber1.readNextData((Object)rec, info); ++k) {
                ThreadTools.sleep((long)100L);
            }
            Assertions.assertTrue((k < 5 ? 1 : 0) != 0, (String)"could not read data");
            Assertions.assertEquals((Object)((Object)msg), (Object)((Object)rec));
            subscriber1.waitForUnreadMessage(100);
            Assertions.assertTrue((boolean)subscriber1.takeNextData((Object)rec, info));
            Assertions.assertEquals((Object)((Object)msg), (Object)((Object)rec));
            Assertions.assertEquals((Object)publisher1.getGuid(), (Object)info.getSampleIdentity().getGuid());
            Assertions.assertEquals((long)0L, (long)info.getSampleIdentity().getSequenceNumber().get());
            Assertions.assertEquals((Object)ChangeKind.ALIVE, (Object)info.getSampleKind());
            Assertions.assertEquals((Object)((Object)msg), messageQueue.poll(5000L, TimeUnit.MILLISECONDS));
            Assertions.assertFalse((boolean)subscriber1.takeNextData((Object)rec, info));
            Assertions.assertFalse((boolean)subscriber2.takeNextData((Object)rec, info));
            Assertions.assertFalse((boolean)subscriber3.takeNextData((Object)msg, info));
            for (int i = 0; i < 10; ++i) {
                String msgText = "Test " + i;
                msg.setMsg(msgText);
                publisher1.write((Object)msg);
                subscriber1.waitForUnreadMessage(100);
                Assertions.assertTrue((boolean)subscriber1.takeNextData((Object)rec, info));
                Assertions.assertEquals((Object)((Object)msg), (Object)((Object)rec));
                Assertions.assertEquals((Object)msgText, (Object)rec.getMsgAsString());
                Assertions.assertEquals((Object)publisher1.getGuid(), (Object)info.getSampleIdentity().getGuid());
                Assertions.assertEquals((long)((long)i + 1L), (long)info.getSampleIdentity().getSequenceNumber().get());
                Assertions.assertEquals((Object)ChangeKind.ALIVE, (Object)info.getSampleKind());
                ChatMessage rec2 = (ChatMessage)((Object)messageQueue.poll(5000L, TimeUnit.MILLISECONDS));
                Assertions.assertEquals((Object)((Object)msg), (Object)((Object)rec2));
                Assertions.assertEquals((Object)msgText, (Object)rec2.getMsgAsString());
            }
            boolean failed = false;
            Object failure = new Object();
            try {
                publisher1.write(failure);
            }
            catch (IOException e) {
                failed = true;
            }
            Assertions.assertTrue((boolean)failed);
        }
        finally {
            domain.stopAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionLogic() throws IOException, InterruptedException {
        ArrayBlockingQueue participantListenerFuture = new ArrayBlockingQueue(1);
        ParticipantListener participantListener = (participant, info) -> participantListenerFuture.add(info);
        IntraProcessDomain domain = IntraProcessDomain.getInstance();
        domain.setLogLevel(LogLevel.INFO);
        ParticipantAttributes participantAttributes = domain.createParticipantAttributes(1, "participant");
        Participant participant2 = domain.createParticipant(participantAttributes, participantListener);
        try {
            ChatMessagePubSubType typeOfTheDay = new ChatMessagePubSubType();
            String topic = "chat";
            String partition = "us.ihmc";
            ArrayBlockingQueue publisherEndpointDiscover = new ArrayBlockingQueue(1);
            ArrayBlockingQueue subscriberEndpointDiscover = new ArrayBlockingQueue(1);
            PublisherEndpointDiscoveryListener publisherEndpointDiscoveryListener = (isAlive, guid, unicastLocatorList, multicastLocatorList, participantGuid, typeName, topicName, userDefinedId, typeMaxSerialized, topicKind, writerQosHolder) -> publisherEndpointDiscover.add(guid);
            SubscriberEndpointDiscoveryListener subscriberEndpointDiscoveryListener = (isAlive, guid, expectsInlineQos, unicastLocatorList, multicastLocatorList, participantGuid, typeName, topicName, userDefinedId, javaTopicKind, readerQosHolder) -> subscriberEndpointDiscover.add(guid);
            participant2.registerEndpointDiscoveryListeners(publisherEndpointDiscoveryListener, subscriberEndpointDiscoveryListener);
            ArrayBlockingQueue publisherMatched = new ArrayBlockingQueue(2);
            PublisherListener publisherListener = (publisher, info) -> publisherMatched.add(info);
            PublisherAttributes publisherAttributes = domain.createPublisherAttributes(participant2, (TopicDataType)typeOfTheDay, topic, ReliabilityKind.RELIABLE, new String[]{partition});
            Publisher publisher1 = domain.createPublisher(participant2, publisherAttributes, publisherListener);
            final ArrayBlockingQueue subscriberMatched = new ArrayBlockingQueue(2);
            SubscriberListener subscriberListener = new SubscriberListener(){

                public void onSubscriptionMatched(Subscriber subscriber, MatchingInfo info) {
                    subscriberMatched.add(info);
                }

                public void onNewDataMessage(Subscriber subscriber) {
                }
            };
            SubscriberAttributes subscriberAttributes = domain.createSubscriberAttributes(participant2, (TopicDataType)typeOfTheDay, topic, ReliabilityKind.RELIABLE, new String[]{partition});
            Subscriber subscriber1 = domain.createSubscriber(participant2, subscriberAttributes, subscriberListener);
            Assertions.assertEquals((Object)publisher1.getGuid(), publisherEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((Object)subscriber1.getGuid(), subscriberEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.MATCHED_MATCHING, subscriber1.getGuid(), (MatchingInfo)publisherMatched.poll(1L, TimeUnit.SECONDS));
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.MATCHED_MATCHING, publisher1.getGuid(), (MatchingInfo)subscriberMatched.poll(1L, TimeUnit.SECONDS));
            Subscriber subscriber2 = domain.createSubscriber(participant2, subscriberAttributes);
            Assertions.assertEquals((Object)subscriber2.getGuid(), subscriberEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.MATCHED_MATCHING, subscriber2.getGuid(), (MatchingInfo)publisherMatched.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((long)1L, (long)participant2.get_no_publisher(topic));
            Assertions.assertEquals((long)2L, (long)participant2.get_no_subscribers(topic));
            Participant participant22 = domain.createParticipant(domain.createParticipantAttributes(1, "participant2"));
            ParticipantDiscoveryInfo participant2info = (ParticipantDiscoveryInfo)participantListenerFuture.poll(1L, TimeUnit.SECONDS);
            Assertions.assertNotEquals(null, (Object)participant2info);
            Assertions.assertEquals((Object)DiscoveryStatus.DISCOVERED_RTPSPARTICIPANT, (Object)participant2info.getStatus());
            Assertions.assertEquals((Object)participant22.getGuid(), (Object)participant2info.getGuid());
            Assertions.assertEquals((Object)"participant2", (Object)participant2info.getName());
            PublisherAttributes pubAtt2 = domain.createPublisherAttributes(participant22, (TopicDataType)typeOfTheDay, topic, ReliabilityKind.RELIABLE, new String[]{partition});
            Guid guid2 = domain.createPublisher(participant22, pubAtt2).getGuid();
            Assertions.assertEquals((Object)guid2, publisherEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.MATCHED_MATCHING, guid2, (MatchingInfo)subscriberMatched.poll(1L, TimeUnit.SECONDS));
            guid2 = domain.createPublisher(participant22, pubAtt2).getGuid();
            Assertions.assertEquals((Object)guid2, publisherEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.MATCHED_MATCHING, guid2, (MatchingInfo)subscriberMatched.poll(1L, TimeUnit.SECONDS));
            SubscriberAttributes subAtt2 = domain.createSubscriberAttributes(participant22, (TopicDataType)typeOfTheDay, topic, ReliabilityKind.BEST_EFFORT, new String[]{partition});
            guid2 = domain.createSubscriber(participant22, subAtt2).getGuid();
            Assertions.assertEquals((Object)guid2, subscriberEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.MATCHED_MATCHING, guid2, (MatchingInfo)publisherMatched.poll(1L, TimeUnit.SECONDS));
            guid2 = domain.createSubscriber(participant22, subAtt2).getGuid();
            Assertions.assertEquals((Object)guid2, subscriberEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.MATCHED_MATCHING, guid2, (MatchingInfo)publisherMatched.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((long)2L, (long)participant22.get_no_publisher(topic));
            Assertions.assertEquals((long)2L, (long)participant22.get_no_subscribers(topic));
            PublisherAttributes pubAtt3 = domain.createPublisherAttributes(participant22, (TopicDataType)typeOfTheDay, topic, ReliabilityKind.BEST_EFFORT, new String[]{partition});
            guid2 = domain.createPublisher(participant22, pubAtt3).getGuid();
            Assertions.assertEquals((Object)guid2, publisherEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            PublisherAttributes pubAtt4 = domain.createPublisherAttributes(participant22, (TopicDataType)typeOfTheDay, topic, ReliabilityKind.RELIABLE, new String[0]);
            guid2 = domain.createPublisher(participant22, pubAtt4).getGuid();
            Assertions.assertEquals((Object)guid2, publisherEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            PublisherAttributes pubAtt5 = domain.createPublisherAttributes(participant22, (TopicDataType)typeOfTheDay, topic + "Invalid", ReliabilityKind.RELIABLE, new String[]{partition});
            guid2 = domain.createPublisher(participant22, pubAtt5).getGuid();
            Assertions.assertEquals((Object)guid2, publisherEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            ByteBufferPubSubType newDataType = new ByteBufferPubSubType("Test", 10);
            PublisherAttributes pubAtt6 = domain.createPublisherAttributes(participant22, (TopicDataType)newDataType, topic, ReliabilityKind.RELIABLE, new String[]{partition});
            guid2 = domain.createPublisher(participant22, pubAtt6).getGuid();
            Assertions.assertEquals((Object)guid2, publisherEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals(null, subscriberMatched.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((long)5L, (long)participant22.get_no_publisher(topic));
            Assertions.assertEquals((long)1L, (long)participant22.get_no_publisher(topic + "Invalid"));
            SubscriberAttributes subAtt3 = domain.createSubscriberAttributes(participant22, (TopicDataType)typeOfTheDay, topic, ReliabilityKind.BEST_EFFORT, new String[0]);
            guid2 = domain.createSubscriber(participant22, subAtt3).getGuid();
            Assertions.assertEquals((Object)guid2, subscriberEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            SubscriberAttributes subAtt4 = domain.createSubscriberAttributes(participant22, (TopicDataType)typeOfTheDay, topic + "Invalid", ReliabilityKind.BEST_EFFORT, new String[]{partition});
            guid2 = domain.createSubscriber(participant22, subAtt4).getGuid();
            Assertions.assertEquals((Object)guid2, subscriberEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            SubscriberAttributes subAtt5 = domain.createSubscriberAttributes(participant22, (TopicDataType)newDataType, topic, ReliabilityKind.BEST_EFFORT, new String[]{partition});
            guid2 = domain.createSubscriber(participant22, subAtt5).getGuid();
            Assertions.assertEquals((Object)guid2, subscriberEndpointDiscover.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((long)4L, (long)participant22.get_no_subscribers(topic));
            Assertions.assertEquals((long)1L, (long)participant22.get_no_subscribers(topic + "Invalid"));
            Assertions.assertEquals(null, publisherMatched.poll(1L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)publisher1.isAvailable());
            Assertions.assertTrue((boolean)subscriber2.isAvailable());
            domain.removeParticipant(participant22);
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.REMOVED_MATCHING, participant22.getGuid().getGuidPrefix(), (MatchingInfo)publisherMatched.poll(1L, TimeUnit.SECONDS));
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.REMOVED_MATCHING, participant22.getGuid().getGuidPrefix(), (MatchingInfo)publisherMatched.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals(null, publisherMatched.poll(1L, TimeUnit.SECONDS));
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.REMOVED_MATCHING, participant22.getGuid().getGuidPrefix(), (MatchingInfo)subscriberMatched.poll(1L, TimeUnit.SECONDS));
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.REMOVED_MATCHING, participant22.getGuid().getGuidPrefix(), (MatchingInfo)subscriberMatched.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals(null, subscriberMatched.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((long)0L, (long)participant22.get_no_publisher(topic));
            Assertions.assertEquals((long)0L, (long)participant22.get_no_publisher(topic + "Invalid"));
            Assertions.assertEquals((long)0L, (long)participant22.get_no_subscribers(topic));
            Assertions.assertEquals((long)0L, (long)participant22.get_no_subscribers(topic + "Invalid"));
            domain.removeSubscriber(subscriber2);
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.REMOVED_MATCHING, subscriber2.getGuid(), (MatchingInfo)publisherMatched.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals(null, subscriberMatched.poll(1L, TimeUnit.SECONDS));
            domain.removePublisher(publisher1);
            this.checkMatchingInfo(MatchingInfo.MatchingStatus.REMOVED_MATCHING, publisher1.getGuid(), (MatchingInfo)subscriberMatched.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals(null, publisherMatched.poll(1L, TimeUnit.SECONDS));
            Assertions.assertEquals((long)0L, (long)participant2.get_no_publisher(topic));
            Assertions.assertEquals((long)1L, (long)participant2.get_no_subscribers(topic));
            Assertions.assertFalse((boolean)publisher1.isAvailable());
            Assertions.assertFalse((boolean)subscriber2.isAvailable());
            Assertions.assertTrue((boolean)subscriber1.isAvailable());
            Assertions.assertTrue((boolean)participant2.isAvailable());
            Assertions.assertFalse((boolean)participant22.isAvailable());
        }
        finally {
            domain.stopAll();
        }
    }
}

