/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.perception.zedDriver;

import us.ihmc.log.LogTools;
import us.ihmc.tools.nativelibraries.NativeLibraryDescription;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;
import us.ihmc.tools.nativelibraries.NativeLibraryWithDependencies;

public class ZedDriverNativeLibrary
implements NativeLibraryDescription {
    private static boolean loaded = false;

    public String getPackage(NativeLibraryDescription.OperatingSystem os, NativeLibraryDescription.Architecture arch) {
        String archPackage = "";
        if (arch == NativeLibraryDescription.Architecture.x64) {
            archPackage = switch (os) {
                case NativeLibraryDescription.OperatingSystem.LINUX64 -> "linux-x86_64";
                default -> "unknown";
            };
        }
        return "zedDriver." + archPackage;
    }

    public NativeLibraryWithDependencies getLibraryWithDependencies(NativeLibraryDescription.OperatingSystem os, NativeLibraryDescription.Architecture arch) {
        switch (os) {
            case LINUX64: {
                return NativeLibraryWithDependencies.fromFilename((String)"libjniZEDOpenDriver.so", (String[])new String[]{"libzed-driver.so"});
            }
        }
        LogTools.warn((String)("Unsupported platform: " + os.name() + "-" + arch.name()));
        return null;
    }

    public static boolean load() {
        if (!loaded) {
            ZedDriverNativeLibrary zedWrapperNativeLibrary = new ZedDriverNativeLibrary();
            loaded = NativeLibraryLoader.loadLibrary((NativeLibraryDescription)zedWrapperNativeLibrary);
        }
        return loaded;
    }
}

