/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.visualizer;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.MeshView;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javaFXToolkit.shapes.JavaFXMeshBuilder;
import us.ihmc.pathPlanning.visibilityGraphs.ui.messager.UIVisibilityGraphsTopics;

public class WalkerCollisionsViewer
extends AnimationTimer {
    private static final double COLLISION_SIZE = 0.1;
    private final Group root = new Group();
    private final AtomicReference<MeshView> collisionGraphics = new AtomicReference<Object>(null);
    private final AtomicReference<Boolean> reset;

    public WalkerCollisionsViewer(JavaFXMessager messager) {
        messager.registerTopicListener(UIVisibilityGraphsTopics.WalkerCollisionLocations, this::processCollisions);
        this.reset = messager.createInput(UIVisibilityGraphsTopics.GlobalReset, (Object)false);
    }

    public void handle(long now) {
        MeshView meshView;
        if (this.reset.getAndSet(false).booleanValue()) {
            this.root.getChildren().clear();
        }
        if ((meshView = (MeshView)this.collisionGraphics.getAndSet(null)) != null) {
            this.root.getChildren().add((Object)meshView);
        }
    }

    private void processCollisions(List<Point3D> collisions) {
        JavaFXMeshBuilder meshBuilder = new JavaFXMeshBuilder();
        for (Point3D collision : collisions) {
            meshBuilder.addTetrahedron(0.1, (Tuple3DReadOnly)collision);
        }
        MeshView meshView = new MeshView(meshBuilder.generateMesh());
        meshView.setMaterial((Material)new PhongMaterial(Color.RED));
        this.collisionGraphics.set(meshView);
    }

    public Node getRoot() {
        return this.root;
    }
}

