/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.Cluster;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.ExtrusionHull;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.Connection;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.ConnectionPoint3D;
import us.ihmc.pathPlanning.visibilityGraphs.tools.PointCloudTools;
import us.ihmc.pathPlanning.visibilityGraphs.tools.VisibilityTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;

public class VisibilityToolsTest {
    private static final double EPSILON = 1.0E-12;
    private static final int iters = 1000;

    @Test
    public void testIsPointVisibleForStaticMaps() {
        Cluster keepOutClusterOne = new Cluster(Cluster.ExtrusionSide.OUTSIDE, Cluster.ClusterType.POLYGON);
        ExtrusionHull clusterOne = new ExtrusionHull();
        clusterOne.addPoint((Point2DReadOnly)new Point2D(-0.1, 0.5));
        clusterOne.addPoint((Point2DReadOnly)new Point2D(1.1, 0.5));
        keepOutClusterOne.addNonNavigableExtrusionsInLocal(clusterOne);
        Cluster keepOutClusterTwo = new Cluster(Cluster.ExtrusionSide.OUTSIDE, Cluster.ClusterType.POLYGON);
        ExtrusionHull clusterTwo = new ExtrusionHull();
        clusterTwo.addPoint((Point2DReadOnly)new Point2D(2.5, -0.1));
        clusterTwo.addPoint((Point2DReadOnly)new Point2D(2.5, 1.1));
        keepOutClusterTwo.addNonNavigableExtrusionsInLocal(clusterTwo);
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        clusters.add(keepOutClusterOne);
        clusters.add(keepOutClusterTwo);
        Point2D pointA = new Point2D(0.0, 0.0);
        Point2D pointB = new Point2D(1.0, 0.0);
        Point2D pointC = new Point2D(1.0, 1.0);
        Point2D pointD = new Point2D(0.0, 1.0);
        Point2D pointE = new Point2D(2.0, 0.0);
        Point2D pointF = new Point2D(3.0, 0.0);
        Point2D pointG = new Point2D(3.0, 1.0);
        Point2D pointH = new Point2D(2.0, 1.0);
        Assert.assertTrue((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointA, (Point2DReadOnly)pointB));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointA, (Point2DReadOnly)pointC));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointA, (Point2DReadOnly)pointD));
        Assert.assertTrue((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointA, (Point2DReadOnly)pointE));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointA, (Point2DReadOnly)pointF));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointA, (Point2DReadOnly)pointG));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointA, (Point2DReadOnly)pointH));
        Assert.assertTrue((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointB, (Point2DReadOnly)pointA));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointB, (Point2DReadOnly)pointC));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointB, (Point2DReadOnly)pointD));
        Assert.assertTrue((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointB, (Point2DReadOnly)pointE));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointB, (Point2DReadOnly)pointF));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointB, (Point2DReadOnly)pointG));
        Assert.assertTrue((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointB, (Point2DReadOnly)pointH));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointC, (Point2DReadOnly)pointA));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointC, (Point2DReadOnly)pointB));
        Assert.assertTrue((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointC, (Point2DReadOnly)pointD));
        Assert.assertTrue((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointC, (Point2DReadOnly)pointE));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointC, (Point2DReadOnly)pointF));
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointC, (Point2DReadOnly)pointG));
        Assert.assertTrue((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(clusters, (Point2DReadOnly)pointC, (Point2DReadOnly)pointH));
    }

    @Test
    public void testDistanceFromConnectionToCluster() {
        Point2D leftWallPoint = new Point2D(0.5, 0.0);
        Point2D rightWallPoint = new Point2D(-0.5, 0.0);
        double fortyFive = Math.sin(0.7853981633974483);
        ArrayList<Point2D> pointsInCluster = new ArrayList<Point2D>();
        pointsInCluster.add(new Point2D(0.6, 0.0));
        pointsInCluster.add(new Point2D(0.1 * fortyFive + 0.5, 0.1 * fortyFive));
        pointsInCluster.add(new Point2D(0.5, 0.1));
        pointsInCluster.add(new Point2D(-0.5, 0.1));
        pointsInCluster.add(new Point2D(-0.1 * fortyFive - 0.5, 0.1 * fortyFive));
        pointsInCluster.add(new Point2D(-0.6, 0.0));
        pointsInCluster.add(new Point2D(-0.1 * fortyFive - 0.5, -0.1 * fortyFive));
        pointsInCluster.add(new Point2D(-0.5, -0.1));
        pointsInCluster.add(new Point2D(0.5, -0.1));
        pointsInCluster.add(new Point2D(0.1 * fortyFive + 0.5, -0.1 * fortyFive));
        Point2D firstPointLeftVertical = new Point2D(0.7, -0.2);
        Point2D secondPointLeftVertical = new Point2D(0.7, 0.2);
        Point2D closestPointOnLeftVerticalLine = new Point2D();
        Point2D closestPointOnLeftVerticalCluster = new Point2D();
        Point2D closestPointOnLeftVerticalLineExpected = new Point2D(0.7, 0.0);
        Point2D closestPointOnLeftVerticalClusterExpected = new Point2D(0.6, 0.0);
        double distance = VisibilityTools.distanceToCluster((Point2DReadOnly)firstPointLeftVertical, (Point2DReadOnly)secondPointLeftVertical, pointsInCluster, (Point2DBasics)closestPointOnLeftVerticalLine, (Point2DBasics)closestPointOnLeftVerticalCluster, null, (boolean)true);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)closestPointOnLeftVerticalClusterExpected, (Point2DReadOnly)closestPointOnLeftVerticalCluster, (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)closestPointOnLeftVerticalLineExpected, (Point2DReadOnly)closestPointOnLeftVerticalLine, (double)1.0E-12);
        Assert.assertEquals((double)0.1, (double)distance, (double)1.0E-12);
        Point2D firstPointRightVertical = new Point2D(-0.7, -0.2);
        Point2D secondPointRightVertical = new Point2D(-0.7, 0.2);
        Point2D closestPointOnRightVerticalLine = new Point2D();
        Point2D closestPointOnRightVerticalCluster = new Point2D();
        Point2D closestPointOnRightVerticalLineExpected = new Point2D(-0.7, 0.0);
        Point2D closestPointOnRightVerticalClusterExpected = new Point2D(-0.6, 0.0);
        distance = VisibilityTools.distanceToCluster((Point2DReadOnly)firstPointRightVertical, (Point2DReadOnly)secondPointRightVertical, pointsInCluster, (Point2DBasics)closestPointOnRightVerticalLine, (Point2DBasics)closestPointOnRightVerticalCluster, null, (boolean)true);
        Assert.assertEquals((double)0.1, (double)distance, (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)closestPointOnRightVerticalClusterExpected, (Point2DReadOnly)closestPointOnRightVerticalCluster, (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)closestPointOnRightVerticalLineExpected, (Point2DReadOnly)closestPointOnRightVerticalLine, (double)1.0E-12);
        Point2D firstPointAboveHorizontal = new Point2D(0.7, 0.2);
        Point2D secondPointAboveHorizontal = new Point2D(-0.7, 0.2);
        Point2D closestPointOnAboveHorizontalLine = new Point2D();
        Point2D closestPointOnAboveHorizontalCluster = new Point2D();
        Point2D closestPointOnAboveHorizontalLineExpected = new Point2D(0.5, 0.2);
        Point2D closestPointOnAboveHorizontalClusterExpected = new Point2D(0.5, 0.1);
        distance = VisibilityTools.distanceToCluster((Point2DReadOnly)firstPointAboveHorizontal, (Point2DReadOnly)secondPointAboveHorizontal, pointsInCluster, (Point2DBasics)closestPointOnAboveHorizontalLine, (Point2DBasics)closestPointOnAboveHorizontalCluster, null, (boolean)true);
        Assert.assertEquals((double)0.1, (double)distance, (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)closestPointOnAboveHorizontalClusterExpected, (Point2DReadOnly)closestPointOnAboveHorizontalCluster, (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)closestPointOnAboveHorizontalLineExpected, (Point2DReadOnly)closestPointOnAboveHorizontalLine, (double)1.0E-12);
    }

    @Test
    public void testIsPointVisibleThroughPreferredRegion() {
        double navEpsilon = 0.005;
        ExtrusionHull nonNavigableExtrusions = new ExtrusionHull();
        nonNavigableExtrusions.addPoint((Point2DReadOnly)new Point2D(10.0, 4.0));
        nonNavigableExtrusions.addPoint((Point2DReadOnly)new Point2D(10.0, -4.0));
        nonNavigableExtrusions.addPoint((Point2DReadOnly)new Point2D(-10.0, -4.0));
        nonNavigableExtrusions.addPoint((Point2DReadOnly)new Point2D(-10.0, 4.0));
        ExtrusionHull navigableExtrusions = new ExtrusionHull();
        navigableExtrusions.addPoint((Point2DReadOnly)new Point2D(10.0 - navEpsilon, 4.0 - navEpsilon));
        navigableExtrusions.addPoint((Point2DReadOnly)new Point2D(10.0 - navEpsilon, -4.0 + navEpsilon));
        navigableExtrusions.addPoint((Point2DReadOnly)new Point2D(-10.0 + navEpsilon, -4.0 + navEpsilon));
        navigableExtrusions.addPoint((Point2DReadOnly)new Point2D(-10.0 + navEpsilon, 4.0 - navEpsilon));
        ExtrusionHull preferredNonNavigableExtrusion0 = new ExtrusionHull();
        ExtrusionHull preferredNonNavigableExtrusion1 = new ExtrusionHull();
        ExtrusionHull preferredNonNavigableExtrusion2 = new ExtrusionHull();
        ExtrusionHull preferredNonNavigableExtrusion3 = new ExtrusionHull();
        ExtrusionHull preferredNavigableExtrusion0 = new ExtrusionHull();
        ExtrusionHull preferredNavigableExtrusion1 = new ExtrusionHull();
        ExtrusionHull preferredNavigableExtrusion2 = new ExtrusionHull();
        ExtrusionHull preferredNavigableExtrusion3 = new ExtrusionHull();
        preferredNonNavigableExtrusion0.addPoint((Point2DReadOnly)new Point2D(-9.5, 3.5));
        preferredNonNavigableExtrusion0.addPoint((Point2DReadOnly)new Point2D(-5.5, 3.5));
        preferredNonNavigableExtrusion0.addPoint((Point2DReadOnly)new Point2D(-5.5, -3.5));
        preferredNonNavigableExtrusion0.addPoint((Point2DReadOnly)new Point2D(-9.5, -3.5));
        preferredNavigableExtrusion0.addPoint((Point2DReadOnly)new Point2D(-9.5 + navEpsilon, 3.5 - navEpsilon));
        preferredNavigableExtrusion0.addPoint((Point2DReadOnly)new Point2D(-5.5 - navEpsilon, 3.5 - navEpsilon));
        preferredNavigableExtrusion0.addPoint((Point2DReadOnly)new Point2D(-5.5 - navEpsilon, -3.5 + navEpsilon));
        preferredNavigableExtrusion0.addPoint((Point2DReadOnly)new Point2D(-9.5 + navEpsilon, -3.5 + navEpsilon));
        preferredNonNavigableExtrusion1.addPoint((Point2DReadOnly)new Point2D(-4.5, 3.5));
        preferredNonNavigableExtrusion1.addPoint((Point2DReadOnly)new Point2D(-0.5, 3.5));
        preferredNonNavigableExtrusion1.addPoint((Point2DReadOnly)new Point2D(-0.5, -3.5));
        preferredNonNavigableExtrusion1.addPoint((Point2DReadOnly)new Point2D(-4.5, -3.5));
        preferredNavigableExtrusion1.addPoint((Point2DReadOnly)new Point2D(-4.5 + navEpsilon, 3.5 - navEpsilon));
        preferredNavigableExtrusion1.addPoint((Point2DReadOnly)new Point2D(-0.5 - navEpsilon, 3.5 - navEpsilon));
        preferredNavigableExtrusion1.addPoint((Point2DReadOnly)new Point2D(-0.5 - navEpsilon, -3.5 + navEpsilon));
        preferredNavigableExtrusion1.addPoint((Point2DReadOnly)new Point2D(-4.5 + navEpsilon, -3.5 + navEpsilon));
        preferredNonNavigableExtrusion2.addPoint((Point2DReadOnly)new Point2D(4.5, 3.5));
        preferredNonNavigableExtrusion2.addPoint((Point2DReadOnly)new Point2D(4.5, -3.5));
        preferredNonNavigableExtrusion2.addPoint((Point2DReadOnly)new Point2D(0.5, -3.5));
        preferredNonNavigableExtrusion2.addPoint((Point2DReadOnly)new Point2D(0.5, 3.5));
        preferredNavigableExtrusion2.addPoint((Point2DReadOnly)new Point2D(4.5 - navEpsilon, 3.5 - navEpsilon));
        preferredNavigableExtrusion2.addPoint((Point2DReadOnly)new Point2D(4.5 - navEpsilon, -3.5 + navEpsilon));
        preferredNavigableExtrusion2.addPoint((Point2DReadOnly)new Point2D(0.5 + navEpsilon, -3.5 + navEpsilon));
        preferredNavigableExtrusion2.addPoint((Point2DReadOnly)new Point2D(0.5 + navEpsilon, 3.5 - navEpsilon));
        preferredNonNavigableExtrusion3.addPoint((Point2DReadOnly)new Point2D(9.5, 3.5));
        preferredNonNavigableExtrusion3.addPoint((Point2DReadOnly)new Point2D(9.5, -3.5));
        preferredNonNavigableExtrusion3.addPoint((Point2DReadOnly)new Point2D(5.5, -3.5));
        preferredNonNavigableExtrusion3.addPoint((Point2DReadOnly)new Point2D(5.5, 3.5));
        preferredNavigableExtrusion3.addPoint((Point2DReadOnly)new Point2D(9.5 - navEpsilon, 3.5 - navEpsilon));
        preferredNavigableExtrusion3.addPoint((Point2DReadOnly)new Point2D(9.5 - navEpsilon, -3.5 + navEpsilon));
        preferredNavigableExtrusion3.addPoint((Point2DReadOnly)new Point2D(5.5 + navEpsilon, -3.5 + navEpsilon));
        preferredNavigableExtrusion3.addPoint((Point2DReadOnly)new Point2D(5.5 + navEpsilon, 3.5 - navEpsilon));
        navigableExtrusions = PointCloudTools.addPointsAlongExtrusionHull((ExtrusionHull)navigableExtrusions, (double)0.2);
        preferredNavigableExtrusion0 = PointCloudTools.addPointsAlongExtrusionHull((ExtrusionHull)preferredNavigableExtrusion0, (double)0.2);
        preferredNavigableExtrusion1 = PointCloudTools.addPointsAlongExtrusionHull((ExtrusionHull)preferredNavigableExtrusion1, (double)0.2);
        preferredNavigableExtrusion2 = PointCloudTools.addPointsAlongExtrusionHull((ExtrusionHull)preferredNavigableExtrusion2, (double)0.2);
        preferredNavigableExtrusion3 = PointCloudTools.addPointsAlongExtrusionHull((ExtrusionHull)preferredNavigableExtrusion3, (double)0.2);
        Cluster cluster = new Cluster(Cluster.ExtrusionSide.INSIDE, Cluster.ClusterType.POLYGON);
        cluster.addNonNavigableExtrusionsInLocal(nonNavigableExtrusions);
        cluster.addNavigableExtrusionsInLocal(navigableExtrusions);
        cluster.addPreferredNavigableExtrusionInLocal(preferredNavigableExtrusion0);
        cluster.addPreferredNavigableExtrusionInLocal(preferredNavigableExtrusion1);
        cluster.addPreferredNavigableExtrusionInLocal(preferredNavigableExtrusion2);
        cluster.addPreferredNavigableExtrusionInLocal(preferredNavigableExtrusion3);
        cluster.addPreferredNonNavigableExtrusionInLocal(preferredNonNavigableExtrusion0);
        cluster.addPreferredNonNavigableExtrusionInLocal(preferredNonNavigableExtrusion1);
        cluster.addPreferredNonNavigableExtrusionInLocal(preferredNonNavigableExtrusion2);
        cluster.addPreferredNonNavigableExtrusionInLocal(preferredNonNavigableExtrusion3);
        ArrayList<Cluster> allClusters = new ArrayList<Cluster>();
        allClusters.add(cluster);
        ArrayList<ExtrusionHull> preferredNavigableExtrusions = new ArrayList<ExtrusionHull>();
        preferredNavigableExtrusions.add(preferredNavigableExtrusion0);
        preferredNavigableExtrusions.add(preferredNavigableExtrusion1);
        preferredNavigableExtrusions.add(preferredNavigableExtrusion2);
        preferredNavigableExtrusions.add(preferredNavigableExtrusion3);
        for (ExtrusionHull preferredNavigableExtrusion : preferredNavigableExtrusions) {
            for (Point2DReadOnly point : preferredNavigableExtrusion.getPoints()) {
                for (Point2DReadOnly otherPoint : preferredNavigableExtrusion.getPoints()) {
                    if (otherPoint == point) continue;
                    Assert.assertTrue((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(allClusters, (Point2DReadOnly)point, (Point2DReadOnly)otherPoint, (boolean)true));
                }
            }
        }
        ConvexPolygon2D nonNavigableExtrusion0 = new ConvexPolygon2D();
        preferredNonNavigableExtrusion0.getPoints().forEach(arg_0 -> ((ConvexPolygon2D)nonNavigableExtrusion0).addVertex(arg_0));
        nonNavigableExtrusion0.update();
        Point2D observer = new Point2D(-9.5 + navEpsilon, 0.0);
        Point2D target = new Point2D(-4.5 + navEpsilon, 0.0);
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(allClusters, (Point2DReadOnly)observer, (Point2DReadOnly)target, (boolean)true));
        Random random = new Random(1738L);
        for (int iter = 0; iter < 1000; ++iter) {
            for (ExtrusionHull preferredNavigableExtrusion : preferredNavigableExtrusions) {
                for (ExtrusionHull otherPreferredExtrusion : preferredNavigableExtrusions) {
                    if (preferredNavigableExtrusion == otherPreferredExtrusion) continue;
                    Point2DReadOnly interiorPoint = VisibilityToolsTest.createRandomInteriorPoint(preferredNavigableExtrusion.getPoints(), random);
                    Point2DReadOnly otherInteriorPoint = VisibilityToolsTest.createRandomInteriorPoint(preferredNavigableExtrusion.getPoints(), random);
                    Assert.assertTrue((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(allClusters, (Point2DReadOnly)interiorPoint, (Point2DReadOnly)otherInteriorPoint, (boolean)true));
                }
            }
        }
    }

    private static Point2DReadOnly createRandomInteriorPoint(List<Point2DReadOnly> points, Random random) {
        Point2D interiorPoint = new Point2D();
        double cumulative = 0.0;
        for (int i = 0; i < points.size(); ++i) {
            double fraction = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)(1.0 - cumulative));
            cumulative += fraction;
            interiorPoint.scaleAdd(fraction, (Tuple2DReadOnly)points.get(i));
        }
        return interiorPoint;
    }

    @Test
    public void testIsPointVisibleTroublingCase() {
        ArrayList<Point2D> listOfPointsInCluster = new ArrayList<Point2D>();
        listOfPointsInCluster.add(new Point2D(0.101, 0.5));
        listOfPointsInCluster.add(new Point2D(0.115, 0.535));
        listOfPointsInCluster.add(new Point2D(0.15, 0.549));
        listOfPointsInCluster.add(new Point2D(0.45, 0.549));
        listOfPointsInCluster.add(new Point2D(0.485, 0.535));
        listOfPointsInCluster.add(new Point2D(0.499, 0.5));
        listOfPointsInCluster.add(new Point2D(0.499, -0.5));
        listOfPointsInCluster.add(new Point2D(0.485, -0.535));
        listOfPointsInCluster.add(new Point2D(0.45, -0.549));
        listOfPointsInCluster.add(new Point2D(0.15, -0.549));
        listOfPointsInCluster.add(new Point2D(0.115, -0.535));
        listOfPointsInCluster.add(new Point2D(0.101, -0.5));
        Point2D observer = new Point2D(-0.005, 0.0);
        Point2D target = new Point2D(0.131, 0.0);
        Assert.assertFalse((boolean)VisibilityTools.isPointVisible((Point2DReadOnly)observer, (Point2DReadOnly)target, listOfPointsInCluster, (boolean)true));
        listOfPointsInCluster = new ArrayList();
        listOfPointsInCluster.add(new Point2D(0.10099999999999998, 0.5));
        listOfPointsInCluster.add(new Point2D(0.11535176772185912, 0.5346482322781408));
        listOfPointsInCluster.add(new Point2D(0.14999999999999997, 0.549));
        listOfPointsInCluster.add(new Point2D(0.45, 0.549));
        listOfPointsInCluster.add(new Point2D(0.48464823227814086, 0.5346482322781408));
        listOfPointsInCluster.add(new Point2D(0.49900000000000005, 0.5));
        listOfPointsInCluster.add(new Point2D(0.49900000000000005, -0.5));
        listOfPointsInCluster.add(new Point2D(0.48464823227814086, -0.5346482322781408));
        listOfPointsInCluster.add(new Point2D(0.45, -0.549));
        listOfPointsInCluster.add(new Point2D(0.14999999999999997, -0.549));
        listOfPointsInCluster.add(new Point2D(0.11535176772185912, -0.5346482322781408));
        listOfPointsInCluster.add(new Point2D(0.10099999999999998, -0.5));
        observer = new Point2D(-0.0047499999999999765, 0.0);
        target = new Point2D(0.1305, 0.0);
        Assert.assertFalse((boolean)VisibilityTools.isPointVisible((Point2DReadOnly)observer, (Point2DReadOnly)target, listOfPointsInCluster, (boolean)true));
    }

    @Test
    public void testIsPointVisibleForStaticMapsClosedPolygonVsOpenMultiLine() {
        Cluster keepOutClusterPolygon = new Cluster(Cluster.ExtrusionSide.OUTSIDE, Cluster.ClusterType.POLYGON);
        ExtrusionHull polygonPoints = new ExtrusionHull();
        polygonPoints.addPoint((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygonPoints.addPoint((Point2DReadOnly)new Point2D(0.0, 1.0));
        polygonPoints.addPoint((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygonPoints.addPoint((Point2DReadOnly)new Point2D(1.0, 0.0));
        keepOutClusterPolygon.addNonNavigableExtrusionsInLocal(polygonPoints);
        Cluster keepOutClusterMultiline = new Cluster(Cluster.ExtrusionSide.INSIDE, Cluster.ClusterType.MULTI_LINE);
        ExtrusionHull multilinePoints = new ExtrusionHull();
        multilinePoints.addPoint((Point2DReadOnly)new Point2D(0.0, 0.0));
        multilinePoints.addPoint((Point2DReadOnly)new Point2D(0.0, 1.0));
        multilinePoints.addPoint((Point2DReadOnly)new Point2D(1.0, 1.0));
        multilinePoints.addPoint((Point2DReadOnly)new Point2D(1.0, 0.0));
        keepOutClusterMultiline.addNonNavigableExtrusionsInLocal(multilinePoints);
        Point2D pointOutside = new Point2D(0.5, -1.0);
        Point2D pointInside = new Point2D(0.5, 0.5);
        ArrayList<Cluster> polygonClusters = new ArrayList<Cluster>();
        polygonClusters.add(keepOutClusterPolygon);
        Assert.assertFalse((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(polygonClusters, (Point2DReadOnly)pointOutside, (Point2DReadOnly)pointInside));
        ArrayList<Cluster> multilineClusters = new ArrayList<Cluster>();
        multilineClusters.add(keepOutClusterMultiline);
        Assert.assertTrue((boolean)VisibilityTools.isPointVisibleToPointInSameRegion(multilineClusters, (Point2DReadOnly)pointOutside, (Point2DReadOnly)pointInside));
    }

    private PlanarRegion createAHomeRegionSquare(double xyMax) {
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        ConvexPolygon2D homeRegionPolygon = new ConvexPolygon2D();
        homeRegionPolygon.addVertex(-xyMax, -xyMax);
        homeRegionPolygon.addVertex(xyMax, -xyMax);
        homeRegionPolygon.addVertex(xyMax, xyMax);
        homeRegionPolygon.addVertex(-xyMax, xyMax);
        homeRegionPolygon.update();
        PlanarRegion homeRegion = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, (Vertex2DSupplier)homeRegionPolygon);
        return homeRegion;
    }

    private void assertConnectionEquals(Point2D expectedSourcePoint, Point2D expectedTargetPoint, Connection connection) {
        ConnectionPoint3D sourcePoint = connection.getSourcePoint();
        ConnectionPoint3D targetPoint = connection.getTargetPoint();
        this.assertPointEquals(expectedSourcePoint, sourcePoint);
        this.assertPointEquals(expectedTargetPoint, targetPoint);
    }

    private void assertPointEquals(Point2D expectedPoint, ConnectionPoint3D point) {
        Assert.assertEquals((double)expectedPoint.getX(), (double)point.getX(), (double)1.0E-12);
        Assert.assertEquals((double)expectedPoint.getY(), (double)point.getY(), (double)1.0E-12);
    }

    private void printConnections(Collection<Connection> connections) {
        for (Connection connection : connections) {
            System.out.println(connection);
        }
    }

    public static void main(String[] args) throws IOException {
        MutationTestFacilitator.facilitateMutationTestForClass(VisibilityTools.class, VisibilityToolsTest.class);
    }
}

