/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.tools;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.NavigableRegions;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.NavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.tools.NavigableRegionTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.geometry.PlanarRegion;

public class NavigableRegionToolsTest {
    @Test
    public void testGetNavigableRegionContainingThisPoint() {
        ConvexPolygon2D planarRegionPolygon = new ConvexPolygon2D();
        planarRegionPolygon.addVertex(0.5, 0.5);
        planarRegionPolygon.addVertex(-0.5, 0.5);
        planarRegionPolygon.addVertex(-0.5, -0.5);
        planarRegionPolygon.addVertex(0.5, -0.5);
        planarRegionPolygon.update();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), (Vertex2DSupplier)planarRegionPolygon);
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        planarRegions.add(planarRegion);
        double navigableRegionExtrusionDistance = 0.05;
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        parameters.setNavigableExtrusionDistance(navigableRegionExtrusionDistance);
        NavigableRegions navigableRegions = new NavigableRegions((VisibilityGraphsParametersReadOnly)parameters, planarRegions);
        navigableRegions.createNavigableRegions();
        ConvexPolygon2D scaledRegion = new ConvexPolygon2D();
        ConvexPolygonScaler scaler = new ConvexPolygonScaler();
        scaler.scaleConvexPolygon((ConvexPolygon2DReadOnly)planarRegionPolygon, 0.5 * navigableRegionExtrusionDistance, (ConvexPolygon2DBasics)scaledRegion);
        Random random = new Random(1738L);
        for (int i = 0; i < 1000; ++i) {
            int startIndex = RandomNumbers.nextInt((Random)random, (int)0, (int)3);
            double alpha = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point2D pointToCheck = new Point2D();
            pointToCheck.interpolate((Tuple2DReadOnly)scaledRegion.getVertex(startIndex), (Tuple2DReadOnly)scaledRegion.getNextVertex(startIndex), alpha);
            NavigableRegion containingRegion = NavigableRegionTools.getNavigableRegionContainingThisPoint((Point3DReadOnly)new Point3D((Tuple2DReadOnly)pointToCheck), (NavigableRegions)navigableRegions, (double)parameters.getCanDuckUnderHeight());
            Assert.assertEquals((String)"Should be no region, since we're outside the navigable region", null, (Object)containingRegion);
        }
    }
}

