/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.tools;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.Cluster;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.ExtrusionHull;
import us.ihmc.robotics.Assert;

public class ClusterTest {
    private static final double EPSILON = 1.0E-10;

    @Test
    public void testIsInsideNonNavigableZone() {
        Point2D pointA = new Point2D(0.0, 0.0);
        Point2D pointB = new Point2D(1.0, 0.0);
        Point2D pointC = new Point2D(1.0, 1.0);
        Point2D pointD = new Point2D(0.0, 1.0);
        Cluster obstacleCluster = new Cluster(Cluster.ExtrusionSide.OUTSIDE, Cluster.ClusterType.POLYGON);
        ExtrusionHull clusterPoints = new ExtrusionHull();
        clusterPoints.addPoint((Point2DReadOnly)new Point2D(0.1, -0.1));
        clusterPoints.addPoint((Point2DReadOnly)new Point2D(1.1, -0.1));
        clusterPoints.addPoint((Point2DReadOnly)new Point2D(1.1, 1.1));
        clusterPoints.addPoint((Point2DReadOnly)new Point2D(0.1, 1.1));
        obstacleCluster.addNonNavigableExtrusionsInLocal(clusterPoints);
        Assert.assertFalse((boolean)obstacleCluster.isInsideNonNavigableZone((Point2DReadOnly)pointA));
        Assert.assertTrue((boolean)obstacleCluster.isInsideNonNavigableZone((Point2DReadOnly)pointB));
        Assert.assertTrue((boolean)obstacleCluster.isInsideNonNavigableZone((Point2DReadOnly)pointC));
        Assert.assertFalse((boolean)obstacleCluster.isInsideNonNavigableZone((Point2DReadOnly)pointD));
    }

    @Test
    public void testBoundingBox() {
        Cluster obstacleCluster = new Cluster(Cluster.ExtrusionSide.OUTSIDE, Cluster.ClusterType.POLYGON);
        ExtrusionHull clusterPoints = new ExtrusionHull();
        clusterPoints.addPoint((Point2DReadOnly)new Point2D(0.1, -0.1));
        clusterPoints.addPoint((Point2DReadOnly)new Point2D(1.1, -0.1));
        clusterPoints.addPoint((Point2DReadOnly)new Point2D(1.1, 1.6));
        clusterPoints.addPoint((Point2DReadOnly)new Point2D(0.3, 1.1));
        obstacleCluster.addNonNavigableExtrusionsInLocal(clusterPoints);
        BoundingBox2DReadOnly boundingBox = obstacleCluster.getNonNavigableExtrusionsBoundingBox();
        Assert.assertEquals((double)0.1, (double)boundingBox.getMinX(), (double)1.0E-10);
        Assert.assertEquals((double)-0.1, (double)boundingBox.getMinY(), (double)1.0E-10);
        Assert.assertEquals((double)1.1, (double)boundingBox.getMaxX(), (double)1.0E-10);
        Assert.assertEquals((double)1.6, (double)boundingBox.getMaxY(), (double)1.0E-10);
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(Cluster.class, ClusterTest.class);
    }
}

