/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.postProcessing;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.pathPlanning.visibilityGraphs.NavigableRegionsFactory;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.Cluster;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.NavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersBasics;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.postProcessing.ObstacleAndCliffAvoidanceProcessor;
import us.ihmc.pathPlanning.visibilityGraphs.postProcessing.PostProcessingTools;
import us.ihmc.pathPlanning.visibilityGraphs.tools.TestEnvironmentTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.simulationConstructionSetTools.util.environments.PlanarRegionsListDefinedEnvironment;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;

public class ObstacleAndCliffAvoidanceProcessorTest {
    private static final long timeout = 30000L;
    private static final double epsilon = 1.0E-10;
    private static final int iters = 500;
    private static final boolean visualize = false;

    @Test
    public void testRemoveDuplicated3DPointsFromList() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 500; ++iter) {
            int i;
            double distanceToFilter = RandomNumbers.nextDouble((Random)random, (double)1.0E-4, (double)1.0);
            int numberOfPointsRemove = RandomNumbers.nextInt((Random)random, (int)0, (int)10);
            int numberOfPointsToCreate = RandomNumbers.nextInt((Random)random, (int)numberOfPointsRemove, (int)50);
            ArrayList<Point3D> listOfPoints = new ArrayList<Point3D>();
            Point3D startPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            listOfPoints.add(startPoint);
            int numberOfRemovablePointsMade = 0;
            for (i = 1; i < numberOfPointsToCreate; ++i) {
                int numberOfPointsRemainingToMake = numberOfPointsToCreate - listOfPoints.size();
                int numberOfRemovablePointsRemainingToMake = numberOfPointsRemove - numberOfRemovablePointsMade;
                double probabilityPointIsRemovable = (double)numberOfRemovablePointsRemainingToMake / (double)numberOfPointsRemainingToMake;
                boolean nextPointIsRemovable = RandomNumbers.nextBoolean((Random)random, (double)probabilityPointIsRemovable);
                Vector3D displacementVector = EuclidCoreRandomTools.nextVector3D((Random)random, (double)0.1, (double)1.0);
                displacementVector.normalize();
                if (nextPointIsRemovable) {
                    displacementVector.scale(0.75 * distanceToFilter);
                    ++numberOfRemovablePointsMade;
                } else {
                    displacementVector.scale(1.5 * distanceToFilter);
                }
                Point3D newPoint = new Point3D((Tuple3DReadOnly)listOfPoints.get(i - 1));
                newPoint.add((Tuple3DReadOnly)displacementVector);
                listOfPoints.add(newPoint);
            }
            PostProcessingTools.removeDuplicated3DPointsFromList(listOfPoints, (double)distanceToFilter);
            for (i = 0; i < listOfPoints.size(); ++i) {
                for (int j = i + 1; j < listOfPoints.size(); ++j) {
                    Point3DReadOnly pointA = (Point3DReadOnly)listOfPoints.get(i);
                    Point3DReadOnly pointB = (Point3DReadOnly)listOfPoints.get(j);
                    double distance = pointA.distance(pointB);
                    Assert.assertTrue((String)("Point " + i + " = " + pointA + " is too close to point " + j + " = " + pointB + ", with a distance of " + distance + ", which should be at least " + distanceToFilter), (distance > distanceToFilter ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testRemoveDuplicated2DPointsFromList() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 500; ++iter) {
            int i;
            double distanceToFilter = RandomNumbers.nextDouble((Random)random, (double)1.0E-4, (double)1.0);
            int numberOfPointsRemove = RandomNumbers.nextInt((Random)random, (int)0, (int)10);
            int numberOfPointsToCreate = RandomNumbers.nextInt((Random)random, (int)numberOfPointsRemove, (int)50);
            ArrayList<Point2D> listOfPoints = new ArrayList<Point2D>();
            Point2D startPoint = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
            listOfPoints.add(startPoint);
            int numberOfRemovablePointsMade = 0;
            for (i = 1; i < numberOfPointsToCreate; ++i) {
                int numberOfPointsRemainingToMake = numberOfPointsToCreate - listOfPoints.size();
                int numberOfRemovablePointsRemainingToMake = numberOfPointsRemove - numberOfRemovablePointsMade;
                double probabilityPointIsRemovable = (double)numberOfRemovablePointsRemainingToMake / (double)numberOfPointsRemainingToMake;
                boolean nextPointIsRemovable = RandomNumbers.nextBoolean((Random)random, (double)probabilityPointIsRemovable);
                Vector2D displacementVector = EuclidCoreRandomTools.nextVector2D((Random)random, (double)0.1, (double)1.0);
                displacementVector.normalize();
                if (nextPointIsRemovable) {
                    displacementVector.scale(0.75 * distanceToFilter);
                    ++numberOfRemovablePointsMade;
                } else {
                    displacementVector.scale(1.5 * distanceToFilter);
                }
                Point2D newPoint = new Point2D((Tuple2DReadOnly)listOfPoints.get(i - 1));
                newPoint.add((Tuple2DReadOnly)displacementVector);
                listOfPoints.add(newPoint);
            }
            PostProcessingTools.removeDuplicated2DPointsFromList(listOfPoints, (double)distanceToFilter);
            for (i = 0; i < listOfPoints.size(); ++i) {
                for (int j = i + 1; j < listOfPoints.size(); ++j) {
                    Point2DReadOnly pointA = (Point2DReadOnly)listOfPoints.get(i);
                    Point2DReadOnly pointB = (Point2DReadOnly)listOfPoints.get(j);
                    double distance = pointA.distance(pointB);
                    Assert.assertTrue((String)("Point " + i + " = " + pointA + " is too close to point " + j + " = " + pointB + ", with a distance of " + distance + ", which should be at least " + distanceToFilter), (distance > distanceToFilter ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testRemoveDuplicateStartOrEndPointsFromList() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 500; ++iter) {
            int i;
            double distanceToFilter = RandomNumbers.nextDouble((Random)random, (double)1.0E-4, (double)1.0);
            int numberOfPointsRemove = RandomNumbers.nextInt((Random)random, (int)0, (int)10);
            int numberOfPointsToCreate = RandomNumbers.nextInt((Random)random, (int)numberOfPointsRemove, (int)50);
            ArrayList<Point3D> listOfPoints = new ArrayList<Point3D>();
            Point3D startPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D endPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            int numberOfRemovablePointsMade = 0;
            for (i = 0; i < numberOfPointsToCreate; ++i) {
                int numberOfPointsRemainingToMake = numberOfPointsToCreate - listOfPoints.size();
                int numberOfRemovablePointsRemainingToMake = numberOfPointsRemove - numberOfRemovablePointsMade;
                double probabilityPointIsRemovable = (double)numberOfRemovablePointsRemainingToMake / (double)numberOfPointsRemainingToMake;
                boolean nextPointIsRemovable = RandomNumbers.nextBoolean((Random)random, (double)probabilityPointIsRemovable);
                Vector3D displacementVector = EuclidCoreRandomTools.nextVector3D((Random)random, (double)-5.0, (double)5.0);
                displacementVector.normalize();
                if (nextPointIsRemovable) {
                    displacementVector.scale(0.75 * distanceToFilter);
                    ++numberOfRemovablePointsMade;
                } else {
                    displacementVector.scale(1.5 * distanceToFilter);
                }
                boolean displacementFromStartPoint = RandomNumbers.nextBoolean((Random)random, (double)0.5);
                Point3D newPoint = new Point3D();
                if (displacementFromStartPoint) {
                    newPoint.set(startPoint);
                } else {
                    newPoint.set(endPoint);
                }
                newPoint.add((Tuple3DReadOnly)displacementVector);
                listOfPoints.add(newPoint);
            }
            PostProcessingTools.removeDuplicateStartOrEndPointsFromList(listOfPoints, (Point3DReadOnly)startPoint, (Point3DReadOnly)endPoint, (double)distanceToFilter);
            for (i = 0; i < listOfPoints.size(); ++i) {
                Point3DReadOnly point = (Point3DReadOnly)listOfPoints.get(i);
                double distanceFromStart = point.distance((Point3DReadOnly)startPoint);
                double distanceFromEnd = point.distance((Point3DReadOnly)endPoint);
                Assert.assertTrue((String)("Point " + i + " = " + point + " is too close to start " + startPoint + ", with a distance of " + distanceFromStart + ", which should be at least " + distanceToFilter), (distanceFromStart > distanceToFilter ? 1 : 0) != 0);
                Assert.assertTrue((String)("Point " + i + " = " + point + " is too close to end " + endPoint + ", with a distance of " + distanceFromEnd + ", which should be at least " + distanceToFilter), (distanceFromEnd > distanceToFilter ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testIsNearCliffAtCorner() {
        List<PlanarRegion> planarRegions = TestEnvironmentTools.createCornerEnvironment();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(planarRegions);
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        List navigableRegions = NavigableRegionsFactory.createNavigableRegions(planarRegions, (VisibilityGraphsParametersReadOnly)parameters);
        double extrusionDistance = parameters.getNavigableExtrusionDistance();
        double maxInterRegionConnectionLength = parameters.getMaxInterRegionConnectionLength();
        double desiredDistanceFromCliff = parameters.getPreferredObstacleExtrusionDistance();
        double cliffHeightToAvoid = 0.1;
        Point2D pointOnCorner = new Point2D(5.0, 2.5);
        pointOnCorner.subX(extrusionDistance);
        pointOnCorner.subY(extrusionDistance);
        NavigableRegion homeRegion = ObstacleAndCliffAvoidanceProcessorTest.getRegionContainingPoint((Point2DReadOnly)pointOnCorner, navigableRegions);
        ArrayList cliffEdgesToPack = new ArrayList();
        boolean isNearCliff = ObstacleAndCliffAvoidanceProcessor.isNearCliff((Point2DReadOnly)pointOnCorner, (double)maxInterRegionConnectionLength, (double)cliffHeightToAvoid, (double)desiredDistanceFromCliff, (NavigableRegion)homeRegion, (List)navigableRegions, cliffEdgesToPack);
        Assert.assertTrue((boolean)isNearCliff);
        Point2D pointOnRightEdge = new Point2D(2.5, 2.5);
        pointOnCorner.subY(extrusionDistance);
        cliffEdgesToPack.clear();
        isNearCliff = ObstacleAndCliffAvoidanceProcessor.isNearCliff((Point2DReadOnly)pointOnRightEdge, (double)maxInterRegionConnectionLength, (double)cliffHeightToAvoid, (double)desiredDistanceFromCliff, (NavigableRegion)homeRegion, (List)navigableRegions, cliffEdgesToPack);
        Assert.assertTrue((boolean)isNearCliff);
        Point2D pointOnLeftEdge = new Point2D(2.5, -2.5);
        pointOnCorner.addY(extrusionDistance);
        cliffEdgesToPack.clear();
        isNearCliff = ObstacleAndCliffAvoidanceProcessor.isNearCliff((Point2DReadOnly)pointOnLeftEdge, (double)maxInterRegionConnectionLength, (double)cliffHeightToAvoid, (double)desiredDistanceFromCliff, (NavigableRegion)homeRegion, (List)navigableRegions, cliffEdgesToPack);
        Assert.assertTrue((boolean)isNearCliff);
        Point2D pointOnBackEdge = new Point2D(-5.0, 0.0);
        pointOnCorner.addX(extrusionDistance);
        cliffEdgesToPack.clear();
        isNearCliff = ObstacleAndCliffAvoidanceProcessor.isNearCliff((Point2DReadOnly)pointOnBackEdge, (double)maxInterRegionConnectionLength, (double)cliffHeightToAvoid, (double)desiredDistanceFromCliff, (NavigableRegion)homeRegion, (List)navigableRegions, cliffEdgesToPack);
        Assert.assertTrue((boolean)isNearCliff);
        Point2D pointOnFrontEdge = new Point2D(5.0, 0.0);
        pointOnCorner.subX(extrusionDistance);
        cliffEdgesToPack.clear();
        isNearCliff = ObstacleAndCliffAvoidanceProcessor.isNearCliff((Point2DReadOnly)pointOnFrontEdge, (double)maxInterRegionConnectionLength, (double)cliffHeightToAvoid, (double)desiredDistanceFromCliff, (NavigableRegion)homeRegion, (List)navigableRegions, cliffEdgesToPack);
        Assert.assertFalse((boolean)isNearCliff);
        pointOnFrontEdge.setY(-2.5);
        pointOnFrontEdge.addY(parameters.getPreferredObstacleExtrusionDistance());
        pointOnFrontEdge.subY(0.05);
        cliffEdgesToPack.clear();
        isNearCliff = ObstacleAndCliffAvoidanceProcessor.isNearCliff((Point2DReadOnly)pointOnFrontEdge, (double)maxInterRegionConnectionLength, (double)cliffHeightToAvoid, (double)desiredDistanceFromCliff, (NavigableRegion)homeRegion, (List)navigableRegions, cliffEdgesToPack);
        Assert.assertTrue((boolean)isNearCliff);
    }

    @Test
    public void testIsNearCliffUsingParallelRegions() {
        List<PlanarRegion> planarRegions = TestEnvironmentTools.createSameEdgeRegions();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(planarRegions);
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        List navigableRegions = NavigableRegionsFactory.createNavigableRegions(planarRegions, (VisibilityGraphsParametersReadOnly)parameters);
        double extrusionDistance = parameters.getNavigableExtrusionDistance();
        double maxInterRegionConnectionLength = parameters.getMaxInterRegionConnectionLength();
        double desiredDistanceFromCliff = parameters.getPreferredObstacleExtrusionDistance();
        double cliffHeightToAvoid = 0.1;
        Point2D pointOnOutsideSharedEdge = new Point2D(1.0, 1.0);
        pointOnOutsideSharedEdge.subX(extrusionDistance);
        pointOnOutsideSharedEdge.subY(extrusionDistance);
        NavigableRegion homeRegion = ObstacleAndCliffAvoidanceProcessorTest.getRegionContainingPoint((Point2DReadOnly)pointOnOutsideSharedEdge, navigableRegions);
        ArrayList cliffEdgesToPack = new ArrayList();
        cliffEdgesToPack.clear();
        boolean isNearCliff = ObstacleAndCliffAvoidanceProcessor.isNearCliff((Point2DReadOnly)pointOnOutsideSharedEdge, (double)maxInterRegionConnectionLength, (double)cliffHeightToAvoid, (double)desiredDistanceFromCliff, (NavigableRegion)homeRegion, (List)navigableRegions, cliffEdgesToPack);
        boolean expected = true;
        Assert.assertEquals((Object)expected, (Object)isNearCliff);
        pointOnOutsideSharedEdge.setY(1.0);
        pointOnOutsideSharedEdge.subY(parameters.getPreferredObstacleExtrusionDistance());
        pointOnOutsideSharedEdge.addY(0.1);
        cliffEdgesToPack.clear();
        isNearCliff = ObstacleAndCliffAvoidanceProcessor.isNearCliff((Point2DReadOnly)pointOnOutsideSharedEdge, (double)maxInterRegionConnectionLength, (double)cliffHeightToAvoid, (double)desiredDistanceFromCliff, (NavigableRegion)homeRegion, (List)navigableRegions, cliffEdgesToPack);
        expected = true;
        Assert.assertEquals((Object)expected, (Object)isNearCliff);
        pointOnOutsideSharedEdge.setX(0.0);
        cliffEdgesToPack.clear();
        isNearCliff = ObstacleAndCliffAvoidanceProcessor.isNearCliff((Point2DReadOnly)pointOnOutsideSharedEdge, (double)maxInterRegionConnectionLength, (double)cliffHeightToAvoid, (double)desiredDistanceFromCliff, (NavigableRegion)homeRegion, (List)navigableRegions, cliffEdgesToPack);
        expected = true;
        Assert.assertEquals((Object)expected, (Object)isNearCliff);
    }

    @Test
    public void testTrickyCase() {
        List<PlanarRegion> planarRegions = TestEnvironmentTools.createSameEdgeRegions();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(planarRegions);
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        List navigableRegions = NavigableRegionsFactory.createNavigableRegions(planarRegions, (VisibilityGraphsParametersReadOnly)parameters);
        double extrusionDistance = parameters.getNavigableExtrusionDistance();
        double maxInterRegionConnectionLength = parameters.getMaxInterRegionConnectionLength();
        double desiredDistanceFromCliff = parameters.getPreferredObstacleExtrusionDistance();
        double cliffHeightToAvoid = 0.1;
        Point2D pointOnOutsideSharedEdge = new Point2D(1.0, 1.0);
        pointOnOutsideSharedEdge.subX(extrusionDistance);
        pointOnOutsideSharedEdge.subY(extrusionDistance);
        NavigableRegion homeRegion = ObstacleAndCliffAvoidanceProcessorTest.getRegionContainingPoint((Point2DReadOnly)pointOnOutsideSharedEdge, navigableRegions);
        ArrayList cliffEdgesToPack = new ArrayList();
        pointOnOutsideSharedEdge.setY(1.0);
        pointOnOutsideSharedEdge.subY(parameters.getPreferredObstacleExtrusionDistance());
        pointOnOutsideSharedEdge.addY(0.1);
        cliffEdgesToPack.clear();
        boolean isNearCliff = ObstacleAndCliffAvoidanceProcessor.isNearCliff((Point2DReadOnly)pointOnOutsideSharedEdge, (double)maxInterRegionConnectionLength, (double)cliffHeightToAvoid, (double)desiredDistanceFromCliff, (NavigableRegion)homeRegion, (List)navigableRegions, cliffEdgesToPack);
        boolean expected = true;
        Assert.assertEquals((Object)expected, (Object)isNearCliff);
    }

    private static NavigableRegion getRegionContainingPoint(Point2DReadOnly point, List<NavigableRegion> navigableRegions) {
        NavigableRegion homeRegion;
        block1: {
            homeRegion = null;
            int i = 0;
            if (i >= navigableRegions.size()) break block1;
            Cluster homeCluster = navigableRegions.get(i).getHomeRegionCluster();
            if (EuclidGeometryPolygonTools.isPoint2DInsideConvexPolygon2D((Point2DReadOnly)point, (List)homeCluster.getRawPointsInWorld2D(), (int)homeCluster.getNumberOfRawPoints(), (boolean)true, (double)0.0)) {
                // empty if block
            }
            homeRegion = navigableRegions.get(i);
        }
        return homeRegion;
    }

    private void visualize(PlanarRegionsList planarRegionsList, Point2DReadOnly point, List<LineSegment2DReadOnly> cliffEdges, VisibilityGraphsParametersBasics parameters, List<NavigableRegion> navigableRegions) {
        double maxInterRegionConnectionLength = parameters.getMaxInterRegionConnectionLength();
        double desiredDistanceFromCliff = parameters.getPreferredObstacleExtrusionDistance();
        double cliffHeightToAvoid = 0.1;
        NavigableRegion homeRegion = ObstacleAndCliffAvoidanceProcessorTest.getRegionContainingPoint(point, navigableRegions);
        List homeEdges = ObstacleAndCliffAvoidanceProcessor.getNearbyEdges((Point2DReadOnly)point, (Cluster)homeRegion.getHomeRegionCluster(), (double)desiredDistanceFromCliff);
        List nearbyRegions = ObstacleAndCliffAvoidanceProcessor.filterNavigableRegionsWithBoundingCircle((Point2DReadOnly)point, (double)(maxInterRegionConnectionLength + desiredDistanceFromCliff), navigableRegions);
        List closeEnoughRegions = ObstacleAndCliffAvoidanceProcessor.filterNavigableRegionsConnectionWithDistanceAndHeightChange((NavigableRegion)homeRegion, (List)nearbyRegions, (double)maxInterRegionConnectionLength, (double)cliffHeightToAvoid);
        ArrayList nearbyEdges = new ArrayList();
        for (NavigableRegion closeEnoughRegion : closeEnoughRegions) {
            nearbyEdges.addAll(ObstacleAndCliffAvoidanceProcessor.getNearbyEdges((Point2DReadOnly)point, (Cluster)closeEnoughRegion.getHomeRegionCluster(), (double)desiredDistanceFromCliff));
        }
        SimulationConstructionSet scs = new SimulationConstructionSet();
        scs.setGroundVisible(false);
        PlanarRegionsListDefinedEnvironment environment = new PlanarRegionsListDefinedEnvironment(planarRegionsList, 0.0, false);
        scs.addStaticLinkGraphics(environment.getTerrainObject3D().getLinkGraphics());
        Graphics3DObject extraGraphics = new Graphics3DObject();
        extraGraphics.translate((Tuple3DReadOnly)new Point3D((Tuple2DReadOnly)point));
        extraGraphics.addSphere(0.05, YoAppearance.Red());
        for (LineSegment2DReadOnly edge : homeEdges) {
            extraGraphics.identity();
            extraGraphics.translate((Tuple3DReadOnly)new Point3D((Tuple2DReadOnly)edge.getFirstEndpoint()));
            extraGraphics.addSphere(0.03, YoAppearance.Black());
            extraGraphics.identity();
            extraGraphics.translate((Tuple3DReadOnly)new Point3D((Tuple2DReadOnly)edge.getSecondEndpoint()));
            extraGraphics.addSphere(0.03, YoAppearance.Black());
        }
        for (LineSegment2DReadOnly edge : nearbyEdges) {
            extraGraphics.identity();
            extraGraphics.translate((Tuple3DReadOnly)new Point3D((Tuple2DReadOnly)edge.getFirstEndpoint()));
            extraGraphics.addSphere(0.03, YoAppearance.Green());
            extraGraphics.identity();
            extraGraphics.translate((Tuple3DReadOnly)new Point3D((Tuple2DReadOnly)edge.getSecondEndpoint()));
            extraGraphics.addSphere(0.03, YoAppearance.Green());
        }
        for (LineSegment2DReadOnly edge : cliffEdges) {
            extraGraphics.identity();
            extraGraphics.translate((Tuple3DReadOnly)new Point3D((Tuple2DReadOnly)edge.getFirstEndpoint()));
            extraGraphics.addSphere(0.03, YoAppearance.Blue());
            extraGraphics.identity();
            extraGraphics.translate((Tuple3DReadOnly)new Point3D((Tuple2DReadOnly)edge.getSecondEndpoint()));
            extraGraphics.addSphere(0.03, YoAppearance.Blue());
        }
        scs.addStaticLinkGraphics(extraGraphics);
        scs.startOnAThread();
        ThreadTools.sleepForever();
    }
}

