/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.parameters;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.ConnectionPoint3D;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.InterRegionConnectionFilter;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.robotics.Assert;

public class VisibilityGraphsParametersReadOnlyTest {
    private static final double iters = 1000.0;

    @Test
    public void testFilterConnections() {
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        double preferredConnectionDistance = parameters.getPreferredNavigableExtrusionDistance();
        double interRegionDistance = parameters.getMaxInterRegionConnectionLength();
        double connectionDistance = parameters.getNavigableExtrusionDistance();
        InterRegionConnectionFilter nonPreferredToNonPreferred = parameters.getInterRegionConnectionFilter();
        InterRegionConnectionFilter preferredToNonPreferred = parameters.getPreferredToNonPreferredInterRegionConnectionFilter();
        InterRegionConnectionFilter preferredToPreferred = parameters.getPreferredToPreferredInterRegionConnectionFilter();
        double maxNonPreferredToNonPreferredDistance = 2.0 * connectionDistance + interRegionDistance;
        double maxPreferredToNonPreferredDistance = preferredConnectionDistance + connectionDistance + interRegionDistance;
        double maxPreferredToPreferredDistance = 2.0 * preferredConnectionDistance + interRegionDistance;
        double heightLimit = parameters.getTooHighToStepDistance();
        Random random = new Random(1738L);
        int iter = 0;
        while ((double)iter < 1000.0) {
            ConnectionPoint3D sourcePoint = new ConnectionPoint3D((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0), -1);
            Vector2D randomVector = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-1.0, (double)1.0);
            randomVector.normalize();
            double fractionToLimit = 0.9;
            Vector2D nonPreferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            Vector2D preferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            Vector2D preferredToPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            double heightOffset = 0.0;
            nonPreferredToNonPreferredOffset.scale(fractionToLimit * maxNonPreferredToNonPreferredDistance);
            preferredToNonPreferredOffset.scale(fractionToLimit * maxPreferredToNonPreferredDistance);
            preferredToPreferredOffset.scale(fractionToLimit * maxPreferredToPreferredDistance);
            VisibilityGraphsParametersReadOnlyTest.runTest(nonPreferredToNonPreferred, preferredToNonPreferred, preferredToPreferred, sourcePoint, heightOffset, (Vector2DReadOnly)nonPreferredToNonPreferredOffset, (Vector2DReadOnly)preferredToNonPreferredOffset, (Vector2DReadOnly)preferredToPreferredOffset, true);
            fractionToLimit = 0.99;
            nonPreferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            heightOffset = 0.0;
            nonPreferredToNonPreferredOffset.scale(fractionToLimit * maxNonPreferredToNonPreferredDistance);
            preferredToNonPreferredOffset.scale(fractionToLimit * maxPreferredToNonPreferredDistance);
            preferredToPreferredOffset.scale(fractionToLimit * maxPreferredToPreferredDistance);
            VisibilityGraphsParametersReadOnlyTest.runTest(nonPreferredToNonPreferred, preferredToNonPreferred, preferredToPreferred, sourcePoint, heightOffset, (Vector2DReadOnly)nonPreferredToNonPreferredOffset, (Vector2DReadOnly)preferredToNonPreferredOffset, (Vector2DReadOnly)preferredToPreferredOffset, true);
            fractionToLimit = 0.9999;
            nonPreferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            heightOffset = 0.0;
            nonPreferredToNonPreferredOffset.scale(fractionToLimit * maxNonPreferredToNonPreferredDistance);
            preferredToNonPreferredOffset.scale(fractionToLimit * maxPreferredToNonPreferredDistance);
            preferredToPreferredOffset.scale(fractionToLimit * maxPreferredToPreferredDistance);
            VisibilityGraphsParametersReadOnlyTest.runTest(nonPreferredToNonPreferred, preferredToNonPreferred, preferredToPreferred, sourcePoint, heightOffset, (Vector2DReadOnly)nonPreferredToNonPreferredOffset, (Vector2DReadOnly)preferredToNonPreferredOffset, (Vector2DReadOnly)preferredToPreferredOffset, true);
            fractionToLimit = 1.01;
            nonPreferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            heightOffset = 0.0;
            nonPreferredToNonPreferredOffset.scale(fractionToLimit * maxNonPreferredToNonPreferredDistance);
            preferredToNonPreferredOffset.scale(fractionToLimit * maxPreferredToNonPreferredDistance);
            preferredToPreferredOffset.scale(fractionToLimit * maxPreferredToPreferredDistance);
            VisibilityGraphsParametersReadOnlyTest.runTest(nonPreferredToNonPreferred, preferredToNonPreferred, preferredToPreferred, sourcePoint, heightOffset, (Vector2DReadOnly)nonPreferredToNonPreferredOffset, (Vector2DReadOnly)preferredToNonPreferredOffset, (Vector2DReadOnly)preferredToPreferredOffset, false);
            fractionToLimit = 1.1;
            nonPreferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            heightOffset = 0.0;
            nonPreferredToNonPreferredOffset.scale(fractionToLimit * maxNonPreferredToNonPreferredDistance);
            preferredToNonPreferredOffset.scale(fractionToLimit * maxPreferredToNonPreferredDistance);
            preferredToPreferredOffset.scale(fractionToLimit * maxPreferredToPreferredDistance);
            VisibilityGraphsParametersReadOnlyTest.runTest(nonPreferredToNonPreferred, preferredToNonPreferred, preferredToPreferred, sourcePoint, heightOffset, (Vector2DReadOnly)nonPreferredToNonPreferredOffset, (Vector2DReadOnly)preferredToNonPreferredOffset, (Vector2DReadOnly)preferredToPreferredOffset, false);
            fractionToLimit = 0.99;
            nonPreferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            heightOffset = fractionToLimit * heightLimit;
            nonPreferredToNonPreferredOffset.scale(fractionToLimit * maxNonPreferredToNonPreferredDistance);
            preferredToNonPreferredOffset.scale(fractionToLimit * maxPreferredToNonPreferredDistance);
            preferredToPreferredOffset.scale(fractionToLimit * maxPreferredToPreferredDistance);
            VisibilityGraphsParametersReadOnlyTest.runTest(nonPreferredToNonPreferred, preferredToNonPreferred, preferredToPreferred, sourcePoint, heightOffset, (Vector2DReadOnly)nonPreferredToNonPreferredOffset, (Vector2DReadOnly)preferredToNonPreferredOffset, (Vector2DReadOnly)preferredToPreferredOffset, true);
            fractionToLimit = 0.99;
            nonPreferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            heightOffset = -fractionToLimit * heightLimit;
            nonPreferredToNonPreferredOffset.scale(fractionToLimit * maxNonPreferredToNonPreferredDistance);
            preferredToNonPreferredOffset.scale(fractionToLimit * maxPreferredToNonPreferredDistance);
            preferredToPreferredOffset.scale(fractionToLimit * maxPreferredToPreferredDistance);
            VisibilityGraphsParametersReadOnlyTest.runTest(nonPreferredToNonPreferred, preferredToNonPreferred, preferredToPreferred, sourcePoint, heightOffset, (Vector2DReadOnly)nonPreferredToNonPreferredOffset, (Vector2DReadOnly)preferredToNonPreferredOffset, (Vector2DReadOnly)preferredToPreferredOffset, true);
            fractionToLimit = 1.01;
            nonPreferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            heightOffset = fractionToLimit * heightLimit;
            nonPreferredToNonPreferredOffset.scale(fractionToLimit * maxNonPreferredToNonPreferredDistance);
            preferredToNonPreferredOffset.scale(fractionToLimit * maxPreferredToNonPreferredDistance);
            preferredToPreferredOffset.scale(fractionToLimit * maxPreferredToPreferredDistance);
            VisibilityGraphsParametersReadOnlyTest.runTest(nonPreferredToNonPreferred, preferredToNonPreferred, preferredToPreferred, sourcePoint, heightOffset, (Vector2DReadOnly)nonPreferredToNonPreferredOffset, (Vector2DReadOnly)preferredToNonPreferredOffset, (Vector2DReadOnly)preferredToPreferredOffset, false);
            fractionToLimit = 1.01;
            nonPreferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToNonPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            preferredToPreferredOffset = new Vector2D((Tuple2DReadOnly)randomVector);
            heightOffset = -fractionToLimit * heightLimit;
            nonPreferredToNonPreferredOffset.scale(fractionToLimit * maxNonPreferredToNonPreferredDistance);
            preferredToNonPreferredOffset.scale(fractionToLimit * maxPreferredToNonPreferredDistance);
            preferredToPreferredOffset.scale(fractionToLimit * maxPreferredToPreferredDistance);
            VisibilityGraphsParametersReadOnlyTest.runTest(nonPreferredToNonPreferred, preferredToNonPreferred, preferredToPreferred, sourcePoint, heightOffset, (Vector2DReadOnly)nonPreferredToNonPreferredOffset, (Vector2DReadOnly)preferredToNonPreferredOffset, (Vector2DReadOnly)preferredToPreferredOffset, false);
            ++iter;
        }
    }

    private static void runTest(InterRegionConnectionFilter nonPreferredToNonPreferredFilter, InterRegionConnectionFilter preferredToNonPreferredFilter, InterRegionConnectionFilter preferredToPreferredFilter, ConnectionPoint3D source, double heightOffset, Vector2DReadOnly nonPreferredToNonPreferredOffset, Vector2DReadOnly preferredToNonPreferredOffset, Vector2DReadOnly preferredToPreferredOffset, boolean shouldBeValid) {
        Point3D nonPreferredToNonPreferredTargetPoint = new Point3D(source.getX(), source.getY(), source.getZ());
        Point3D preferredToNonPreferredTargetPoint = new Point3D(source.getX(), source.getY(), source.getZ());
        Point3D preferredToPreferredTargetPoint = new Point3D(source.getX(), source.getY(), source.getZ());
        nonPreferredToNonPreferredTargetPoint.addX(nonPreferredToNonPreferredOffset.getX());
        nonPreferredToNonPreferredTargetPoint.addY(nonPreferredToNonPreferredOffset.getY());
        nonPreferredToNonPreferredTargetPoint.addZ(heightOffset);
        preferredToNonPreferredTargetPoint.addX(preferredToNonPreferredOffset.getX());
        preferredToNonPreferredTargetPoint.addY(preferredToNonPreferredOffset.getY());
        preferredToNonPreferredTargetPoint.addZ(heightOffset);
        preferredToPreferredTargetPoint.addX(preferredToPreferredOffset.getX());
        preferredToPreferredTargetPoint.addY(preferredToPreferredOffset.getY());
        preferredToPreferredTargetPoint.addZ(heightOffset);
        Assert.assertEquals((Object)shouldBeValid, (Object)nonPreferredToNonPreferredFilter.isConnectionValid(source, new ConnectionPoint3D((Tuple3DReadOnly)nonPreferredToNonPreferredTargetPoint, -1)));
        Assert.assertEquals((Object)shouldBeValid, (Object)preferredToNonPreferredFilter.isConnectionValid(source, new ConnectionPoint3D((Tuple3DReadOnly)preferredToNonPreferredTargetPoint, -1)));
        Assert.assertEquals((Object)shouldBeValid, (Object)preferredToPreferredFilter.isConnectionValid(source, new ConnectionPoint3D((Tuple3DReadOnly)preferredToPreferredTargetPoint, -1)));
    }

    @Test
    public void testFilterRandomConnections() {
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        double preferredConnectionDistance = parameters.getPreferredNavigableExtrusionDistance();
        double interRegionDistance = parameters.getMaxInterRegionConnectionLength();
        double connectionDistance = parameters.getNavigableExtrusionDistance();
        InterRegionConnectionFilter nonPreferredToNonPreferredFilter = parameters.getInterRegionConnectionFilter();
        InterRegionConnectionFilter preferredToNonPreferred = parameters.getPreferredToNonPreferredInterRegionConnectionFilter();
        InterRegionConnectionFilter preferredToPreferred = parameters.getPreferredToPreferredInterRegionConnectionFilter();
        Random random = new Random(1738L);
        int iter = 0;
        while ((double)iter < 1000.0) {
            Point3D sourcePoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Vector2D randomVector = EuclidCoreRandomTools.nextVector2D((Random)random, (double)-1.0, (double)1.0);
            randomVector.normalize();
            double randomScalar = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1.0);
            double heightOffset = RandomNumbers.nextDouble((Random)random, (double)parameters.getTooHighToStepDistance());
            Vector2D offsetVector = new Vector2D((Tuple2DReadOnly)randomVector);
            offsetVector.scale(randomScalar * (2.0 * connectionDistance + interRegionDistance));
            Point3D targetPoint = new Point3D((Tuple3DReadOnly)sourcePoint);
            targetPoint.addX(offsetVector.getX());
            targetPoint.addY(offsetVector.getY());
            targetPoint.addZ(heightOffset);
            ConnectionPoint3D source = new ConnectionPoint3D((Tuple3DReadOnly)sourcePoint, -1);
            ConnectionPoint3D target = new ConnectionPoint3D((Tuple3DReadOnly)targetPoint, -1);
            String message = "Source " + sourcePoint + " is too far from target " + targetPoint + ".\n It is at a distance of " + sourcePoint.distanceXY((Point3DReadOnly)targetPoint) + ", which must be less than " + (interRegionDistance + 2.0 * connectionDistance);
            Assert.assertTrue((String)message, (boolean)nonPreferredToNonPreferredFilter.isConnectionValid(source, target));
            offsetVector.set(randomVector);
            offsetVector.scale(randomScalar * (connectionDistance + preferredConnectionDistance + interRegionDistance));
            targetPoint = new Point3D((Tuple3DReadOnly)sourcePoint);
            targetPoint.addX(offsetVector.getX());
            targetPoint.addY(offsetVector.getY());
            targetPoint.addZ(heightOffset);
            target = new ConnectionPoint3D((Tuple3DReadOnly)targetPoint, -1);
            message = "Source " + sourcePoint + " is too far from target " + targetPoint + ".\n It is at a distance of " + sourcePoint.distanceXY((Point3DReadOnly)targetPoint) + ", which must be less than " + (interRegionDistance + connectionDistance + preferredConnectionDistance);
            Assert.assertTrue((String)message, (boolean)preferredToNonPreferred.isConnectionValid(source, target));
            offsetVector.set(randomVector);
            offsetVector.scale(randomScalar * (connectionDistance + 2.0 * preferredConnectionDistance));
            targetPoint = new Point3D((Tuple3DReadOnly)sourcePoint);
            targetPoint.addX(offsetVector.getX());
            targetPoint.addY(offsetVector.getY());
            targetPoint.addZ(heightOffset);
            target = new ConnectionPoint3D((Tuple3DReadOnly)targetPoint, -1);
            message = "Source " + sourcePoint + " is too far from target " + targetPoint + ".\n It is at a distance of " + sourcePoint.distanceXY((Point3DReadOnly)targetPoint) + ", which must be less than " + (interRegionDistance + 2.0 * preferredConnectionDistance);
            Assert.assertTrue((String)message, (boolean)preferredToPreferred.isConnectionValid(source, target));
            ++iter;
        }
    }
}

