/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.dataStructure;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.pathPlanning.visibilityGraphs.VisibilityGraphRandomTools;
import us.ihmc.pathPlanning.visibilityGraphs.VisibilityGraphTestTools;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.Cluster;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.NavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMapWithNavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.VisibilityMapHolder;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTestTools;

public class NavigableRegionTest {
    private static final int iterations = 20;
    private static final double epsilon = 1.0E-12;

    @Test
    public void testNavigableRegions() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 20; ++iter) {
            int i;
            PlanarRegion planarRegion = PlanarRegion.generatePlanarRegionFromRandomPolygonsWithRandomTransform((Random)random, (int)random.nextInt(10), (double)RandomNumbers.nextDouble((Random)random, (double)0.0, (double)30.0), (int)(3 + random.nextInt(10)));
            VisibilityMapHolder visibilityMapHolder = VisibilityGraphRandomTools.getRandomSingleSourceVisibilityMap(random);
            Cluster homeRegionCluster = VisibilityGraphRandomTools.getRandomCluster(random);
            int numberOfObstacleClusters = random.nextInt(100);
            ArrayList<Cluster> obstacleClusters = new ArrayList<Cluster>();
            for (int i2 = 0; i2 < numberOfObstacleClusters; ++i2) {
                obstacleClusters.add(VisibilityGraphRandomTools.getRandomCluster(random));
            }
            NavigableRegion navigableRegion = new NavigableRegion(planarRegion, homeRegionCluster, obstacleClusters);
            VisibilityMapWithNavigableRegion visibilityMapWithNavigableRegion = new VisibilityMapWithNavigableRegion(navigableRegion);
            visibilityMapWithNavigableRegion.setVisibilityMapInLocal(visibilityMapHolder.getVisibilityMapInLocal());
            PlanarRegionTestTools.assertPlanarRegionsEqual((PlanarRegion)planarRegion, (PlanarRegion)visibilityMapWithNavigableRegion.getHomePlanarRegion(), (double)1.0E-12);
            VisibilityGraphTestTools.assertVisibilityMapsEqual(visibilityMapWithNavigableRegion.getVisibilityMapInLocal(), visibilityMapWithNavigableRegion.getVisibilityMapInLocal(), 1.0E-12);
            VisibilityGraphTestTools.assertVisibilityMapsEqual(visibilityMapWithNavigableRegion.getVisibilityMapInWorld(), visibilityMapWithNavigableRegion.getVisibilityMapInWorld(), 1.0E-12);
            VisibilityGraphTestTools.assertClustersEqual(homeRegionCluster, visibilityMapWithNavigableRegion.getHomeRegionCluster(), 1.0E-12);
            for (i = 0; i < numberOfObstacleClusters; ++i) {
                VisibilityGraphTestTools.assertClustersEqual((Cluster)obstacleClusters.get(i), (Cluster)visibilityMapWithNavigableRegion.getObstacleClusters().get(i), 1.0E-12);
            }
            navigableRegion = new NavigableRegion(planarRegion, homeRegionCluster, obstacleClusters);
            visibilityMapWithNavigableRegion = new VisibilityMapWithNavigableRegion(navigableRegion);
            visibilityMapWithNavigableRegion.setVisibilityMapInWorld(visibilityMapHolder.getVisibilityMapInWorld());
            PlanarRegionTestTools.assertPlanarRegionsEqual((PlanarRegion)planarRegion, (PlanarRegion)visibilityMapWithNavigableRegion.getHomePlanarRegion(), (double)1.0E-12);
            VisibilityGraphTestTools.assertVisibilityMapsEqual(visibilityMapWithNavigableRegion.getVisibilityMapInLocal(), visibilityMapWithNavigableRegion.getVisibilityMapInLocal(), 1.0E-12);
            VisibilityGraphTestTools.assertVisibilityMapsEqual(visibilityMapWithNavigableRegion.getVisibilityMapInWorld(), visibilityMapWithNavigableRegion.getVisibilityMapInWorld(), 1.0E-12);
            VisibilityGraphTestTools.assertClustersEqual(homeRegionCluster, visibilityMapWithNavigableRegion.getHomeRegionCluster(), 1.0E-12);
            for (i = 0; i < numberOfObstacleClusters; ++i) {
                VisibilityGraphTestTools.assertClustersEqual((Cluster)obstacleClusters.get(i), (Cluster)visibilityMapWithNavigableRegion.getObstacleClusters().get(i), 1.0E-12);
            }
        }
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(NavigableRegion.class, NavigableRegionTest.class);
    }
}

