/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs.dataStructure;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.math3.util.Precision;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.ConnectionPoint3D;
import us.ihmc.robotics.Assert;

public class ConnectionPoint3DTest {
    private static final int ITERATIONS = 10000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testGetAndGetRounded() {
        ConnectionPoint3D point = new ConnectionPoint3D(1.00002, 2.00014, 3.00026, 144);
        Assert.assertEquals((long)144L, (long)point.getRegionId());
        Assert.assertEquals((double)1.00002, (double)point.getX(), (double)1.0E-12);
        Assert.assertEquals((double)1.0, (double)ConnectionPoint3D.round((double)point.getX()), (double)1.0E-12);
        Assert.assertEquals((double)2.00014, (double)point.getY(), (double)1.0E-12);
        Assert.assertEquals((double)2.0001, (double)ConnectionPoint3D.round((double)point.getY()), (double)1.0E-12);
        Assert.assertEquals((double)3.00026, (double)point.getZ(), (double)1.0E-12);
        Assert.assertEquals((double)3.0003, (double)ConnectionPoint3D.round((double)point.getZ()), (double)1.0E-12);
        Assert.assertEquals((long)-1749098234L, (long)point.hashCode());
        Point2D tuple = new Point2D(1.7000055, -3.40003);
        point = new ConnectionPoint3D((Tuple2DReadOnly)tuple, 149);
        Assert.assertEquals((long)149L, (long)point.getRegionId());
        Assert.assertEquals((double)1.7000055, (double)point.getX(), (double)1.0E-12);
        Assert.assertEquals((double)1.7, (double)ConnectionPoint3D.round((double)point.getX()), (double)1.0E-12);
        Assert.assertEquals((double)-3.40003, (double)point.getY(), (double)1.0E-12);
        Assert.assertEquals((double)-3.4, (double)ConnectionPoint3D.round((double)point.getY()), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)point.getZ(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)ConnectionPoint3D.round((double)point.getZ()), (double)1.0E-12);
        Assert.assertEquals((long)154188729L, (long)point.hashCode());
        ConnectionPoint3D pointCopy = new ConnectionPoint3D(point);
        Assert.assertEquals((Object)pointCopy, (Object)point);
        Assert.assertEquals((double)point.getX(), (double)pointCopy.getX(), (double)1.0E-12);
        Assert.assertEquals((double)point.getY(), (double)pointCopy.getY(), (double)1.0E-12);
        Assert.assertEquals((double)point.getZ(), (double)pointCopy.getZ(), (double)1.0E-12);
        Assert.assertEquals((long)point.getRegionId(), (long)pointCopy.getRegionId());
        String outputString = point.toString();
        Assert.assertEquals((Object)"ConnectionPoint3D: ( 1.700, -3.400,  0.000 )", (Object)outputString);
    }

    @Test
    public void testToString() {
        Point2D tuple = new Point2D(1.7000055, -3.40003);
        ConnectionPoint3D point = new ConnectionPoint3D((Tuple2DReadOnly)tuple, 149);
        String outputString = point.toString();
        Assert.assertEquals((Object)"ConnectionPoint3D: ( 1.700, -3.400,  0.000 )", (Object)outputString);
    }

    @Test
    public void testHashCode() {
        ConnectionPoint3D point = new ConnectionPoint3D(1.00002, 2.00014, 3.00026, 144);
        int hashCode = point.hashCode();
        Assert.assertEquals((long)-1749098234L, (long)hashCode);
        ConnectionPoint3D pointTwo = new ConnectionPoint3D(ConnectionPoint3D.round((double)point.getX()), ConnectionPoint3D.round((double)point.getY()), ConnectionPoint3D.round((double)point.getZ()), point.getRegionId() + 100);
        Assert.assertEquals((long)hashCode, (long)pointTwo.hashCode());
    }

    @Test
    public void testEquals() {
        ConnectionPoint3D pointOne = new ConnectionPoint3D(1.00002, 2.00014, 3.00026, 144);
        ConnectionPoint3D pointTwo = new ConnectionPoint3D(1.0, 2.0001, 3.0003, 149);
        ConnectionPoint3D pointThree = new ConnectionPoint3D(1.0, 2.0001, 3.0002, 144);
        Assert.assertTrue((boolean)pointOne.equals(pointTwo));
        Assert.assertTrue((boolean)pointTwo.equals(pointOne));
        Assert.assertEquals((long)pointOne.hashCode(), (long)pointTwo.hashCode());
        Assert.assertNotEquals((long)pointOne.hashCode(), (long)pointThree.hashCode());
        Assert.assertNotEquals((long)pointTwo.hashCode(), (long)pointThree.hashCode());
        Assert.assertFalse((boolean)pointOne.equals(pointThree));
        Assert.assertFalse((boolean)pointTwo.equals(pointThree));
        ConnectionPoint3D nullConnectionPoint3D = null;
        Assert.assertFalse((boolean)pointOne.equals(nullConnectionPoint3D));
        Assert.assertFalse((boolean)pointTwo.equals(nullConnectionPoint3D));
        Assert.assertFalse((boolean)pointThree.equals(nullConnectionPoint3D));
        Object nullObject = null;
        Assert.assertFalse((boolean)pointOne.equals(nullObject));
        Assert.assertFalse((boolean)pointTwo.equals(nullObject));
        Assert.assertFalse((boolean)pointThree.equals(nullObject));
    }

    @Test
    public void testEqualsTwo() {
        ConnectionPoint3D pointOne = new ConnectionPoint3D(1.00002, 2.00014, 3.00026, 144);
        ConnectionPoint3D pointTwo = new ConnectionPoint3D(1.0, 2.0001, 3.0003, 190);
        Point3D pointOneAsPoint3D = new Point3D(1.00002, 2.00014, 3.00026);
        Point3D pointTwoAsPoint3D = new Point3D(1.0, 2.0001, 3.0003);
        Assert.assertEquals((Object)pointOne, (Object)pointTwo);
        Assert.assertEquals((long)pointOne.hashCode(), (long)pointTwo.hashCode());
        Assert.assertEquals((Object)pointOne, (Object)pointOneAsPoint3D);
        Assert.assertEquals((Object)pointOneAsPoint3D, (Object)pointOne);
        Assert.assertEquals((Object)pointTwo, (Object)pointTwoAsPoint3D);
        Assert.assertEquals((Object)pointTwoAsPoint3D, (Object)pointTwo);
        Assert.assertNotEquals((Object)pointOne, (Object)pointTwoAsPoint3D);
        Assert.assertNotEquals((Object)pointTwoAsPoint3D, (Object)pointOne);
        Assert.assertNotEquals((Object)pointTwo, (Object)pointOneAsPoint3D);
        Assert.assertNotEquals((Object)pointOneAsPoint3D, (Object)pointTwo);
        Assert.assertNotEquals((Object)pointOneAsPoint3D, (Object)pointTwoAsPoint3D);
        ConnectionPoint3D pointThree = new ConnectionPoint3D(1.0, 2.0001, 3.0002, 144);
        Assert.assertNotEquals((Object)pointOne, (Object)pointThree);
        Assert.assertNotEquals((Object)pointThree, (Object)pointOne);
    }

    @Test
    public void testEqualsAndHashConsistency() {
        ConnectionPoint3D pointOne = new ConnectionPoint3D(1.00002, 2.00014, 3.00026, 144);
        for (double delta = -0.1; delta < 0.1; delta += 1.0E-7) {
            boolean hashAreEqual;
            ConnectionPoint3D pointTwo = new ConnectionPoint3D(pointOne.getX() + delta, pointOne.getY(), pointOne.getZ(), pointOne.getRegionId() + 33);
            boolean areEqual = pointOne.equals(pointTwo);
            boolean bl = hashAreEqual = pointOne.hashCode() == pointTwo.hashCode();
            if (!areEqual) continue;
            Assert.assertTrue((boolean)hashAreEqual);
        }
    }

    @Test
    public void testApplyTransformAndInverseTransform() {
        ConnectionPoint3D pointOne = new ConnectionPoint3D(1.0000023, 2.0000028, 3.0000063, 144);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getTranslation().set(4.0, -2.0, 9.0);
        ConnectionPoint3D pointTwo = pointOne.applyTransform((Transform)transform);
        Assert.assertEquals((double)5.0000023, (double)pointTwo.getX(), (double)1.0E-12);
        Assert.assertEquals((double)2.8E-6, (double)pointTwo.getY(), (double)1.0E-12);
        Assert.assertEquals((double)12.0000063, (double)pointTwo.getZ(), (double)1.0E-12);
        Assert.assertEquals((long)144L, (long)pointTwo.getRegionId());
        ConnectionPoint3D pointThree = pointTwo.applyInverseTransform((Transform)transform);
        Assert.assertEquals((double)1.0000023, (double)pointThree.getX(), (double)1.0E-12);
        Assert.assertEquals((double)2.0000028, (double)pointThree.getY(), (double)1.0E-12);
        Assert.assertEquals((double)3.0000063, (double)pointThree.getZ(), (double)1.0E-12);
        Assert.assertEquals((long)144L, (long)pointThree.getRegionId());
        Assert.assertTrue((boolean)pointThree.equals(pointOne));
        Assert.assertEquals((Object)pointThree, (Object)pointOne);
        Assert.assertEquals((long)pointThree.getRegionId(), (long)pointOne.getRegionId());
    }

    @Test
    public void testRound() throws Exception {
        Random random = new Random(43566787L);
        for (int i = 0; i < 10000; ++i) {
            double raw = EuclidCoreRandomTools.nextDouble((Random)random, (double)1000.0);
            double expected = Precision.round((double)raw, (int)4);
            double actual = ConnectionPoint3D.round((double)raw);
            Assert.assertEquals((double)expected, (double)actual, (double)1.0E-12);
        }
    }

    public static void main(String[] args) throws IOException {
        MutationTestFacilitator.facilitateMutationTestForClass(ConnectionPoint3D.class, ConnectionPoint3DTest.class);
    }
}

