/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs;

import java.util.Arrays;
import java.util.Comparator;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.Cluster;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.Connection;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.ConnectionPoint3D;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityGraphHolder;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMap;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMapWithNavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.VisibilityMapHolder;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTestTools;

public class VisibilityGraphTestTools {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    public static void assertVisibilityGraphStatisticsEqual(VisibilityGraphHolder expected, VisibilityGraphHolder actual, double epsilon) {
        Assert.assertEquals((long)expected.getGoalMapId(), (long)actual.getGoalMapId());
        Assert.assertEquals((long)expected.getStartMapId(), (long)actual.getStartMapId());
        Assert.assertEquals((long)expected.getInterRegionsMapId(), (long)actual.getInterRegionsMapId());
        VisibilityGraphTestTools.assertVisibilityMapsEqual(expected.getGoalVisibilityMap(), actual.getGoalVisibilityMap(), epsilon);
        VisibilityGraphTestTools.assertVisibilityMapsEqual(expected.getStartVisibilityMap(), actual.getStartVisibilityMap(), epsilon);
        VisibilityGraphTestTools.assertVisibilityMapsEqual(expected.getInterRegionsVisibilityMap(), actual.getInterRegionsVisibilityMap(), epsilon);
        Assert.assertEquals((long)expected.getNumberOfNavigableRegions(), (long)actual.getNumberOfNavigableRegions());
        for (int i = 0; i < expected.getNumberOfNavigableRegions(); ++i) {
            VisibilityGraphTestTools.assertNavigableRegionsEqual(expected.getNavigableRegion(i), actual.getNavigableRegion(i), epsilon);
        }
    }

    public static void assertVisibilityMapHoldersEqual(VisibilityMapHolder holderExpected, VisibilityMapHolder holderActual, double epsilon) {
        Assert.assertEquals((long)holderExpected.getMapId(), (long)holderActual.getMapId());
        VisibilityGraphTestTools.assertVisibilityMapsEqual(holderExpected.getVisibilityMapInWorld(), holderActual.getVisibilityMapInWorld(), epsilon);
        VisibilityGraphTestTools.assertVisibilityMapsEqual(holderExpected.getVisibilityMapInLocal(), holderActual.getVisibilityMapInLocal(), epsilon);
        for (Connection connection : holderExpected.getVisibilityMapInWorld().getConnections()) {
            Assert.assertEquals((double)holderExpected.getConnectionWeight(connection), (double)holderActual.getConnectionWeight(connection), (double)epsilon);
        }
        for (Connection connection : holderExpected.getVisibilityMapInLocal().getConnections()) {
            Assert.assertEquals((double)holderExpected.getConnectionWeight(connection), (double)holderActual.getConnectionWeight(connection), (double)epsilon);
        }
    }

    public static void assertSingleSourceVisibilityMapHoldersEqual(VisibilityMapHolder holderExpected, VisibilityMapHolder holderActual, double epsilon) {
        Assert.assertEquals((long)holderExpected.getMapId(), (long)holderActual.getMapId());
        VisibilityGraphTestTools.assertVisibilityMapsEqual(holderExpected.getVisibilityMapInWorld(), holderActual.getVisibilityMapInWorld(), epsilon);
        for (Connection connection : holderExpected.getVisibilityMapInWorld().getConnections()) {
            Assert.assertEquals((double)holderExpected.getConnectionWeight(connection), (double)holderActual.getConnectionWeight(connection), (double)epsilon);
        }
    }

    public static void assertVisibilityMapsEqual(VisibilityMap mapExpected, VisibilityMap mapActual, double epsilon) {
        int i;
        Assert.assertEquals((long)mapExpected.getConnections().size(), (long)mapActual.getConnections().size());
        Assert.assertEquals((long)mapExpected.getVertices().size(), (long)mapActual.getVertices().size());
        Connection[] expectedConnections = mapExpected.getConnections().toArray(new Connection[0]);
        Connection[] actualConnections = mapActual.getConnections().toArray(new Connection[0]);
        Comparator<Connection> connectionComparator = new Comparator<Connection>(){

            @Override
            public int compare(Connection connectionPoint3D, Connection t1) {
                if (connectionPoint3D.getSourcePoint().getRegionId() < t1.getSourcePoint().getRegionId()) {
                    return -1;
                }
                if (connectionPoint3D.getSourcePoint().getRegionId() > t1.getSourcePoint().getRegionId()) {
                    return 1;
                }
                if (connectionPoint3D.getTargetPoint().getRegionId() < t1.getTargetPoint().getRegionId()) {
                    return -1;
                }
                if (connectionPoint3D.getTargetPoint().getRegionId() > t1.getTargetPoint().getRegionId()) {
                    return 1;
                }
                if (connectionPoint3D.getSourcePoint().getX() < t1.getSourcePoint().getX()) {
                    return -1;
                }
                if (connectionPoint3D.getSourcePoint().getX() > t1.getSourcePoint().getX()) {
                    return 1;
                }
                if (connectionPoint3D.getTargetPoint().getX() < t1.getTargetPoint().getX()) {
                    return -1;
                }
                if (connectionPoint3D.getTargetPoint().getX() > t1.getTargetPoint().getX()) {
                    return 1;
                }
                if (connectionPoint3D.getSourcePoint().getY() < t1.getSourcePoint().getY()) {
                    return -1;
                }
                if (connectionPoint3D.getSourcePoint().getY() > t1.getSourcePoint().getY()) {
                    return 1;
                }
                if (connectionPoint3D.getTargetPoint().getY() < t1.getTargetPoint().getY()) {
                    return -1;
                }
                if (connectionPoint3D.getTargetPoint().getY() > t1.getTargetPoint().getY()) {
                    return 1;
                }
                if (connectionPoint3D.getSourcePoint().getZ() < t1.getSourcePoint().getZ()) {
                    return -1;
                }
                if (connectionPoint3D.getSourcePoint().getZ() > t1.getTargetPoint().getZ()) {
                    return 1;
                }
                if (connectionPoint3D.getTargetPoint().getZ() < t1.getTargetPoint().getZ()) {
                    return -1;
                }
                if (connectionPoint3D.getTargetPoint().getZ() > t1.getTargetPoint().getZ()) {
                    return 1;
                }
                return 0;
            }
        };
        Arrays.sort(expectedConnections, connectionComparator);
        Arrays.sort(actualConnections, connectionComparator);
        ConnectionPoint3D[] expectedVertices = mapExpected.getVertices().toArray(new ConnectionPoint3D[0]);
        ConnectionPoint3D[] actualVertices = mapActual.getVertices().toArray(new ConnectionPoint3D[0]);
        Comparator<ConnectionPoint3D> pointComparator = new Comparator<ConnectionPoint3D>(){

            @Override
            public int compare(ConnectionPoint3D connectionPoint3D, ConnectionPoint3D t1) {
                if (connectionPoint3D.getRegionId() < t1.getRegionId()) {
                    return -1;
                }
                if (connectionPoint3D.getRegionId() > t1.getRegionId()) {
                    return 1;
                }
                if (connectionPoint3D.getX() < t1.getX()) {
                    return -1;
                }
                if (connectionPoint3D.getX() > t1.getX()) {
                    return 1;
                }
                if (connectionPoint3D.getY() < t1.getY()) {
                    return -1;
                }
                if (connectionPoint3D.getY() > t1.getY()) {
                    return 1;
                }
                if (connectionPoint3D.getZ() < t1.getZ()) {
                    return -1;
                }
                if (connectionPoint3D.getZ() > t1.getZ()) {
                    return 1;
                }
                return 0;
            }
        };
        Arrays.sort(expectedVertices, pointComparator);
        Arrays.sort(actualVertices, pointComparator);
        for (i = 0; i < mapExpected.getVertices().size(); ++i) {
            VisibilityGraphTestTools.assertConnectionPointsEqual(expectedVertices[i], actualVertices[i], epsilon);
        }
        for (i = 0; i < mapExpected.getConnections().size(); ++i) {
            VisibilityGraphTestTools.assertConnectionsEqual(expectedConnections[i], actualConnections[i], epsilon);
        }
    }

    public static void assertConnectionsEqual(Connection connectionExpected, Connection connectionActual, double epsilon) {
        VisibilityGraphTestTools.assertConnectionPointsEqual(connectionExpected.getSourcePoint(), connectionActual.getSourcePoint(), epsilon);
        VisibilityGraphTestTools.assertConnectionPointsEqual(connectionExpected.getTargetPoint(), connectionActual.getTargetPoint(), epsilon);
    }

    public static void assertConnectionPointsEqual(ConnectionPoint3D pointExpected, ConnectionPoint3D pointActual, double epsilon) {
        Assert.assertEquals((long)pointExpected.getRegionId(), (long)pointActual.getRegionId());
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)pointExpected, (Point3DReadOnly)pointActual, (double)epsilon);
    }

    public static void assertClustersEqual(Cluster clusterExpected, Cluster clusterActual, double epsilon) {
        Assert.assertEquals((Object)clusterExpected.getExtrusionSide(), (Object)clusterActual.getExtrusionSide());
        Assert.assertEquals((Object)clusterExpected.getType(), (Object)clusterActual.getType());
        final RigidBodyTransform transformExpected = clusterExpected.getTransformToWorld();
        ReferenceFrame localFrame = new ReferenceFrame("localFrame", worldFrame){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                transformToParent.set(transformExpected);
            }
        };
        localFrame.update();
        EuclidCoreTestTools.assertRigidBodyTransformGeometricallyEquals((RigidBodyTransform)transformExpected, (RigidBodyTransform)clusterActual.getTransformToWorld(), (double)epsilon);
        int numberOfRawPoints = clusterExpected.getRawPointsInLocal2D().size();
        Assert.assertEquals((long)numberOfRawPoints, (long)clusterActual.getNumberOfRawPoints());
        Assert.assertEquals((long)numberOfRawPoints, (long)clusterExpected.getNumberOfRawPoints());
        Assert.assertEquals((long)numberOfRawPoints, (long)clusterExpected.getRawPointsInLocal2D().size());
        Assert.assertEquals((long)numberOfRawPoints, (long)clusterExpected.getRawPointsInWorld().size());
        Assert.assertEquals((long)numberOfRawPoints, (long)clusterExpected.getRawPointsInLocal3D().size());
        Assert.assertEquals((long)numberOfRawPoints, (long)clusterActual.getRawPointsInLocal2D().size());
        Assert.assertEquals((long)numberOfRawPoints, (long)clusterActual.getRawPointsInWorld().size());
        Assert.assertEquals((long)numberOfRawPoints, (long)clusterActual.getRawPointsInLocal3D().size());
        for (int i = 0; i < numberOfRawPoints; ++i) {
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)("Point " + i + " failed."), (Point3DReadOnly)clusterExpected.getRawPointInLocal(i), (Point3DReadOnly)clusterActual.getRawPointInLocal(i), (double)epsilon);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)("Point " + i + " failed."), (Point3DReadOnly)clusterExpected.getRawPointInWorld(i), (Point3DReadOnly)clusterActual.getRawPointInWorld(i), (double)epsilon);
            FramePoint3D point = new FramePoint3D(localFrame, (Tuple3DReadOnly)clusterExpected.getRawPointInLocal(i));
            point.changeFrame(worldFrame);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)("Point " + i + " failed."), (Point3DReadOnly)point, (Point3DReadOnly)clusterExpected.getRawPointInWorld(i), (double)epsilon);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)("Point " + i + " failed."), (Point3DReadOnly)point, (Point3DReadOnly)clusterActual.getRawPointInWorld(i), (double)epsilon);
        }
        int numberOfNavigableExtrusions = clusterExpected.getNumberOfNavigableExtrusions();
        Assert.assertEquals((long)numberOfNavigableExtrusions, (long)clusterActual.getNumberOfNavigableExtrusions());
        Assert.assertEquals((long)numberOfNavigableExtrusions, (long)clusterExpected.getNavigableExtrusionsInLocal().size());
        Assert.assertEquals((long)numberOfNavigableExtrusions, (long)clusterExpected.getNavigableExtrusionsInWorld().size());
        Assert.assertEquals((long)numberOfNavigableExtrusions, (long)clusterActual.getNavigableExtrusionsInLocal().size());
        Assert.assertEquals((long)numberOfNavigableExtrusions, (long)clusterActual.getNavigableExtrusionsInWorld().size());
        for (int i = 0; i < numberOfNavigableExtrusions; ++i) {
            EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)clusterExpected.getNavigableExtrusionInLocal(i), (Point2DReadOnly)clusterActual.getNavigableExtrusionInLocal(i), (double)epsilon);
        }
        int numberOfNonNavigableExtrusions = clusterExpected.getNumberOfNonNavigableExtrusions();
        Assert.assertEquals((long)numberOfNonNavigableExtrusions, (long)clusterActual.getNumberOfNonNavigableExtrusions());
        Assert.assertEquals((long)numberOfNonNavigableExtrusions, (long)clusterExpected.getNonNavigableExtrusionsInWorld().size());
        Assert.assertEquals((long)numberOfNonNavigableExtrusions, (long)clusterExpected.getNonNavigableExtrusionsInLocal().size());
        Assert.assertEquals((long)numberOfNonNavigableExtrusions, (long)clusterActual.getNonNavigableExtrusionsInWorld().size());
        Assert.assertEquals((long)numberOfNonNavigableExtrusions, (long)clusterActual.getNonNavigableExtrusionsInLocal().size());
        for (int i = 0; i < numberOfNonNavigableExtrusions; ++i) {
            EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)clusterExpected.getNonNavigableExtrusionInLocal(i), (Point2DReadOnly)clusterActual.getNonNavigableExtrusionInLocal(i), (double)epsilon);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)clusterExpected.getNonNavigableExtrusionInWorld(i), (Point3DReadOnly)clusterActual.getNonNavigableExtrusionInWorld(i), (double)epsilon);
            FramePoint3D framePoint = new FramePoint3D(localFrame, (Tuple2DReadOnly)clusterExpected.getNonNavigableExtrusionInLocal(i));
            framePoint.changeFrame(worldFrame);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)framePoint, (Point3DReadOnly)clusterExpected.getNonNavigableExtrusionInWorld(i), (double)epsilon);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)framePoint, (Point3DReadOnly)clusterActual.getNonNavigableExtrusionInWorld(i), (double)epsilon);
        }
    }

    public static void assertNavigableRegionsEqual(VisibilityMapWithNavigableRegion expected, VisibilityMapWithNavigableRegion actual, double epsilon) {
        int i;
        Assert.assertEquals((long)expected.getMapId(), (long)actual.getMapId());
        VisibilityGraphTestTools.assertClustersEqual(expected.getHomeRegionCluster(), actual.getHomeRegionCluster(), epsilon);
        PlanarRegionTestTools.assertPlanarRegionsEqual((PlanarRegion)expected.getHomePlanarRegion(), (PlanarRegion)actual.getHomePlanarRegion(), (double)epsilon);
        Assert.assertEquals((long)expected.getObstacleClusters().size(), (long)actual.getObstacleClusters().size());
        Assert.assertEquals((long)expected.getAllClusters().size(), (long)actual.getAllClusters().size());
        for (i = 0; i < expected.getObstacleClusters().size(); ++i) {
            VisibilityGraphTestTools.assertClustersEqual((Cluster)expected.getObstacleClusters().get(i), (Cluster)actual.getObstacleClusters().get(i), epsilon);
        }
        for (i = 0; i < expected.getAllClusters().size(); ++i) {
            VisibilityGraphTestTools.assertClustersEqual((Cluster)expected.getAllClusters().get(i), (Cluster)actual.getAllClusters().get(i), epsilon);
        }
        VisibilityGraphTestTools.assertVisibilityMapsEqual(expected.getVisibilityMapInLocal(), actual.getVisibilityMapInLocal(), epsilon);
        VisibilityGraphTestTools.assertVisibilityMapsEqual(expected.getVisibilityMapInWorld(), actual.getVisibilityMapInWorld(), epsilon);
    }
}

