/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.pathPlanning.visibilityGraphs;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.ContinuousIntegrationTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Ellipsoid3D;
import us.ihmc.euclid.shape.primitives.interfaces.Ellipsoid3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.log.LogTools;
import us.ihmc.pathPlanning.DataSet;
import us.ihmc.pathPlanning.DataSetIOTools;
import us.ihmc.pathPlanning.DataSetName;
import us.ihmc.pathPlanning.bodyPathPlanner.WaypointDefinedBodyPathPlanHolder;
import us.ihmc.pathPlanning.visibilityGraphs.NavigableRegionsManager;
import us.ihmc.pathPlanning.visibilityGraphs.VisibilityGraphsTestVisualizerApplication;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.Cluster;
import us.ihmc.pathPlanning.visibilityGraphs.clusterManagement.ExtrusionHull;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityGraphNavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityGraphNode;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMapSolution;
import us.ihmc.pathPlanning.visibilityGraphs.dataStructure.VisibilityMapWithNavigableRegion;
import us.ihmc.pathPlanning.visibilityGraphs.graphSearch.EstimatedCostToGoal;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.InterRegionConnectionFilter;
import us.ihmc.pathPlanning.visibilityGraphs.interfaces.NavigableExtrusionDistanceCalculator;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.DefaultVisibilityGraphParameters;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersBasics;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersReadOnly;
import us.ihmc.pathPlanning.visibilityGraphs.postProcessing.BodyPathPostProcessor;
import us.ihmc.pathPlanning.visibilityGraphs.postProcessing.ObstacleAvoidanceProcessor;
import us.ihmc.pathPlanning.visibilityGraphs.postProcessing.PathOrientationCalculator;
import us.ihmc.pathPlanning.visibilityGraphs.tools.TestEnvironmentTools;
import us.ihmc.pathPlanning.visibilityGraphs.tools.VisibilityTools;
import us.ihmc.pathPlanning.visibilityGraphs.ui.messager.UIVisibilityGraphsTopics;
import us.ihmc.robotEnvironmentAwareness.geometry.ConcaveHullDecomposition;
import us.ihmc.robotEnvironmentAwareness.planarRegion.PlanarRegionFilter;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.PlanarRegionsListGenerator;

public class NavigableRegionsManagerTest {
    private static boolean visualize = true;
    private static final double epsilon = 1.0E-4;
    private static final double proximityEpsilon = 0.06;
    private static boolean DEBUG = false;
    private static VisibilityGraphsTestVisualizerApplication visualizerApplication = null;
    private static JavaFXMessager messager = null;
    private static final double walkerOffsetHeight = 0.75;
    private static final double obstacleExtrusionDistance = 0.2;
    private static final double preferredObstacleExtrusionDistance = 1.0;
    private static final Vector3D walkerRadii = new Vector3D(0.2, 1.0, 0.5);
    private static final Vector3D walkerBox = new Vector3D(0.4, 2.0, 1.0);

    @BeforeEach
    public void setup() {
        visualize = visualize && !ContinuousIntegrationTools.isRunningOnContinuousIntegrationServer();
        boolean bl = DEBUG = visualize || DEBUG && !ContinuousIntegrationTools.isRunningOnContinuousIntegrationServer();
        if (visualize) {
            visualizerApplication = new VisibilityGraphsTestVisualizerApplication();
            visualizerApplication.startOnAThread();
            messager = visualizerApplication.getMessager();
            messager.submitMessage(UIVisibilityGraphsTopics.EnableWalkerAnimation, (Object)false);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerOffsetHeight, (Object)0.75);
            messager.submitMessage(UIVisibilityGraphsTopics.WalkerSize, (Object)walkerRadii);
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (visualize) {
            visualizerApplication.stop();
            visualizerApplication = null;
            messager = null;
        }
    }

    @Test
    public void testFlatGroundWithWallInlineWithWall() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithWallEnvironment());
        Point3D start = new Point3D(-15.0, 0.0, 0.0);
        Point3D goal = new Point3D(-5.0, 0.0, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithWallOnOppositeSidesOfWall() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithWallEnvironment());
        Point3D start = new Point3D(-15.0, 1.0, 0.0);
        Point3D goal = new Point3D(-5.0, 1.0, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithWallStraightShotButVeryNearWall() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithWallEnvironment());
        Point3D start = new Point3D(-15.0, -0.05 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        Point3D goal = new Point3D(-5.0, -0.05 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithWallStraightShotButNearWall() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithWallEnvironment());
        Point3D start = new Point3D(-15.0, -0.1 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        Point3D goal = new Point3D(-5.0, -0.1 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithWallAlmostStraightShot() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithWallEnvironment());
        Point3D start = new Point3D(-15.0, -0.95 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        Point3D goal = new Point3D(-5.0, -0.95 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithWallStraightShot() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithWallEnvironment());
        Point3D start = new Point3D(-15.0, -1.05 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        Point3D goal = new Point3D(-5.0, -1.05 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithBoxInlineWithWall() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithBoxEnvironment());
        Point3D start = new Point3D(-15.0, 0.0, 0.0);
        Point3D goal = new Point3D(-5.0, 0.0, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithBoxOnOppositeSidesOfWall() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithBoxEnvironment());
        Point3D start = new Point3D(-15.0, 1.0, 0.0);
        Point3D goal = new Point3D(-5.0, 1.0, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithBoxStraightShotButVeryNearWall() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithBoxEnvironment());
        Point3D start = new Point3D(-15.0, -0.05 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        Point3D goal = new Point3D(-5.0, -0.05 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithBoxStraightShotButNearWall() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithBoxEnvironment());
        Point3D start = new Point3D(-15.0, -0.1 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        Point3D goal = new Point3D(-5.0, -0.1 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithBoxAlmostStraightShot() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithBoxEnvironment());
        Point3D start = new Point3D(-15.0, -0.95 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        Point3D goal = new Point3D(-5.0, -0.95 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithBoxStraightShot() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithBoxEnvironment());
        Point3D start = new Point3D(-15.0, -1.05 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        Point3D goal = new Point3D(-5.0, -1.05 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundWithTwoDifferentWalls() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundTwoDifferentWidthWallsEnvironment());
        Point3D start = new Point3D(-15.0, -0.5 * parameters.getObstacleExtrusionDistance(), 0.0);
        Point3D goal = new Point3D(-5.0, -0.5 * parameters.getObstacleExtrusionDistance(), 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
        start = new Point3D(-15.0, 1.0 * parameters.getPreferredObstacleExtrusionDistance(), 0.0);
        path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundBetweenWallOpening() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithWallOpeningEnvironment());
        Point3D start = new Point3D(-15.0, 1.5, 0.0);
        Point3D goal = new Point3D(-5.0, 1.5, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundBetweenWallOpeningStraightShot() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithWallOpeningEnvironment());
        Point3D start = new Point3D(-15.0, 0.0, 0.0);
        Point3D goal = new Point3D(-5.0, 0.0, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundBetweenAwkwardWallOpening() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithWallAwkwardOpeningEnvironment());
        Point3D start = new Point3D(-15.0, 1.5, 0.0);
        Point3D goal = new Point3D(-5.0, 1.5, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundBetweenBoxesOpening() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithBoxesEnvironment());
        Point3D start = new Point3D(-15.0, 1.5, 0.0);
        Point3D goal = new Point3D(-5.0, 1.5, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundBetweenBoxesOpeningStraightShot() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithBoxesEnvironment());
        Point3D start = new Point3D(-15.0, 0.0, 0.0);
        Point3D goal = new Point3D(-5.0, 0.0, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testFlatGroundBetweenBoxInMiddle() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithBoxInMiddleEnvironment());
        Point3D start = new Point3D(-15.0, 0.0, 0.0);
        Point3D goal = new Point3D(-5.0, 0.0, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList(), 0.15);
    }

    @Test
    public void testFlatGroundBetweenBoxInMiddleButExtraSupportToTheLeft() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createFlatGroundWithBoxInMiddleEnvironmentButIslandToTheLeft());
        Point3D start = new Point3D(-15.0, 0.0, 0.0);
        Point3D goal = new Point3D(-5.0, 0.0, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
    }

    @Test
    public void testStairs() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        parameters.setPerformPostProcessingNodeShifting(false);
        parameters.setMaxInterRegionConnectionLength(0.25);
        parameters.setPreferredObstacleExtrusionDistance(1.0);
        parameters.setPreferredNavigableExtrusionDistance(0.2);
        parameters.setIncludePreferredExtrusions(true);
        double heightDelta = 0.1;
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.addRectangle(0.3, 1.0);
        generator.translate(0.3, 0.0, heightDelta);
        generator.addRectangle(0.3, 1.0);
        generator.translate(0.3, 0.0, heightDelta);
        generator.addRectangle(0.3, 1.0);
        generator.translate(0.65, 0.0, heightDelta);
        generator.addRectangle(1.0, 1.0);
        generator.translate(0.65, 0.0, -heightDelta);
        generator.addRectangle(0.3, 1.0);
        generator.translate(0.3, 0.0, -heightDelta);
        generator.addRectangle(0.3, 1.0);
        generator.translate(0.3, 0.0, -heightDelta);
        generator.addRectangle(0.3, 1.0);
        PlanarRegionsList planarRegionsList = generator.getPlanarRegionsList();
        Point3D start = new Point3D(0.0, 0.0, 0.0);
        Point3D goal = new Point3D(2.5, 0.0, 0.0);
        Point3D start2 = new Point3D(0.3, 0.0, 0.1);
        Point3D start3 = new Point3D(0.6, 0.0, 0.2);
        Point3D start4 = new Point3D(0.95, 0.0, 0.3);
        EstimatedCostToGoal heuristic = new EstimatedCostToGoal((VisibilityGraphsParametersReadOnly)parameters);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor, heuristic);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        VisibilityGraphNavigableRegion region1 = navigableRegionsManager.getVisibilityGraph().getVisibilityGraphNavigableRegionContainingThisPoint((Point3DReadOnly)start, 2.0, 0.1);
        VisibilityGraphNavigableRegion region2 = navigableRegionsManager.getVisibilityGraph().getVisibilityGraphNavigableRegionContainingThisPoint((Point3DReadOnly)start2, 2.0, 0.1);
        VisibilityGraphNavigableRegion region3 = navigableRegionsManager.getVisibilityGraph().getVisibilityGraphNavigableRegionContainingThisPoint((Point3DReadOnly)start3, 2.0, 0.1);
        ArrayList<Point3DReadOnly> expectedPath = new ArrayList<Point3DReadOnly>();
        expectedPath.add(this.getClosestPointOnClusterToPoint(((Cluster)region1.getNavigableRegion().getObstacleClusters().get(0)).getNavigableExtrusionsInWorld(), (Point3DReadOnly)start));
        expectedPath.add(this.getClosestPointOnClusterToPoint(region2.getNavigableRegion().getHomeRegionCluster().getNavigableExtrusionsInWorld(), (Point3DReadOnly)expectedPath.get(0)));
        expectedPath.add(this.getClosestPointOnClusterToPoint(((Cluster)region2.getNavigableRegion().getObstacleClusters().get(0)).getNavigableExtrusionsInWorld(), (Point3DReadOnly)expectedPath.get(1)));
        InterRegionConnectionFilter prefToPrefFilter = parameters.getPreferredToPreferredInterRegionConnectionFilter();
        Assert.assertTrue((region1.getAllPreferredNavigableNodes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((region2.getAllPreferredNavigableNodes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((region3.getAllPreferredNavigableNodes().size() == 1 ? 1 : 0) != 0);
        VisibilityGraphNode region1PrefNode = (VisibilityGraphNode)region1.getAllPreferredNavigableNodes().get(0);
        VisibilityGraphNode region2PrefNode = (VisibilityGraphNode)region2.getAllPreferredNavigableNodes().get(0);
        VisibilityGraphNode region3PrefNode = (VisibilityGraphNode)region3.getAllPreferredNavigableNodes().get(0);
        Assert.assertTrue((boolean)prefToPrefFilter.isConnectionValid(region1PrefNode.getPointInWorld(), region2PrefNode.getPointInWorld()));
        Assert.assertTrue((boolean)prefToPrefFilter.isConnectionValid(region1PrefNode.getPointInWorld(), region3PrefNode.getPointInWorld()));
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution(), 1.0);
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList(), 1.0);
    }

    public Point3DReadOnly getClosestPointOnClusterToPoint(List<Point3DReadOnly> points, Point3DReadOnly goal) {
        double minDistance = Double.POSITIVE_INFINITY;
        Point3DReadOnly pointTOReturn = null;
        for (Point3DReadOnly point : points) {
            double distance = point.distanceXY(goal);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            pointTOReturn = point;
        }
        return pointTOReturn;
    }

    @Disabled
    @Test
    public void testPartialShallowMaze() {
        this.testDataSet(DataSetName._20171114_135559_PartialShallowMaze);
    }

    @Disabled
    @Test
    public void testStairsUpDown() {
        this.testDataSet(DataSetName._20171215_214801_StairsUpDown);
    }

    @Disabled
    @Test
    public void testBodyPathPlannerEnvironment() {
        this.testDataSet(DataSetName._20171218_205120_BodyPathPlannerEnvironment);
    }

    private void testDataSet(DataSetName dataSetName) {
        DataSet dataSet = DataSetIOTools.loadDataSet((DataSetName)dataSetName);
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        parameters.setPerformPostProcessingNodeShifting(true);
        PlanarRegionsList planarRegionsList = dataSet.getPlanarRegionsList();
        Point3D start = dataSet.getPlannerInput().getStartPosition();
        Point3D goal = dataSet.getPlannerInput().getGoalPosition();
        Quaternion startOrientation = new Quaternion();
        Quaternion goalOrientation = new Quaternion();
        if (dataSet.getPlannerInput().hasStartOrientation()) {
            startOrientation.setToYawOrientation(dataSet.getPlannerInput().getStartYaw());
        }
        if (dataSet.getPlannerInput().hasGoalOrientation()) {
            goalOrientation.setToYawOrientation(dataSet.getPlannerInput().getGoalYaw());
        }
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        NavigableRegionsManager navigableRegionsManagerNoProcessor = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList());
        navigableRegionsManagerNoProcessor.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List pathNotProcessed = navigableRegionsManagerNoProcessor.calculateBodyPath((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)startOrientation, (Orientation3DReadOnly)goalOrientation);
        List posePathNotProcessed = orientationCalculator.computePosesFromPath(pathNotProcessed, navigableRegionsManagerNoProcessor.getVisibilityMapSolution(), (Orientation3DReadOnly)startOrientation, (Orientation3DReadOnly)goalOrientation);
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testGoingAroundACorner() {
        VisibilityGraphsParametersBasics parameters = this.createVisibilityGraphParametersForTest();
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createCornerEnvironment());
        Point3D start = new Point3D(0.0, 0.0, 0.0);
        Point3D goal = new Point3D(6.0, 30.0, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPathWithOcclusions((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    @Test
    public void testGoingAroundAU() {
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters();
        parameters.setPerformPostProcessingNodeShifting(true);
        parameters.setIntroduceMidpointsInPostProcessing(false);
        parameters.setComputeOrientationsToAvoidObstacles(false);
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(TestEnvironmentTools.createUCornerEnvironment());
        Point3D start = new Point3D(-3.0, 0.0, 0.0);
        Point3D goal = new Point3D(-3.0, 10.0, 0.0);
        PathOrientationCalculator orientationCalculator = new PathOrientationCalculator((VisibilityGraphsParametersReadOnly)parameters);
        ObstacleAvoidanceProcessor postProcessor = new ObstacleAvoidanceProcessor((VisibilityGraphsParametersReadOnly)parameters);
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager((VisibilityGraphsParametersReadOnly)parameters, planarRegionsList.getPlanarRegionsAsList(), (BodyPathPostProcessor)postProcessor);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List path = navigableRegionsManager.calculateBodyPathWithOcclusions((Point3DReadOnly)start, (Point3DReadOnly)goal);
        List posePath = orientationCalculator.computePosesFromPath(path, navigableRegionsManager.getVisibilityMapSolution(), (Orientation3DReadOnly)new Quaternion(), (Orientation3DReadOnly)new Quaternion());
        if (visualize) {
            NavigableRegionsManagerTest.visualize(posePath, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, start, goal, navigableRegionsManager.getNavigableRegionsList(), navigableRegionsManager.getVisibilityMapSolution());
        }
        NavigableRegionsManagerTest.checkPath(posePath, (Point3DReadOnly)start, (Point3DReadOnly)goal, (VisibilityGraphsParametersReadOnly)parameters, planarRegionsList, navigableRegionsManager.getNavigableRegionsList());
    }

    private static void checkPath(List<? extends Pose3DReadOnly> path, Point3DReadOnly start, Point3DReadOnly goal, VisibilityGraphsParametersReadOnly parameters, PlanarRegionsList planarRegionsList, List<VisibilityMapWithNavigableRegion> navigableRegionsList) {
        NavigableRegionsManagerTest.checkPath(path, start, goal, parameters, planarRegionsList, navigableRegionsList, 0.06);
    }

    private static void checkPath(List<? extends Pose3DReadOnly> path, Point3DReadOnly start, Point3DReadOnly goal, VisibilityGraphsParametersReadOnly parameters, PlanarRegionsList planarRegionsList, List<VisibilityMapWithNavigableRegion> navigableRegionsList, double proximityEpsilon) {
        NavigableRegionsManager navigableRegionsManager = new NavigableRegionsManager(parameters, planarRegionsList.getPlanarRegionsAsList(), null);
        navigableRegionsManager.setPlanarRegions(planarRegionsList.getPlanarRegionsAsList());
        List originalPath = navigableRegionsManager.calculateBodyPath(start, goal);
        String errorMessages = "";
        int numberOfPoints = path.size();
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)"Did not start at the desired location.", (Point3DReadOnly)start, (Point3DReadOnly)path.get(0).getPosition(), (double)1.0E-4);
        for (Pose3DReadOnly pose3DReadOnly : path) {
            Assert.assertFalse((boolean)pose3DReadOnly.containsNaN());
        }
        WaypointDefinedBodyPathPlanHolder calculatedPath = new WaypointDefinedBodyPathPlanHolder();
        calculatedPath.setPoseWaypoints(path);
        WaypointDefinedBodyPathPlanHolder waypointDefinedBodyPathPlanHolder = new WaypointDefinedBodyPathPlanHolder();
        waypointDefinedBodyPathPlanHolder.setWaypoints(originalPath);
        double distanceAlongExpectedPath = 0.0;
        Ellipsoid3D walkerShape = new Ellipsoid3D();
        walkerShape.getRadii().set((Tuple3DReadOnly)walkerRadii);
        ArrayList<Point3D> collisions = new ArrayList<Point3D>();
        for (double alpha = 0.05; alpha < 1.0; alpha += 0.001) {
            Point2D pointAlongExpectedPath;
            double newDistanceAlongExpectedPath;
            Pose3D expectedPose = new Pose3D();
            Pose3D actualPose = new Pose3D();
            waypointDefinedBodyPathPlanHolder.getPointAlongPath(alpha, (Pose3DBasics)expectedPose);
            calculatedPath.getPointAlongPath(alpha, (Pose3DBasics)actualPose);
            if (!expectedPose.getPosition().geometricallyEquals(actualPose.getPosition(), 1.0)) {
                errorMessages = errorMessages + NavigableRegionsManagerTest.fail("Pose was not as expected at alpha = " + alpha);
            }
            Point3D position3D = PlanarRegionTools.projectPointToPlanesVertically((Point3DReadOnly)new Point3D((Tuple3DReadOnly)actualPose.getPosition()), (PlanarRegionsList)planarRegionsList);
            Quaternion orientation = new Quaternion(actualPose.getYaw(), 0.0, 0.0);
            if (position3D == null) {
                position3D = new Point3D((Tuple3DReadOnly)actualPose.getPosition());
            }
            if (visualize) {
                messager.submitMessage(UIVisibilityGraphsTopics.WalkerPosition, (Object)new Point3D((Tuple3DReadOnly)position3D));
                messager.submitMessage(UIVisibilityGraphsTopics.WalkerOrientation, (Object)orientation);
                ThreadTools.sleep((long)10L);
            }
            if ((newDistanceAlongExpectedPath = waypointDefinedBodyPathPlanHolder.getClosestPoint((Point2DReadOnly)(pointAlongExpectedPath = new Point2D()), (Pose3DBasics)actualPose)) < distanceAlongExpectedPath) {
                errorMessages = errorMessages + NavigableRegionsManagerTest.fail("Not moving forward.");
            }
            distanceAlongExpectedPath = newDistanceAlongExpectedPath;
            double distanceToObstacles = Double.MAX_VALUE;
            Point2D closestPointOverall = new Point2D();
            for (VisibilityMapWithNavigableRegion navigableRegion : navigableRegionsList) {
                for (Cluster obstacleCluster : navigableRegion.getObstacleClusters()) {
                    ExtrusionHull clusterPolygon = obstacleCluster.getNonNavigableExtrusionsInWorld2D();
                    Point2D closestPointOnCluster = new Point2D();
                    double distanceToCluster = VisibilityTools.distanceToCluster((Point2DReadOnly)new Point2D((Tuple3DReadOnly)actualPose.getPosition()), (ExtrusionHull)clusterPolygon, (Point2DBasics)closestPointOnCluster, null);
                    if (!(distanceToCluster < distanceToObstacles)) continue;
                    distanceToObstacles = distanceToCluster;
                    closestPointOverall = closestPointOnCluster;
                }
            }
            Point3D walkerBody3D = new Point3D((Tuple3DReadOnly)position3D);
            walkerBody3D.addZ(0.75);
            walkerShape.getPosition().set((Tuple3DReadOnly)walkerBody3D);
            walkerShape.getOrientation().set((Orientation3DReadOnly)orientation);
            String newErrorMessages = NavigableRegionsManagerTest.walkerCollisionChecks(walkerShape, planarRegionsList, collisions, proximityEpsilon);
            errorMessages = errorMessages + newErrorMessages;
            if (!newErrorMessages.isEmpty() && visualize) {
                messager.submitMessage(UIVisibilityGraphsTopics.WalkerCollisionLocations, collisions);
            }
            distanceToObstacles += parameters.getObstacleExtrusionDistance();
            if (visualize && distanceToObstacles < 1.0 - proximityEpsilon) {
                Point3D collision = PlanarRegionTools.projectPointToPlanesVertically((Point3DReadOnly)new Point3D((Tuple2DReadOnly)closestPointOverall), (PlanarRegionsList)planarRegionsList);
                collisions.add(new Point3D((Tuple3DReadOnly)collision));
                messager.submitMessage(UIVisibilityGraphsTopics.WalkerCollisionLocations, collisions);
            }
            if (!(distanceToObstacles < 1.0 - proximityEpsilon)) continue;
            errorMessages = errorMessages + NavigableRegionsManagerTest.fail("Was too close to an obstacle.");
        }
        if (!errorMessages.isEmpty() && !visualize) {
            Assert.assertTrue((String)errorMessages, (boolean)false);
        } else {
            LogTools.info((String)errorMessages);
        }
    }

    private static String walkerCollisionChecks(Ellipsoid3D walkerShapeWorld, PlanarRegionsList planarRegionsList, List<Point3D> collisionsToPack, double proximityEpsilon) {
        String errorMessages = "";
        walkerShapeWorld = new Ellipsoid3D((Ellipsoid3DReadOnly)walkerShapeWorld);
        for (PlanarRegion planarRegion : planarRegionsList.getPlanarRegionsAsList()) {
            ConvexPolygon2D convexPolygon;
            Point2DBasics closestPoint2D;
            Point3D walkerPosition3D = new Point3D((Tuple3DReadOnly)walkerShapeWorld.getPosition());
            Plane3D plane = planarRegion.getPlane();
            Point3DBasics closestPoint = plane.orthogonalProjectionCopy((Point3DReadOnly)walkerPosition3D);
            if (!walkerShapeWorld.isPointInside((Point3DReadOnly)closestPoint)) continue;
            Ellipsoid3D walkerShapeLocal = new Ellipsoid3D((Ellipsoid3DReadOnly)walkerShapeWorld);
            planarRegion.transformFromWorldToLocal((Transformable)walkerShapeLocal);
            walkerPosition3D.set((Tuple3DReadOnly)walkerShapeLocal.getPosition());
            Point2D walkerPosition2D = new Point2D((Tuple3DReadOnly)walkerPosition3D);
            if (planarRegion.getNumberOfConvexPolygons() == 0) {
                ArrayList concaveHullVertices = new ArrayList(planarRegion.getConcaveHull());
                double depthThreshold = 0.05;
                ArrayList convexPolygons = new ArrayList();
                ConcaveHullDecomposition.recursiveApproximateDecomposition(concaveHullVertices, (double)depthThreshold, convexPolygons);
            }
            for (int i = 0; i < planarRegion.getNumberOfConvexPolygons() && (closestPoint2D = (convexPolygon = planarRegion.getConvexPolygon(i)).orthogonalProjectionCopy((Point2DReadOnly)walkerPosition2D)) != null; ++i) {
                closestPoint = new Point3D((Tuple2DReadOnly)closestPoint2D);
                if (!walkerShapeLocal.isPointInside((Point3DReadOnly)closestPoint, -proximityEpsilon)) continue;
                Point2DBasics intersectionLocal = closestPoint2D;
                Point3D intersectionWorld = new Point3D((Tuple2DReadOnly)intersectionLocal);
                planarRegion.transformFromLocalToWorld((Transformable)intersectionWorld);
                errorMessages = errorMessages + NavigableRegionsManagerTest.fail("Body path is going through a region at: " + intersectionWorld);
                collisionsToPack.add(intersectionWorld);
            }
        }
        return errorMessages;
    }

    private static String fail(String message) {
        return NavigableRegionsManagerTest.assertTrue(message, false);
    }

    private static String assertTrue(String message, boolean condition) {
        if ((visualize || DEBUG) && !condition) {
            LogTools.error((String)message);
        }
        return !condition ? "\n" + message : "";
    }

    private static void visualize(List<? extends Pose3DReadOnly> path, VisibilityGraphsParametersReadOnly parameters, PlanarRegionsList planarRegionsList, Point3D start, Point3D goal, List<VisibilityMapWithNavigableRegion> navigableRegions, VisibilityMapSolution mapSolution) {
        NavigableRegionsManagerTest.visualize(path, parameters, planarRegionsList, start, goal, navigableRegions, mapSolution, 0.06);
    }

    private static void visualize(List<? extends Pose3DReadOnly> path, VisibilityGraphsParametersReadOnly parameters, PlanarRegionsList planarRegionsList, Point3D start, Point3D goal, List<VisibilityMapWithNavigableRegion> navigableRegions, VisibilityMapSolution mapSolution, double proximityEpsilon) {
        Random random = new Random(324L);
        planarRegionsList.getPlanarRegionsAsList().forEach(region -> region.setRegionId(random.nextInt()));
        List pathPoints = path.stream().map(pose -> new Point3D((Tuple3DReadOnly)pose.getPosition())).collect(Collectors.toList());
        visualizerApplication.submitPlanarRegionsListToVisualizer(planarRegionsList);
        visualizerApplication.submitGoalToVisualizer(goal);
        visualizerApplication.submitStartToVisualizer(start);
        visualizerApplication.submitNavigableRegionsToVisualizer(navigableRegions);
        visualizerApplication.submitVisibilityGraphSolutionToVisualizer(mapSolution);
        messager.submitMessage(UIVisibilityGraphsTopics.BodyPathData, pathPoints);
        while (true) {
            NavigableRegionsManagerTest.checkPath(path, (Point3DReadOnly)start, (Point3DReadOnly)goal, parameters, planarRegionsList, navigableRegions, proximityEpsilon);
        }
    }

    private VisibilityGraphsParametersBasics createVisibilityGraphParametersForTest() {
        DefaultVisibilityGraphParameters parameters = new DefaultVisibilityGraphParameters(){

            public PlanarRegionFilter getPlanarRegionFilter() {
                return new PlanarRegionFilter(){

                    public boolean isPlanarRegionRelevant(PlanarRegion region) {
                        return true;
                    }
                };
            }

            public NavigableExtrusionDistanceCalculator getNavigableExtrusionDistanceCalculator() {
                return new NavigableExtrusionDistanceCalculator(){

                    public double computeNavigableExtrusionDistance(PlanarRegion navigableRegionToBeExtruded) {
                        return 0.01;
                    }
                };
            }
        };
        parameters.setObstacleExtrusionDistance(0.2);
        parameters.setPreferredObstacleExtrusionDistance(1.0);
        parameters.setPreferredNavigableExtrusionDistance(1.0);
        parameters.setIntroduceMidpointsInPostProcessing(true);
        parameters.setPerformPostProcessingNodeShifting(true);
        parameters.setComputeOrientationsToAvoidObstacles(true);
        return parameters;
    }
}

