/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization;

import com.sun.jna.Native;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;

public class QuadProgWrapper {
    int[] nIteration = new int[1];
    byte[] errMsg = new byte[512];
    double objVal = 0.0;
    static int nVariables;
    static int nEqualityConstraints;
    static int nInequalityConstraints;
    boolean coldStart;

    public QuadProgWrapper() {
        this(1, 1, 1);
    }

    public QuadProgWrapper(int nVariables, int nEqualityConstraints, int nInequalityConstraints) {
        this.initialize(nVariables, nEqualityConstraints, nInequalityConstraints);
    }

    public static native void initializeNative(int var0, int var1, int var2);

    public static native double solveNative(double[] var0, double[] var1, double[] var2, double[] var3, double[] var4, double[] var5, double[] var6, int[] var7, byte[] var8);

    private void initialize(int nVariables, int nEqualityConstraints, int nIneqalityConstraints) {
        block3: {
            block2: {
                if (QuadProgWrapper.nVariables != nVariables) break block2;
                if (QuadProgWrapper.nEqualityConstraints != nEqualityConstraints) break block2;
                if (nInequalityConstraints == nIneqalityConstraints) break block3;
            }
            QuadProgWrapper.initializeNative(nVariables, nEqualityConstraints, nIneqalityConstraints);
            QuadProgWrapper.nVariables = nVariables;
            QuadProgWrapper.nEqualityConstraints = nEqualityConstraints;
            nInequalityConstraints = nIneqalityConstraints;
            this.coldStart = true;
        }
    }

    public int solve(DMatrixRMaj Q, DMatrixRMaj f, DMatrixRMaj Aeq, DMatrixRMaj beq, DMatrixRMaj Ain, DMatrixRMaj bin, DMatrixRMaj x, boolean initialize) {
        if (Aeq.numRows != Ain.numRows || Aeq.numRows != x.numRows) {
            throw new RuntimeException("inconsistent constraints");
        }
        if (initialize) {
            this.coldStart = true;
        }
        this.initialize(Aeq.numRows, Aeq.numCols, Ain.numCols);
        this.objVal = QuadProgWrapper.solveNative(Q.getData(), f.getData(), Aeq.getData(), beq.getData(), Ain.getData(), bin.getData(), x.getData(), this.nIteration, this.errMsg);
        if (this.nIteration[0] < 0) {
            throw new RuntimeException(new String(this.errMsg));
        }
        this.coldStart = false;
        return this.nIteration[0];
    }

    public boolean isColdStart() {
        return this.coldStart;
    }

    public double getObjVal() {
        return this.objVal;
    }

    public static void main(String[] arg) {
        int nin = 1;
        int neq = 1;
        int nv = 2;
        DMatrixRMaj Q = new DMatrixRMaj(nv, nv, true, new double[]{1.0, 0.0, 0.0, 1.0});
        DMatrixRMaj f = new DMatrixRMaj(nv, 1, true, new double[]{1.0, 0.0});
        DMatrixRMaj Aeq = new DMatrixRMaj(nv, neq, true, new double[]{-1.0, -1.0});
        DMatrixRMaj beq = new DMatrixRMaj(neq, 1, true, new double[]{0.0});
        DMatrixRMaj Ain = new DMatrixRMaj(nv, nin, true, new double[]{-2.0, -1.0});
        DMatrixRMaj bin = new DMatrixRMaj(nin, 1, true, new double[]{0.0});
        DMatrixRMaj x = new DMatrixRMaj(nv, 1, true, new double[]{0.0, 0.0});
        QuadProgWrapper solver = new QuadProgWrapper();
        int iter = solver.solve(Q, f, Aeq, beq, Ain, bin, x, false);
        System.out.println("xopt=" + x + "iter=" + iter + " optVal=" + solver.getObjVal());
    }

    static {
        String library = NativeLibraryLoader.extractLibrary((String)"us.ihmc.convexOptimization", (String)"uQuadProg_rel");
        Native.register(QuadProgWrapper.class, (String)library);
    }
}

