/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.tralala;

import com.jme3.app.SimpleApplication;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Triangle;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.OctagonalEnvelope;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import com.vividsolutions.jts.triangulate.DelaunayTriangulationBuilder;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import us.ihmc.jMonkeyEngineToolkit.tralala.ImageUtilities;
import us.ihmc.jMonkeyEngineToolkit.tralala.MeshData;
import us.ihmc.jMonkeyEngineToolkit.tralala.Utilities;

public class ShapeUtilities {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory(new PrecisionModel());
    private static final int BLACK_COLOR_THRESHOLD = 60;
    private static final float PIXEL_DISTANCE = 1.0f;
    private static final float SIMPLIFY_AMOUNT = 1.0f;

    public static void testMain(SimpleApplication scene) {
        String shape = "shapes/public domain/tribal_star.png";
        float height = 0.05f;
        BufferedImage shapeImage = ImageUtilities.loadImage(shape, scene.getAssetManager());
        shapeImage = ImageUtilities.symmetrifyX(shapeImage, true, false);
        Geometry g = ShapeUtilities.createShape(shapeImage, height);
        g.setMaterial(Utilities.getUnshadedMaterial(scene.getAssetManager().loadTexture("Textures/CobbleStone.png"), null, RenderState.BlendMode.Off, scene.getAssetManager()));
        g.scale(10.0f);
        g.rotate(4.712389f, 0.0f, 0.0f);
        scene.getRootNode().attachChild((Spatial)g);
        scene.getViewPort().setBackgroundColor(new ColorRGBA(0.7f, 0.8f, 1.0f, 1.0f));
    }

    public static Geometry createShape(BufferedImage shapeImage, float height) {
        com.vividsolutions.jts.geom.Geometry geom = ShapeUtilities.createGeometry(shapeImage);
        geom = ShapeUtilities.combineComponents(geom, 1.0);
        geom = ShapeUtilities.simplify(geom, 1.0f);
        geom = ShapeUtilities.scale(geom, 1.0 / (double)shapeImage.getWidth(), 1.0 / (double)shapeImage.getHeight());
        MeshData mesh = ShapeUtilities.createShape(geom, 0.05f);
        Coordinate center = ShapeUtilities.getCenter(geom);
        mesh = mesh.translate(new Vector3f((float)(-center.x), 0.0f, (float)(-center.y)));
        Geometry g = new Geometry("", mesh.createMesh());
        return g;
    }

    public static MeshData createShape(com.vividsolutions.jts.geom.Geometry geom, float height) {
        com.vividsolutions.jts.geom.Geometry polygon = ShapeUtilities.triangulate(geom);
        ArrayList<Triangle> triangles = ShapeUtilities.getTriangles(polygon);
        ArrayList<LineString> lines = ShapeUtilities.getEdges(geom);
        int numOfIndexesInTriangle = 3;
        int p = triangles.size() * numOfIndexesInTriangle;
        int indexSize = 2 * p + lines.size() * 6;
        float[] vertexArray = new float[indexSize * 3];
        float[] normalArray = new float[indexSize * 3];
        float[] uvArray = new float[indexSize * 2];
        short[] indexArray = new short[indexSize];
        Vector3f neg = Vector3f.UNIT_Y.mult(-1.0f);
        int index = 0;
        for (Triangle t : triangles) {
            Vector3f t1 = t.get1();
            Vector3f t2 = t.get2();
            Vector3f t3 = t.get3();
            ShapeUtilities.addTriangle(new Triangle(t1.add(0.0f, height, 0.0f), t2.add(0.0f, height, 0.0f), t3.add(0.0f, height, 0.0f)), Vector3f.UNIT_Y, index, vertexArray, normalArray, uvArray, indexArray);
            ShapeUtilities.addTriangle(new Triangle(t3, t2, t1), neg, index += 3, vertexArray, normalArray, uvArray, indexArray);
            index += 3;
        }
        for (int i = 0; i < lines.size(); ++i) {
            Point start = lines.get(i).getStartPoint();
            Point end = lines.get(i).getEndPoint();
            Vector3f vStart = new Vector3f((float)start.getX(), 0.0f, (float)start.getY());
            Vector3f vStart1 = vStart.add(0.0f, height, 0.0f);
            Vector3f vEnd = new Vector3f((float)end.getX(), 0.0f, (float)end.getY());
            Vector3f vEnd1 = vEnd.add(0.0f, height, 0.0f);
            Triangle t = new Triangle(vStart1, vStart, vEnd1);
            t.calculateNormal();
            ShapeUtilities.addTriangle(t, t.getNormal(), index, vertexArray, normalArray, uvArray, indexArray);
            t = new Triangle(vStart, vEnd, vEnd1);
            t.calculateNormal();
            ShapeUtilities.addTriangle(t, t.getNormal(), index += 3, vertexArray, normalArray, uvArray, indexArray);
            index += 3;
        }
        return new MeshData(vertexArray, normalArray, uvArray, indexArray).removeDuplicateData();
    }

    public static com.vividsolutions.jts.geom.Geometry createGeometry(BufferedImage image) {
        ArrayList<Point> points = new ArrayList<Point>(16384);
        image = ImageUtilities.rotateImage(image, (float)Math.PI);
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                boolean black;
                Color color = ImageUtilities.getColor(image, i, j, true);
                boolean opaque = color.getAlpha() > 60;
                boolean bl = black = (color.getRed() + color.getGreen() + color.getBlue()) / 3 < 60;
                if (!opaque || !black) continue;
                points.add(ShapeUtilities.createPoint(new Coordinate((double)i, (double)j)));
            }
        }
        GeometryCollection g = new GeometryCollection((com.vividsolutions.jts.geom.Geometry[])points.toArray(new Point[points.size()]), GEOMETRY_FACTORY);
        return g;
    }

    public static Point createPoint(Coordinate c) {
        return GEOMETRY_FACTORY.createPoint(c);
    }

    public static com.vividsolutions.jts.geom.Geometry combineComponents(com.vividsolutions.jts.geom.Geometry g, double pointSize) {
        return ShapeUtilities.componentBuffers(g, pointSize).union();
    }

    public static com.vividsolutions.jts.geom.Geometry simplify(com.vividsolutions.jts.geom.Geometry g, float amount) {
        return DouglasPeuckerSimplifier.simplify((com.vividsolutions.jts.geom.Geometry)g, (double)amount);
    }

    public static com.vividsolutions.jts.geom.Geometry convertToConvexHull(com.vividsolutions.jts.geom.Geometry g) {
        return g.convexHull();
    }

    public static com.vividsolutions.jts.geom.Geometry convertToOctagonal(com.vividsolutions.jts.geom.Geometry g) {
        OctagonalEnvelope octEnv = new OctagonalEnvelope(g);
        return octEnv.toGeometry(g.getFactory());
    }

    public static com.vividsolutions.jts.geom.Geometry intersection(com.vividsolutions.jts.geom.Geometry a, com.vividsolutions.jts.geom.Geometry b) {
        return a.intersection(b);
    }

    public static com.vividsolutions.jts.geom.Geometry union(com.vividsolutions.jts.geom.Geometry a, com.vividsolutions.jts.geom.Geometry b) {
        return a.union(b);
    }

    public static com.vividsolutions.jts.geom.Geometry symDifference(com.vividsolutions.jts.geom.Geometry a, com.vividsolutions.jts.geom.Geometry b) {
        return a.symDifference(b);
    }

    public static com.vividsolutions.jts.geom.Geometry difference(com.vividsolutions.jts.geom.Geometry a, com.vividsolutions.jts.geom.Geometry b) {
        return a.difference(b);
    }

    public static com.vividsolutions.jts.geom.Geometry triangulate(com.vividsolutions.jts.geom.Geometry geom) {
        DelaunayTriangulationBuilder builder = new DelaunayTriangulationBuilder();
        builder.setSites(geom);
        builder.setTolerance(0.0);
        com.vividsolutions.jts.geom.Geometry tris = builder.getTriangles(geom.getFactory());
        return ShapeUtilities.intersection(tris, geom);
    }

    public static Coordinate getCenter(com.vividsolutions.jts.geom.Geometry g) {
        return g.getEnvelopeInternal().centre();
    }

    public static com.vividsolutions.jts.geom.Geometry translateCentreToOrigin(com.vividsolutions.jts.geom.Geometry g) {
        Coordinate centre = ShapeUtilities.getCenter(g);
        AffineTransformation trans = AffineTransformation.translationInstance((double)(-centre.x), (double)(-centre.y));
        return trans.transform(g);
    }

    public static com.vividsolutions.jts.geom.Geometry scale(com.vividsolutions.jts.geom.Geometry g, double scaleX, double scaleY) {
        AffineTransformation trans = AffineTransformation.scaleInstance((double)scaleX, (double)scaleY);
        return trans.transform(g);
    }

    public static com.vividsolutions.jts.geom.Geometry reflectInX(com.vividsolutions.jts.geom.Geometry g) {
        Coordinate centre = ShapeUtilities.getCenter(g);
        AffineTransformation trans = AffineTransformation.scaleInstance((double)1.0, (double)-1.0, (double)centre.x, (double)centre.y);
        return trans.transform(g);
    }

    public static com.vividsolutions.jts.geom.Geometry reflectInY(com.vividsolutions.jts.geom.Geometry g) {
        Coordinate centre = ShapeUtilities.getCenter(g);
        AffineTransformation trans = AffineTransformation.scaleInstance((double)-1.0, (double)1.0, (double)centre.x, (double)centre.y);
        return trans.transform(g);
    }

    public static ArrayList<Triangle> getTriangles(com.vividsolutions.jts.geom.Geometry geom) {
        ArrayList<Triangle> triangles = new ArrayList<Triangle>();
        LinkedList<com.vividsolutions.jts.geom.Geometry> gc = new LinkedList<com.vividsolutions.jts.geom.Geometry>();
        gc.add(geom);
        while (!gc.isEmpty()) {
            com.vividsolutions.jts.geom.Geometry g = (com.vividsolutions.jts.geom.Geometry)gc.pop();
            if (g instanceof GeometryCollection) {
                GeometryCollection collection = (GeometryCollection)g;
                for (int i = 0; i < collection.getNumGeometries(); ++i) {
                    gc.add(collection.getGeometryN(i));
                }
                continue;
            }
            if (!(g instanceof Polygon)) continue;
            Polygon p = (Polygon)g;
            Coordinate[] cords = p.getCoordinates();
            triangles.add(new Triangle(ShapeUtilities.toVector3f(cords[0]), ShapeUtilities.toVector3f(cords[1]), ShapeUtilities.toVector3f(cords[2])));
            if (g.getNumPoints() == 5) {
                triangles.add(new Triangle(ShapeUtilities.toVector3f(cords[2]), ShapeUtilities.toVector3f(cords[3]), ShapeUtilities.toVector3f(cords[0])));
                if (!cords[4].equals2D(cords[0])) {
                    triangles.add(new Triangle(ShapeUtilities.toVector3f(cords[3]), ShapeUtilities.toVector3f(cords[4]), ShapeUtilities.toVector3f(cords[0])));
                }
            }
            if (g.getNumPoints() != 6) continue;
            triangles.add(new Triangle(ShapeUtilities.toVector3f(cords[2]), ShapeUtilities.toVector3f(cords[3]), ShapeUtilities.toVector3f(cords[4])));
            triangles.add(new Triangle(ShapeUtilities.toVector3f(cords[4]), ShapeUtilities.toVector3f(cords[5]), ShapeUtilities.toVector3f(cords[2])));
            if (cords[5].equals2D(cords[0])) continue;
            triangles.add(new Triangle(ShapeUtilities.toVector3f(cords[5]), ShapeUtilities.toVector3f(cords[0]), ShapeUtilities.toVector3f(cords[2])));
        }
        return triangles;
    }

    public static Vector3f toVector3f(Coordinate c) {
        return new Vector3f((float)c.x, 0.0f, (float)c.y);
    }

    public static Vector3f toVector3f(Point c) {
        return ShapeUtilities.toVector3f(c.getCoordinate());
    }

    public static ArrayList<LineString> getEdges(com.vividsolutions.jts.geom.Geometry geom) {
        List lines = LinearComponentExtracter.getLines((com.vividsolutions.jts.geom.Geometry)geom);
        ArrayList<LineString> segments = new ArrayList<LineString>(lines.size());
        for (LineString line : lines) {
            for (int i = 1; i < line.getNumPoints(); ++i) {
                LineString seg = GEOMETRY_FACTORY.createLineString(new Coordinate[]{line.getCoordinateN(i - 1), line.getCoordinateN(i)});
                segments.add(seg);
            }
        }
        return segments;
    }

    private static GeometryCollection componentBuffers(com.vividsolutions.jts.geom.Geometry g, double distance) {
        ArrayList<com.vividsolutions.jts.geom.Geometry> bufs = new ArrayList<com.vividsolutions.jts.geom.Geometry>();
        GeometryCollectionIterator it = new GeometryCollectionIterator(g);
        while (it.hasNext()) {
            com.vividsolutions.jts.geom.Geometry comp = (com.vividsolutions.jts.geom.Geometry)it.next();
            if (comp instanceof GeometryCollection) continue;
            bufs.add(comp.buffer(distance));
        }
        return GEOMETRY_FACTORY.createGeometryCollection(GeometryFactory.toGeometryArray(bufs));
    }

    private static void addTriangle(Triangle t, Vector3f normal, int index, float[] vertexArray, float[] normalArray, float[] uvArray, short[] indexArray) {
        ShapeUtilities.addCord(t.get1(), normal, index, vertexArray, normalArray, uvArray, indexArray);
        ShapeUtilities.addCord(t.get2(), normal, index + 1, vertexArray, normalArray, uvArray, indexArray);
        ShapeUtilities.addCord(t.get3(), normal, index + 2, vertexArray, normalArray, uvArray, indexArray);
    }

    private static void addCord(Vector3f triangle, Vector3f normal, int index, float[] vertexArray, float[] normalArray, float[] uvArray, short[] indexArray) {
        indexArray[index] = (short)index;
        Utilities.setInArray(triangle, vertexArray, index);
        Utilities.setInArray(normal, normalArray, index);
        Utilities.setInArray(new Vector2f(triangle.getX(), triangle.getZ()), uvArray, index);
    }

    public static void main(String[] args) {
        SimpleApplication scene = new SimpleApplication(){

            public void simpleInitApp() {
                ShapeUtilities.testMain(this);
            }
        };
        scene.start();
    }
}

