/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.lidar;

import com.jme3.material.Material;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.profile.AppProfiler;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import java.util.concurrent.Callable;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarMaterial;

public class LidarSceneViewPort
implements SceneProcessor {
    private static final int TEXTURE_TO_SCAN_INTERPOLATION_FACTOR = 4;
    private final Camera cam;
    private final Texture2D sceneTexture;
    private final LidarMaterial lidarMaterial;
    private JMERenderer jmeRenderer;
    private RenderManager renderManager;
    private ViewPort viewPort;
    Stopwatch timer = new Stopwatch().start();
    long frameNum = 0L;

    public LidarSceneViewPort(JMERenderer jmeRenderer, LidarMaterial lidarMaterial, int numberOfCameras, int scansPerSweep, int scanHeight, float fieldOfView, float minRange, float maxRange) {
        this.jmeRenderer = jmeRenderer;
        int cameraScansPerSweep = scansPerSweep / numberOfCameras;
        this.lidarMaterial = lidarMaterial;
        this.cam = new Camera(cameraScansPerSweep * 4, scanHeight);
        this.viewPort = jmeRenderer.getRenderManager().createMainView("LidarViewPort", this.cam);
        this.setupCamera(numberOfCameras, cameraScansPerSweep, scanHeight, fieldOfView, minRange, maxRange);
        this.sceneTexture = new Texture2D(cameraScansPerSweep * 4, scanHeight, Image.Format.RGB32F);
        this.sceneTexture.setMagFilter(Texture.MagFilter.Nearest);
        this.sceneTexture.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        FrameBuffer sceneFrameBuffer = new FrameBuffer(cameraScansPerSweep * 4, scanHeight, 1);
        sceneFrameBuffer.setDepthBuffer(Image.Format.Depth24);
        sceneFrameBuffer.setColorTexture(this.sceneTexture);
        this.viewPort.setClearFlags(true, true, true);
        this.viewPort.setOutputFrameBuffer(sceneFrameBuffer);
        this.viewPort.addProcessor((SceneProcessor)this);
    }

    public void updateScene(final Node sceneToUse) {
        this.jmeRenderer.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                LidarSceneViewPort.this.viewPort.clearScenes();
                LidarSceneViewPort.this.viewPort.attachScene((Spatial)sceneToUse);
                return null;
            }
        });
    }

    public void setRotation(Quaternion rotation) {
        this.cam.setRotation(rotation);
    }

    public void setLocation(Vector3f location) {
        this.cam.setLocation(location);
    }

    private void setupCamera(int numberOfCameras, int cameraScansPerSweep, int scanHeight, float fieldOfView, float minRange, float maxRange) {
        float cameraFoV = fieldOfView / (float)numberOfCameras;
        float frustrumX = FastMath.tan((float)(cameraFoV / 2.0f)) * minRange;
        float frustrumY = frustrumX / (float)cameraScansPerSweep * (float)scanHeight;
        this.cam.setParallelProjection(false);
        this.cam.setFrustum(minRange, maxRange, -frustrumX, frustrumX, frustrumY, -frustrumY);
    }

    public void initialize(RenderManager renderManager, ViewPort vp) {
        this.renderManager = renderManager;
    }

    public void reshape(ViewPort vp, int w, int h) {
        throw new RuntimeException("Cannot resize LIDAR!");
    }

    public boolean isInitialized() {
        return this.renderManager != null;
    }

    public void preFrame(float tpf) {
        if (JMERenderer.USE_GPU_LIDAR_PARALLEL_SCENE && !this.viewPort.getScenes().isEmpty()) {
            this.timer.resetLap();
            this.jmeRenderer.syncSubsceneToMain((Node)this.viewPort.getScenes().get(0));
            this.timer.lap();
        }
        this.renderManager.setForcedMaterial((Material)this.lidarMaterial);
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        this.renderManager.setForcedMaterial(null);
    }

    public void cleanup() {
    }

    public Texture getTexture2D() {
        return this.sceneTexture;
    }

    public void setProfiler(AppProfiler profiler) {
    }
}

