/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.jMonkeyEngineToolkit.CameraAdapter;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraController;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEGeometryUtils;

public class JMECamera
extends Camera
implements CameraAdapter {
    public static final com.jme3.math.Quaternion convertLookingUpToLookingForward = new com.jme3.math.Quaternion();
    private static final com.jme3.math.Quaternion convertLookingForwardToLookingUp;
    private final QuaternionBasics cameraRotation = new Quaternion();
    private final Vector3D cameraPosition = new Vector3D();
    private CameraController cameraController;
    private final RigidBodyTransform cameraTransform = new RigidBodyTransform();
    private float horizontalFoVInRadians = 0.7853982f;
    private float clipDistanceNear = 0.15f;
    private float clipDistanceFar = 1000.0f;
    private boolean frustrumNeedsUpdating = false;
    private int previousWindowWidth = 0;
    private int previousWindowHeight = 0;
    private boolean alreadyClosing = false;

    public JMECamera(Camera camera) {
        super(camera.getWidth(), camera.getHeight());
        this.copyFrom(camera);
        this.updateFrustrum();
    }

    public void setHorizontalFoVInRadians(float fovHorizontalInRadians) {
        if (this.horizontalFoVInRadians != fovHorizontalInRadians) {
            this.horizontalFoVInRadians = fovHorizontalInRadians;
            this.frustrumNeedsUpdating = true;
        }
    }

    public void setClipDistanceNear(float clipDistanceNear) {
        if (this.clipDistanceNear != clipDistanceNear) {
            this.clipDistanceNear = clipDistanceNear;
            this.frustrumNeedsUpdating = true;
        }
    }

    public void setClipDistanceFar(float clipDistanceFar) {
        if (this.clipDistanceFar != clipDistanceFar) {
            this.clipDistanceFar = clipDistanceFar;
            this.frustrumNeedsUpdating = true;
        }
    }

    @Deprecated
    public void setFrustumPerspective(float fovY, float aspect, float near, float far) {
        throw new RuntimeException("Use setFovHorizontalInRadians, setClipDistanceNear and setClipDistanceFar.");
    }

    private void updateFrustrum() {
        int windowWidth = this.getWidth();
        int windowHeight = this.getHeight();
        if (windowWidth != this.previousWindowWidth || windowHeight != this.previousWindowHeight || this.frustrumNeedsUpdating) {
            float aspect = (float)this.getInternalHeight() / (float)this.getInternalWidth();
            float w = FastMath.tan((float)(this.horizontalFoVInRadians * 0.5f)) * this.clipDistanceNear;
            float h = w * aspect;
            this.frustumLeft = -w;
            this.frustumRight = w;
            this.frustumBottom = -h;
            this.frustumTop = h;
            this.frustumNear = this.clipDistanceNear;
            this.frustumFar = this.clipDistanceFar;
            this.onFrustumChange();
            this.previousWindowWidth = windowWidth;
            this.previousWindowHeight = windowHeight;
            this.frustrumNeedsUpdating = false;
        }
    }

    public float getNearClip() {
        return this.clipDistanceNear;
    }

    public float getFarClip() {
        return this.clipDistanceFar;
    }

    @Override
    public float getHorizontalFovInRadians() {
        return this.horizontalFoVInRadians;
    }

    public CameraController getController() {
        return this.cameraController;
    }

    public void setLocationInZUpCoordinates(Tuple3DReadOnly cameraPosition) {
        this.setLocationInZUpCoordinates(JMEDataTypeUtils.vecMathTuple3dToJMEVector3f(cameraPosition));
    }

    public void setLocationInZUpCoordinates(Vector3f location) {
        Vector3f tempVector = new Vector3f(location);
        JMEGeometryUtils.transformFromZupToJMECoordinates(tempVector);
        this.setLocation(tempVector);
    }

    public void setRotationInZUpcoordinates(QuaternionReadOnly rotation) {
        this.setRotationInZUpcoordinates(JMEDataTypeUtils.vecMathQuat4dToJMEQuaternion(rotation));
    }

    public void setRotationInZUpcoordinates(com.jme3.math.Quaternion rotation) {
        com.jme3.math.Quaternion tempQuat = new com.jme3.math.Quaternion(rotation);
        tempQuat.multLocal(convertLookingUpToLookingForward);
        JMEGeometryUtils.transformFromZupToJMECoordinates(tempQuat);
        this.setRotation(tempQuat);
    }

    @Deprecated
    public void setLocation(Vector3f location) {
        super.setLocation(location);
    }

    @Deprecated
    public void setRotation(com.jme3.math.Quaternion rotation) {
        super.setRotation(rotation);
    }

    public void updateCamera() {
        if (this.cameraController != null) {
            this.cameraController.computeTransform(this.cameraTransform);
            this.cameraTransform.get((Orientation3DBasics)this.cameraRotation, (Tuple3DBasics)this.cameraPosition);
            this.setLocationInZUpCoordinates((Tuple3DReadOnly)this.cameraPosition);
            this.setRotationInZUpcoordinates((QuaternionReadOnly)this.cameraRotation);
            this.setHorizontalFoVInRadians((float)this.cameraController.getHorizontalFieldOfViewInRadians());
            this.setClipDistanceNear((float)this.cameraController.getClipNear());
            this.setClipDistanceFar((float)this.cameraController.getClipFar());
        }
        this.updateFrustrum();
    }

    public void setCameraController(CameraController cameraController) {
        this.cameraController = cameraController;
    }

    public QuaternionBasics getCameraRotation() {
        com.jme3.math.Quaternion quat = new com.jme3.math.Quaternion(this.getRotation());
        JMEGeometryUtils.transformFromJMECoordinatesToZup(quat);
        quat.multLocal(convertLookingForwardToLookingUp);
        return new Quaternion((double)quat.getX(), (double)quat.getY(), (double)quat.getZ(), (double)quat.getW());
    }

    public Point3D getCameraPosition() {
        Vector3f position = new Vector3f(this.getLocation());
        JMEGeometryUtils.transformFromJMECoordinatesToZup(position);
        return new Point3D((double)position.getX(), (double)position.getY(), (double)position.getZ());
    }

    public void resize(int width, int height, boolean fixAspect) {
        super.resize(width, height, false);
        if (fixAspect) {
            this.frustumRight = this.frustumTop * ((float)this.getInternalWidth() / (float)this.getInternalHeight());
            this.frustumLeft = -this.frustumRight;
            this.onFrustumChange();
        }
    }

    public int getInternalWidth() {
        return (int)((float)this.width * (this.viewPortRight - this.viewPortLeft));
    }

    public int getInternalHeight() {
        return (int)((float)this.height * (this.viewPortTop - this.viewPortBottom));
    }

    public void closeAndDispose() {
        if (this.alreadyClosing) {
            return;
        }
        this.alreadyClosing = true;
        if (this.cameraController != null) {
            this.cameraController.closeAndDispose();
            this.cameraController = null;
        }
    }

    static {
        convertLookingUpToLookingForward.fromRotationMatrix(0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        convertLookingForwardToLookingUp = convertLookingUpToLookingForward.inverse();
    }
}

