/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.util;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion32;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;

public class JMEGeometryUtils {
    private static final Quaternion zUpToYup = new Quaternion();
    private static final Quaternion yUpToZup = new Quaternion();
    private static final RigidBodyTransform zUpToYupTransform;
    private static final RigidBodyTransform yUpToZupTransform;

    public static Quaternion getRotationFromJMEToZupCoordinates() {
        return new Quaternion(zUpToYup);
    }

    public static Quaternion getRotationFromZupToJMECoordinates() {
        return new Quaternion(yUpToZup);
    }

    public static void transformFromZupToJMECoordinates(Vector3f point) {
        zUpToYup.multLocal(point);
    }

    public static void transformFromZupToJMECoordinates(Quaternion rotation) {
        zUpToYup.mult(rotation, rotation);
    }

    public static void transformFromJMECoordinatesToZup(Vector3f point) {
        yUpToZup.multLocal(point);
    }

    public static void transformFromJMECoordinatesToZup(Quaternion rotation) {
        yUpToZup.mult(rotation, rotation);
    }

    public static Ray transformRayFromJMECoordinateToZup(Ray jmeRay) {
        Vector3f origin = new Vector3f(jmeRay.getOrigin());
        Vector3f direction = new Vector3f(jmeRay.getDirection());
        JMEGeometryUtils.transformFromJMECoordinatesToZup(origin);
        JMEGeometryUtils.transformFromJMECoordinatesToZup(direction);
        return new Ray(origin, direction);
    }

    public static Ray transformRayFromZupToJMECoordinate(Ray zupRay) {
        Vector3f origin = new Vector3f(zupRay.getOrigin());
        Vector3f direction = new Vector3f(zupRay.getDirection());
        JMEGeometryUtils.transformFromZupToJMECoordinates(origin);
        JMEGeometryUtils.transformFromZupToJMECoordinates(direction);
        return new Ray(origin, direction);
    }

    public static RigidBodyTransform transformFromJMECoordinatesToZup(Transform transform) {
        RigidBodyTransform modifiedTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)yUpToZupTransform);
        RigidBodyTransform temp = JMEGeometryUtils.jmeTransformToTransform3D(transform);
        modifiedTransform.multiply((RigidBodyTransformReadOnly)temp);
        return modifiedTransform;
    }

    public static Transform transformFromZupToJMECoordinates(RigidBodyTransform transform) {
        RigidBodyTransform modifiedTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)zUpToYupTransform);
        modifiedTransform.multiply((RigidBodyTransformReadOnly)transform);
        return JMEGeometryUtils.j3dTransform3DToJMETransform(modifiedTransform);
    }

    public static void transform(Transform matrixToModify, Transform transformToApply) {
        matrixToModify.combineWithParent(transformToApply);
    }

    public static Transform multiply(Transform matrix, Transform transformToApply) {
        Transform temp = new Transform();
        temp.set(matrix);
        temp.combineWithParent(transformToApply);
        return temp;
    }

    public static void multiply(Transform matrix, Transform transformToApply, Transform result) {
        result.set(matrix);
        result.combineWithParent(transformToApply);
    }

    private static Transform j3dTransform3DToJMETransform(RigidBodyTransform transform3D) {
        Quaternion32 quat = new Quaternion32();
        Vector3D32 vector = new Vector3D32();
        transform3D.get((Orientation3DBasics)quat, (Tuple3DBasics)vector);
        Vector3f jmeVector = new Vector3f(vector.getX32(), vector.getY32(), vector.getZ32());
        Quaternion jmeQuat = new Quaternion(quat.getX32(), quat.getY32(), quat.getZ32(), quat.getS32());
        Transform ret = new Transform(jmeVector, jmeQuat, new Vector3f(1.0f, 1.0f, 1.0f));
        return ret;
    }

    private static RigidBodyTransform jmeTransformToTransform3D(Transform jmeTransform) {
        Quaternion jmeQuat = jmeTransform.getRotation();
        Vector3f jmeVect = jmeTransform.getTranslation();
        us.ihmc.euclid.tuple4D.Quaternion quat = new us.ihmc.euclid.tuple4D.Quaternion((double)jmeQuat.getX(), (double)jmeQuat.getY(), (double)jmeQuat.getZ(), (double)jmeQuat.getW());
        Vector3D vect = new Vector3D((double)jmeVect.getX(), (double)jmeVect.getY(), (double)jmeVect.getZ());
        RigidBodyTransform ret = new RigidBodyTransform((Orientation3DReadOnly)quat, (Tuple3DReadOnly)vect);
        return ret;
    }

    public static Transform getInverse(Transform transform) {
        RigidBodyTransform transform3D = JMEGeometryUtils.jmeTransformToTransform3D(transform);
        transform3D.invert();
        Transform ret = JMEGeometryUtils.j3dTransform3DToJMETransform(transform3D);
        return ret;
    }

    public static Transform invert(Transform transform) {
        RigidBodyTransform transform3D = JMEGeometryUtils.jmeTransformToTransform3D(transform);
        transform3D.invert();
        return transform.set(JMEGeometryUtils.j3dTransform3DToJMETransform(transform3D));
    }

    public static boolean epsilonEquals(Transform a, Transform b, double epsilon) {
        RigidBodyTransform A = JMEGeometryUtils.jmeTransformToTransform3D(a);
        RigidBodyTransform B = JMEGeometryUtils.jmeTransformToTransform3D(b);
        return A.epsilonEquals((EuclidGeometry)B, epsilon);
    }

    public static JMEGraphics3DNode addNodesRecursively(Graphics3DNode graphics3dNode, Node parentNode, SimpleApplication simpleApplication) {
        JMEGraphics3DNode jmeNode = new JMEGraphics3DNode(graphics3dNode, simpleApplication.getAssetManager(), (Application)simpleApplication, null);
        jmeNode.update();
        Graphics3DNodeType nodeType = graphics3dNode.getNodeType();
        jmeNode.setType(nodeType);
        parentNode.attachChild((Spatial)jmeNode);
        for (Graphics3DNode child : graphics3dNode.getChildrenNodes()) {
            JMEGeometryUtils.addNodesRecursively(child, jmeNode, simpleApplication);
        }
        return jmeNode;
    }

    public static void linkNodeAToNodeB(Node a, Node b) {
        RigidBodyTransform aTransform = JMEDataTypeUtils.jmeTransformToTransform3D(a.getWorldTransform());
        RigidBodyTransform bTransform = JMEDataTypeUtils.jmeTransformToTransform3D(b.getWorldTransform());
        ReferenceFrame frameA = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"nodeA", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)aTransform);
        ReferenceFrame frameB = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"nodeB", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)bTransform);
        RigidBodyTransform aToBTransform = frameA.getTransformToDesiredFrame(frameB);
        Transform aTransformJME = JMEDataTypeUtils.j3dTransform3DToJMETransform((RigidBodyTransformReadOnly)aToBTransform);
        a.removeFromParent();
        a.setLocalTransform(aTransformJME);
        b.attachChild((Spatial)a);
    }

    public static void main(String[] args) {
    }

    static {
        Matrix3f matrix3f = new Matrix3f(0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f);
        zUpToYup.fromRotationMatrix(matrix3f);
        yUpToZup.set(zUpToYup.inverse());
        zUpToYupTransform = new RigidBodyTransform((Orientation3DReadOnly)JMEDataTypeUtils.jMEQuaternionToVecMathQuat4d(zUpToYup), (Tuple3DReadOnly)new Vector3D());
        yUpToZupTransform = new RigidBodyTransform((Orientation3DReadOnly)JMEDataTypeUtils.jMEQuaternionToVecMathQuat4d(yUpToZup), (Tuple3DReadOnly)new Vector3D());
    }
}

