/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.stlLoader;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.util.List;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.NormalCalculator;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.STLReader;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.STLReaderFactory;
import us.ihmc.jMonkeyEngineToolkit.stlLoader.Triangle;

public class STLLoader
implements AssetLoader {
    public Object load(AssetInfo assetInfo) throws IOException {
        STLReader reader = STLReaderFactory.create(assetInfo);
        List<Triangle> triangles = reader.getTriangles();
        Mesh mesh = new Mesh();
        Vector3f[] vertices = new Vector3f[triangles.size() * 3];
        Vector3f[] normals = new Vector3f[triangles.size() * 3];
        int[] indices = new int[triangles.size() * 3];
        for (int i = 0; i < triangles.size(); ++i) {
            Triangle triangle = triangles.get(i);
            float[] normal = triangle.getNormal();
            if (NormalCalculator.isZeroNormal(normal, 1.0E-5f)) {
                NormalCalculator.calculateNormal(normal, triangle.getVertices());
            }
            float ni = normal[0];
            float nj = normal[1];
            float nk = normal[2];
            Vector3f normal3f = new Vector3f(ni, nj, nk);
            for (int v = 0; v < 3; ++v) {
                int index = i * 3 + v;
                float[] vertex = triangle.getVertex(v);
                float vx = vertex[0];
                float vy = vertex[1];
                float vz = vertex[2];
                vertices[index] = new Vector3f(vx, vy, vz);
                indices[index] = index;
                normals[index] = normal3f;
            }
        }
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])vertices));
        mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer((Vector3f[])normals));
        mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])indices));
        mesh.updateBound();
        Geometry geom = new Geometry(reader.getName(), mesh);
        return geom;
    }
}

