/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import java.util.ArrayList;
import us.ihmc.jMonkeyEngineToolkit.ContextManager;
import us.ihmc.jMonkeyEngineToolkit.jme.InputMapSetter;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEViewportAdapter;

public abstract class JMEContextManager
implements ContextManager {
    private JMERenderer jmeRenderer;
    private boolean enableSwitching = true;
    private ArrayList<InputMapSetter> inputMapSetters = new ArrayList();
    protected ArrayList<JMEViewportAdapter> viewports = new ArrayList();
    private JMEViewportAdapter currentViewport;

    public JMEContextManager(JMERenderer jmeRenderer) {
        this.jmeRenderer = jmeRenderer;
    }

    public void setSwitchingEnabled(boolean enable) {
        this.enableSwitching = enable;
    }

    public void registerInputMapSetter(InputMapSetter inputMapSetter) {
        this.inputMapSetters.add(inputMapSetter);
    }

    @Override
    public JMEViewportAdapter getCurrentViewport() {
        return this.currentViewport;
    }

    public boolean isSwitchingEnabled() {
        return this.enableSwitching;
    }

    public void addJMEViewportAdapter(JMEViewportAdapter jmeViewportAdapter) {
        this.viewports.add(jmeViewportAdapter);
        this.addJMEViewportAdapterToContext(jmeViewportAdapter);
    }

    public abstract void initialize();

    protected abstract void addJMEViewportAdapterToContext(JMEViewportAdapter var1);

    public abstract void focusOnCurrentWindow();

    protected void setCurrentViewport(JMEViewportAdapter currentViewport) {
        this.currentViewport = currentViewport;
        this.jmeRenderer.getInputManager().clearMappings();
        this.getCurrentViewport().setDefaultInputMappings();
        for (InputMapSetter inputMapSetter : this.inputMapSetters) {
            inputMapSetter.setDefaultInputMappings();
        }
    }

    protected void resetViewport(JMEViewportAdapter viewport) {
        if (viewport != null) {
            viewport.reset();
        }
        for (InputMapSetter inputMapSetter : this.inputMapSetters) {
            inputMapSetter.reset();
        }
    }

    public void closeAndDispose() {
        this.jmeRenderer = null;
        if (this.inputMapSetters != null) {
            this.inputMapSetters.clear();
            this.inputMapSetters = null;
        }
        if (this.viewports != null) {
            this.viewports.clear();
            this.viewports = null;
        }
        this.currentViewport = null;
    }
}

