/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.examples;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.util.concurrent.Callable;
import javax.swing.JFrame;
import javax.swing.JPanel;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.AffineTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.jMonkeyEngineToolkit.camera.ClassicCameraController;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEViewportAdapter;
import us.ihmc.jMonkeyEngineToolkit.utils.GraphicsDemoTools;

public class TransformRayDemo {
    RigidBodyTransform tInit = new RigidBodyTransform();
    RigidBodyTransform tAct = new RigidBodyTransform();
    RigidBodyTransform incrementalRotation = new RigidBodyTransform();

    public static void main(String[] args) {
        new TransformRayDemo();
    }

    public TransformRayDemo() {
        Graphics3DObject graphic = new Graphics3DObject();
        this.incrementalRotation.setRotationRollAndZeroTranslation(-0.19634954084936207);
        graphic.addCylinder(5.0, 0.2, YoAppearance.Red());
        final Graphics3DNode rayNode = new Graphics3DNode("laserRay", Graphics3DNodeType.VISUALIZATION);
        this.tInit.setRotationPitchAndZeroTranslation(0.7853981633974483);
        rayNode.setTransform((RigidBodyTransformReadOnly)this.tInit);
        rayNode.setGraphicsObject(graphic);
        final JMERenderer renderer = new JMERenderer(JMERenderer.RenderType.AWTPANELS);
        renderer.setupSky();
        renderer.addRootNode(rayNode);
        GraphicsDemoTools.PanBackAndForthTrackingAndDollyPositionHolder cameraTrackAndDollyVariablesHolder = new GraphicsDemoTools.PanBackAndForthTrackingAndDollyPositionHolder(20.0, 20.0, 20.0);
        JMEViewportAdapter viewportAdapter = (JMEViewportAdapter)renderer.createNewViewport(null, false, false);
        ClassicCameraController classicCameraController = ClassicCameraController.createClassicCameraControllerAndAddListeners(viewportAdapter, cameraTrackAndDollyVariablesHolder, renderer);
        viewportAdapter.setCameraController(classicCameraController);
        Canvas canvas = viewportAdapter.getCanvas();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", canvas);
        panel.setPreferredSize(new Dimension(1800, 1080));
        JFrame jFrame = new JFrame("Example One");
        jFrame.setDefaultCloseOperation(3);
        Container contentPane = jFrame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", panel);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    renderer.enqueue(new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            rayNode.setTransform(TransformRayDemo.this.generateTransform(rayNode.getTransform()));
                            return null;
                        }
                    });
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public AffineTransform generateTransform(AffineTransform init) {
        AffineTransform rotated = new AffineTransform((AffineTransformReadOnly)init);
        rotated.multiply((RigidBodyTransformReadOnly)this.incrementalRotation);
        return rotated;
    }
}

