/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.asset.AssetManager;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.system.JmeSystem;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERayCollisionAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.util.SimpleLRUCache;

public class JMEGeneratedHeightMap
implements HeightMap {
    private final boolean DEBUG = false;
    private static final int cacheSize = 1000000;
    private static final double measurementHeight = 100.0;
    private final int resolution;
    private final double elementTestSize;
    private final double xMin = 0.0;
    private final double xMax = 0.0;
    private final double yMin = 0.0;
    private final double yMax = 0.0;
    private final BoundingBox3D boundingBox = new BoundingBox3D(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private final JMERayCollisionAdapter jmeRayCollisionAdapter;
    private final Node rootNode = new Node("jmeGeneratedHeightMapRootNode");
    private final Node zUpNode = new Node("jmeGeneratedHeightMapZUpNode");
    private final AssetManager assetManager;
    private final SimpleLRUCache<Long, GroundPoint> cache = new SimpleLRUCache(1000000);
    private int lookups = 0;
    private int cacheHits = 0;
    private final ThreadLocal<Line3D> tempRay = new ThreadLocal<Line3D>(){

        @Override
        protected Line3D initialValue() {
            return new Line3D((Point3DReadOnly)new Point3D(), (Vector3DReadOnly)new Vector3D(0.0, 0.0, -1.0));
        }
    };

    public JMEGeneratedHeightMap(List<Graphics3DNode> nodes, int resolution) {
        Logger.getLogger("").setLevel(Level.WARNING);
        this.resolution = resolution;
        this.elementTestSize = 1.0 / (double)resolution + 1.0E-12;
        System.out.println("Generating heightmap tree");
        URL resource = AssetManager.class.getResource("Desktop.cfg");
        this.assetManager = JmeSystem.newAssetManager((URL)resource);
        JMERenderer.setupAssetManger(this.assetManager);
        this.rootNode.attachChild((Spatial)this.zUpNode);
        for (Graphics3DNode node : nodes) {
            this.addNodesRecursively(node, this.zUpNode);
        }
        this.rootNode.updateModelBound();
        this.rootNode.updateLogicalState(0.0f);
        this.rootNode.updateGeometricState();
        System.out.println("Done generating heightmap");
        this.jmeRayCollisionAdapter = new JMERayCollisionAdapter(this.rootNode);
    }

    public GroundPoint getGroundPoint(double x, double y, double z) {
        int yMil;
        ++this.lookups;
        int xMil = (int)Math.round(x * (double)this.resolution);
        long key = (((long)xMil & 0xFFFFFFFFL) << 32) + ((long)(yMil = (int)Math.round(y * (double)this.resolution)) & 0xFFFFFFFFL);
        GroundPoint point = (GroundPoint)this.cache.get(key);
        if (point != null) {
            if (Math.abs(x - point.x) > this.elementTestSize || Math.abs(y - point.y) > this.elementTestSize) {
                System.err.println("Wrong cache result returned for key: " + key + ", expected: (" + x + "," + y + "), returned: (" + point.getX() + "," + point.getY() + ")");
                Thread.dumpStack();
            }
            ++this.cacheHits;
            return point;
        }
        Line3D ray = this.tempRay.get();
        ray.getPoint().set(x, y, 100.0);
        this.jmeRayCollisionAdapter.setPickingGeometry((Line3DReadOnly)ray);
        Vector3D normal = new Vector3D();
        Point3D closestPoint = new Point3D();
        double distance = this.jmeRayCollisionAdapter.getPickDistance(this.rootNode, (Vector3DBasics)normal, (Point3DBasics)closestPoint);
        point = new GroundPoint(x, y, 100.0 - distance, normal, closestPoint);
        this.cache.put(key, point);
        return point;
    }

    public double heightAt(double x, double y, double z) {
        return this.getGroundPoint(x, y, z).getZ();
    }

    private JMEGraphics3DNode addNodesRecursively(Graphics3DNode graphics3dNode, Node parentNode) {
        JMEGraphics3DNode jmeNode = new JMEGraphics3DNode(graphics3dNode, this.assetManager, null, null);
        Graphics3DNodeType nodeType = graphics3dNode.getNodeType();
        jmeNode.setType(nodeType);
        parentNode.attachChild((Spatial)jmeNode);
        for (Graphics3DNode child : graphics3dNode.getChildrenNodes()) {
            this.addNodesRecursively(child, jmeNode);
        }
        return jmeNode;
    }

    public boolean isClose(double x, double y, double z) {
        return true;
    }

    public void closestIntersectionTo(double x, double y, double z, Point3D intersectionToPack) {
        GroundPoint groundPoint = this.getGroundPoint(x, y, z);
        intersectionToPack.set(groundPoint.getClosestIntersection());
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3D normalToPack) {
        GroundPoint groundPoint = this.getGroundPoint(x, y, z);
        normalToPack.set(groundPoint.getNormal());
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3D intersectionToPack, Vector3D normalToPack) {
        GroundPoint groundPoint = this.getGroundPoint(x, y, z);
        normalToPack.set(groundPoint.getNormal());
        intersectionToPack.set(groundPoint.getClosestIntersection());
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    private class GroundPoint {
        private final double x;
        private final double y;
        private final double z;
        private final Vector3D normal;
        private final Point3D closestIntersection;

        public GroundPoint(double x, double y, double z, Vector3D normal, Point3D closestIntersection) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.normal = normal;
            this.closestIntersection = closestIntersection;
        }

        public double getZ() {
            return this.z;
        }

        public Vector3D getNormal() {
            return this.normal;
        }

        public Point3D getClosestIntersection() {
            return this.closestIntersection;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

