/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.examples;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.color.MutableColor;
import us.ihmc.graphicsDescription.input.SelectedListener;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstruction;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.camera.ClassicCameraController;
import us.ihmc.jMonkeyEngineToolkit.camera.SimpleCameraTrackingAndDollyPositionHolder;
import us.ihmc.jMonkeyEngineToolkit.camera.ViewportAdapter;
import us.ihmc.tools.inputDevices.keyboard.ModifierKeyInterface;

public class Graphics3DAdapterExampleOne {
    public Boolean doExample(Graphics3DAdapter graphics3DAdapter) {
        Graphics3DNode teapotAndSphereNode = new Graphics3DNode("teaPot", Graphics3DNodeType.JOINT);
        Graphics3DObject teapotObject = new Graphics3DObject();
        teapotObject.setChangeable(true);
        Graphics3DInstruction teapotAppearanceHolder = teapotObject.addTeaPot(YoAppearance.Red());
        teapotAndSphereNode.setGraphicsObject(teapotObject);
        graphics3DAdapter.addRootNode(teapotAndSphereNode);
        BlinkRunnable blinker = new BlinkRunnable(teapotAppearanceHolder);
        Graphics3DNode box = new Graphics3DNode("box", Graphics3DNodeType.JOINT);
        Graphics3DObject boxGraphics = new Graphics3DObject();
        boxGraphics.addCube(1.0, 1.0, 1.0, YoAppearance.Green());
        box.setGraphicsObject(boxGraphics);
        graphics3DAdapter.addRootNode(box);
        PanBackAndForthTrackingAndDollyPositionHolder cameraTrackAndDollyVariablesHolder = new PanBackAndForthTrackingAndDollyPositionHolder(0.0, 2.0, 0.2);
        ViewportAdapter viewportAdapter = graphics3DAdapter.createNewViewport(null, false, false);
        ClassicCameraController classicCameraController = ClassicCameraController.createClassicCameraControllerAndAddListeners(viewportAdapter, cameraTrackAndDollyVariablesHolder, graphics3DAdapter);
        viewportAdapter.setCameraController(classicCameraController);
        Canvas canvas = viewportAdapter.getCanvas();
        this.createNewWindow(canvas);
        ViewportAdapter secondCamera = graphics3DAdapter.createNewViewport(null, false, false);
        ClassicCameraController secondController = ClassicCameraController.createClassicCameraControllerAndAddListeners(secondCamera, cameraTrackAndDollyVariablesHolder, graphics3DAdapter);
        secondCamera.setCameraController(secondController);
        this.createNewWindow(secondCamera.getCanvas());
        classicCameraController.setTracking(true, true, false, false);
        SelectedListener selectedListener = new SelectedListener(){

            public void selected(Graphics3DNode graphics3dNode, ModifierKeyInterface modifierKeyHolder, Point3DReadOnly location, Point3DReadOnly cameraLocation, QuaternionReadOnly cameraRotation) {
                if (graphics3dNode != null) {
                    System.out.println("Selected " + graphics3dNode.getName() + " @ location " + location);
                }
            }
        };
        graphics3DAdapter.addSelectedListener(selectedListener);
        box.addSelectedListener(selectedListener);
        RotateAndScaleNodeRunnable rotator = new RotateAndScaleNodeRunnable(teapotAndSphereNode);
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        runnables.add(rotator);
        runnables.add(blinker);
        for (int i = 0; i < 600; ++i) {
            for (Runnable runnable : runnables) {
                runnable.run();
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void createWindow(Canvas canvas1, Canvas canvas2) {
        JPanel panel = new JPanel(new FlowLayout());
        panel.add("Center", canvas1);
        panel.add("East", canvas2);
        canvas1.setPreferredSize(new Dimension(390, 600));
        canvas2.setPreferredSize(new Dimension(390, 600));
        JFrame jFrame = new JFrame("Example One");
        jFrame.setDefaultCloseOperation(3);
        Container contentPane = jFrame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(panel);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setSize(800, 600);
    }

    public void createNewWindow(Canvas canvas) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", canvas);
        JFrame jFrame = new JFrame("Example One");
        jFrame.setDefaultCloseOperation(3);
        Container contentPane = jFrame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", panel);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setSize(800, 600);
    }

    public static Graphics3DObject createSphereObject(double radius) {
        Graphics3DObject sphere = new Graphics3DObject();
        sphere.addSphere(radius, YoAppearance.Green());
        return sphere;
    }

    public static Graphics3DObject createCylinderObject(double radius) {
        Graphics3DObject cylinder = new Graphics3DObject();
        double height = 1.0;
        cylinder.addCylinder(height, radius, YoAppearance.Pink());
        return cylinder;
    }

    public static Graphics3DObject createCubeObject(double lengthWidthHeight) {
        Graphics3DObject cube = new Graphics3DObject();
        cube.addCube(lengthWidthHeight, lengthWidthHeight, lengthWidthHeight, YoAppearance.Red());
        return cube;
    }

    public static Graphics3DObject createRandomObject(Random random) {
        int selection = random.nextInt(3);
        switch (selection) {
            case 0: {
                return Graphics3DAdapterExampleOne.createCubeObject(random.nextDouble());
            }
            case 1: {
                return Graphics3DAdapterExampleOne.createSphereObject(random.nextDouble() * 0.5);
            }
            case 2: {
                return Graphics3DAdapterExampleOne.createCylinderObject(random.nextDouble() * 0.5);
            }
        }
        throw new RuntimeException("Should not get here");
    }

    private class PanBackAndForthTrackingAndDollyPositionHolder
    extends SimpleCameraTrackingAndDollyPositionHolder
    implements Runnable {
        private final long startTime = System.currentTimeMillis();
        private final double panXOffset;
        private final double panXAmplitude;
        private final double panXFrequency;

        public PanBackAndForthTrackingAndDollyPositionHolder(double panXOffset, double panXAmplitude, double panXFrequency) {
            this.panXOffset = panXOffset;
            this.panXAmplitude = panXAmplitude;
            this.panXFrequency = panXFrequency;
            Thread thread = new Thread(this);
            thread.start();
        }

        @Override
        public void run() {
            while (true) {
                long currentTime = System.currentTimeMillis();
                double time = (double)(currentTime - this.startTime) * 0.001;
                double cameraTrackingX = this.panXOffset + this.panXAmplitude * Math.sin(Math.PI * 2 * this.panXFrequency * time);
                this.setTrackingX(cameraTrackingX);
                ThreadTools.sleep((long)100L);
            }
        }
    }

    private class RotateAndScaleNodeRunnable
    implements Runnable {
        private final Graphics3DNode node;
        private double rotation = 0.0;
        private double scale = 1.0;
        private double translation = 0.0;
        private boolean scalingDown = true;

        public RotateAndScaleNodeRunnable(Graphics3DNode node) {
            this.node = node;
        }

        @Override
        public void run() {
            this.rotation += 0.01;
            this.translation += 0.01;
            if (this.scalingDown) {
                this.scale *= 0.99;
                if (this.scale < 0.1) {
                    this.scalingDown = false;
                }
            } else {
                this.scale *= 1.01;
                if (this.scale > 2.0) {
                    this.scalingDown = true;
                }
            }
            AffineTransform transform = new AffineTransform();
            transform.getLinearTransform().setEuler(1.5707963267948966, 0.0, this.rotation);
            transform.appendScale(this.scale);
            transform.setTranslation((Tuple3DReadOnly)new Vector3D(this.translation, 0.0, 0.0));
            this.node.setTransform(transform);
        }
    }

    private class BlinkRunnable
    implements Runnable {
        private final Graphics3DInstruction instruction;
        private double transparency = 0.0;

        public BlinkRunnable(Graphics3DInstruction instruction) {
            this.instruction = instruction;
        }

        @Override
        public void run() {
            this.transparency += 0.01;
            if (this.transparency > 1.0) {
                this.transparency = 0.0;
            }
            MutableColor color = new MutableColor((float)Math.random(), (float)Math.random(), (float)Math.random());
            YoAppearanceRGBColor appearance = new YoAppearanceRGBColor(color, 0.0);
            appearance.setTransparency(this.transparency);
            this.instruction.setAppearance((AppearanceDefinition)appearance);
        }
    }
}

