/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.app.Application;
import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import jme3tools.optimize.GeometryBatchFactory;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.instructions.ArcTorusGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CapsuleGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.ConeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CubeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CylinderGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.EllipsoidGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.ExtrudedPolygonGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddExtrusionInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddHeightMapInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddModelFileInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstructionExecutor;
import us.ihmc.graphicsDescription.instructions.HemiEllipsoidGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PolygonGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PrimitiveGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PyramidCubeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.SphereGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.TruncatedConeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.WedgeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.listeners.AppearanceChangedListener;
import us.ihmc.graphicsDescription.instructions.listeners.ExtrusionChangedListener;
import us.ihmc.graphicsDescription.instructions.listeners.MeshChangedListener;
import us.ihmc.graphicsDescription.instructions.listeners.ScaleChangedListener;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DRotateInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DScaleInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DTranslateInstruction;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEAppearanceMaterial;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEMeshDataInterpreter;
import us.ihmc.jMonkeyEngineToolkit.jme.terrain.JMEHeightMapTerrain;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.jMonkeyEngineToolkit.tralala.ShapeUtilities;

public class JMEGraphicsObject
extends Graphics3DInstructionExecutor {
    private final AssetManager assetManager;
    private final Application application;
    private Node rootNode = new Node();
    protected Node currentNode;
    private final boolean immutable;
    private boolean optimizeGraphicsObject = false;
    private static final boolean DEBUG = false;

    public JMEGraphicsObject(Application application, AssetManager jmeAssetLocator, Graphics3DObject graphics3dObject) {
        this.application = application;
        this.assetManager = jmeAssetLocator;
        this.immutable = !graphics3dObject.isChangeable();
        this.currentNode = this.rootNode;
        this.setUpGraphicsFromDefinition(graphics3dObject.getGraphics3DInstructions());
        if (this.optimizeGraphicsObject && this.immutable) {
            this.rootNode = (Node)GeometryBatchFactory.optimize((Node)this.rootNode);
        }
    }

    public static Spatial createGraphics3DObjectFromModel(String fileName, String submesh, boolean centerSubmesh, AppearanceDefinition appearanceDefinition, AssetManager jmeAssetLocator) {
        Spatial spatial;
        try {
            spatial = jmeAssetLocator.loadModel(fileName);
            if (submesh != null) {
                if ((spatial = JMEGraphicsObject.findSubmesh(spatial, submesh, centerSubmesh)) instanceof Node && ((Node)spatial).getChildren().size() > 1) {
                    spatial = ((Node)spatial).getChild(0);
                }
                if (spatial == null) {
                    System.err.println("Cannot find submesh " + submesh);
                    spatial = new Node();
                    appearanceDefinition = null;
                } else {
                    Vector3f worldScale = spatial.getWorldScale();
                    spatial = spatial.clone();
                    spatial.setLocalScale(worldScale);
                    if (centerSubmesh) {
                        spatial.center();
                    }
                }
            }
            if (appearanceDefinition != null) {
                ArrayList geometries = new ArrayList();
                GeometryBatchFactory.gatherGeoms((Spatial)spatial, geometries);
                Mesh outMesh = new Mesh();
                GeometryBatchFactory.mergeGeometries(geometries, (Mesh)outMesh);
                spatial = new Geometry(spatial.getName(), outMesh);
                JMEGraphicsObject.setGeometryMaterialBasedOnAppearance(spatial, appearanceDefinition, jmeAssetLocator);
            }
            spatial.updateModelBound();
        }
        catch (Exception e) {
            e.printStackTrace();
            spatial = new Node();
        }
        return spatial;
    }

    public static Spatial findSubmesh(Spatial spatial, String submesh, boolean centerSubmesh) {
        if (spatial instanceof Node) {
            if (spatial.getName().equals(submesh)) {
                return spatial;
            }
            List spatials = ((Node)spatial).getChildren();
            for (Spatial child : spatials) {
                Spatial ret = JMEGraphicsObject.findSubmesh(child, submesh, centerSubmesh);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    public static void printSubmeshes(Spatial spatial) {
        System.out.println(spatial.getName() + " " + spatial.getLocalTransform());
        if (spatial instanceof Node) {
            List spatials = ((Node)spatial).getChildren();
            for (Spatial child : spatials) {
                JMEGraphicsObject.printSubmeshes(child);
            }
        }
    }

    public Node getNode() {
        return this.rootNode;
    }

    protected void doAddModelFileInstruction(Graphics3DAddModelFileInstruction graphics3dObjectAddModelFile) {
        if (graphics3dObjectAddModelFile.getResourceClassLoader() != null) {
            this.assetManager.addClassLoader(graphics3dObjectAddModelFile.getResourceClassLoader());
        }
        Spatial spatial = JMEGraphicsObject.createGraphics3DObjectFromModel(graphics3dObjectAddModelFile.getFileName(), graphics3dObjectAddModelFile.getSubmesh(), graphics3dObjectAddModelFile.centerSubmesh(), graphics3dObjectAddModelFile.getAppearance(), this.assetManager);
        this.currentNode.attachChild(spatial);
        if (graphics3dObjectAddModelFile.getAppearance() != null) {
            this.addAppearanceChangedListener((Graphics3DInstruction)graphics3dObjectAddModelFile, spatial);
        }
    }

    protected void doIdentityInstruction() {
        this.currentNode = this.rootNode;
    }

    protected void doRotateInstruction(Graphics3DRotateInstruction graphics3dObjectRotateMatrix) {
        us.ihmc.euclid.tuple4D.Quaternion quat4d = new us.ihmc.euclid.tuple4D.Quaternion((Orientation3DReadOnly)graphics3dObjectRotateMatrix.getRotationMatrix());
        Quaternion quaternion = new Quaternion();
        JMEDataTypeUtils.packVectMathQuat4dInJMEQuaternion((QuaternionReadOnly)quat4d, quaternion);
        this.rotate(quaternion);
    }

    protected void doScaleInstruction(Graphics3DScaleInstruction graphics3dObjectScale) {
        Node scale = new Node();
        Vector3D scaleFactor = graphics3dObjectScale.getScaleFactor();
        scale.setLocalScale((float)scaleFactor.getX(), (float)scaleFactor.getY(), (float)scaleFactor.getZ());
        this.currentNode.attachChild((Spatial)scale);
        this.currentNode = scale;
        this.addChangedScaleListener(scale, graphics3dObjectScale);
    }

    private void addChangedScaleListener(final Node scale, Graphics3DScaleInstruction graphics3dObjectScale) {
        graphics3dObjectScale.addChangeScaleListener(new ScaleChangedListener(){

            public void setScale(final Vector3DReadOnly scaleFactor) {
                JMEGraphicsObject.this.checkIfNotImmutable();
                JMEGraphicsObject.this.application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        scale.setLocalScale((float)scaleFactor.getX(), (float)scaleFactor.getY(), (float)scaleFactor.getZ());
                        return null;
                    }
                });
            }
        });
    }

    protected void doTranslateInstruction(Graphics3DTranslateInstruction graphics3dObjectTranslate) {
        Vector3f offset = JMEDataTypeUtils.vecMathTuple3dToJMEVector3f((Tuple3DReadOnly)graphics3dObjectTranslate.getTranslation());
        this.translate(offset);
    }

    private void setGeometryMaterialBasedOnAppearance(Spatial geometry, AppearanceDefinition appearance) {
        JMEGraphicsObject.setGeometryMaterialBasedOnAppearance(geometry, appearance, this.assetManager);
    }

    private static void setGeometryMaterialBasedOnAppearance(Spatial geometry, AppearanceDefinition appearance, AssetManager jmeAssetLocator) {
        Material jmeAppearance;
        try {
            jmeAppearance = JMEAppearanceMaterial.createMaterial(jmeAssetLocator, appearance);
        }
        catch (Exception e) {
            YoAppearanceRGBColor color = new YoAppearanceRGBColor(0.5, 0.5, 0.5, 0.5);
            jmeAppearance = JMEAppearanceMaterial.createMaterialFromYoAppearanceRGBColor(jmeAssetLocator, color);
        }
        geometry.setMaterial(jmeAppearance);
        if (appearance.getTransparency() < 0.99) {
            geometry.setQueueBucket(RenderQueue.Bucket.Transparent);
        } else {
            geometry.setQueueBucket(RenderQueue.Bucket.Opaque);
        }
    }

    private void translate(Vector3f offset) {
        Node translation = new Node();
        translation.move(offset);
        this.currentNode.attachChild((Spatial)translation);
        this.currentNode = translation;
    }

    private void rotate(Quaternion quaternion) {
        Node rotation = new Node();
        rotation.rotate(quaternion);
        this.currentNode.attachChild((Spatial)rotation);
        this.currentNode = rotation;
    }

    protected void doAddExtrusionInstruction(final Graphics3DAddExtrusionInstruction graphics3dObjectAddExtrusion) {
        BufferedImage bufferedImage = graphics3dObjectAddExtrusion.getBufferedImage();
        AppearanceDefinition appearance = graphics3dObjectAddExtrusion.getAppearance();
        double thickness = graphics3dObjectAddExtrusion.getHeight();
        Geometry textGeometry = this.getExtrusionGeometry(bufferedImage, thickness, appearance);
        final Node textHolder = new Node();
        textHolder.attachChild((Spatial)textGeometry);
        this.currentNode.attachChild((Spatial)textHolder);
        graphics3dObjectAddExtrusion.setTextChangedListener(new ExtrusionChangedListener(){

            public void extrusionChanged(final BufferedImage newImage, final double thickness) {
                JMEGraphicsObject.this.checkIfNotImmutable();
                JMEGraphicsObject.this.application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        textHolder.detachAllChildren();
                        Geometry textGeometry = JMEGraphicsObject.this.getExtrusionGeometry(newImage, thickness, graphics3dObjectAddExtrusion.getAppearance());
                        textHolder.attachChild((Spatial)textGeometry);
                        JMEGraphicsObject.this.addAppearanceChangedListener((Graphics3DInstruction)graphics3dObjectAddExtrusion, (Spatial)textGeometry);
                        return null;
                    }
                });
            }
        });
        this.addAppearanceChangedListener((Graphics3DInstruction)graphics3dObjectAddExtrusion, (Spatial)textGeometry);
    }

    private Geometry getExtrusionGeometry(BufferedImage bufferedImage, double thickness, AppearanceDefinition appearance) {
        Geometry geometry = ShapeUtilities.createShape(bufferedImage, (float)thickness);
        geometry.scale((float)bufferedImage.getWidth() / (float)bufferedImage.getHeight(), 1.0f, 1.0f);
        this.setGeometryMaterialBasedOnAppearance((Spatial)geometry, appearance);
        return geometry;
    }

    protected void doAddHeightMapInstruction(Graphics3DAddHeightMapInstruction graphics3dObjectAddHeightMap) {
        this.optimizeGraphicsObject = false;
        HeightMap heightMap = graphics3dObjectAddHeightMap.getHeightMap();
        AppearanceDefinition appearanceDefinition = graphics3dObjectAddHeightMap.getAppearance();
        JMEHeightMapTerrain jmeTerrain = new JMEHeightMapTerrain(heightMap, this.assetManager, appearanceDefinition);
        Node terrainNode = jmeTerrain.getTerrain();
        this.currentNode.attachChild((Spatial)terrainNode);
        this.addAppearanceChangedListener((Graphics3DInstruction)graphics3dObjectAddHeightMap, (Spatial)terrainNode);
    }

    protected void doAddMeshDataInstruction(final Graphics3DAddMeshDataInstruction graphics3dObjectAddMeshData) {
        MeshDataHolder meshData = graphics3dObjectAddMeshData.getMeshData();
        AppearanceDefinition appearance = graphics3dObjectAddMeshData.getAppearance();
        Mesh mesh = JMEMeshDataInterpreter.interpretMeshData(meshData);
        final Node meshHolder = new Node();
        if (meshData != null) {
            Geometry geometry = new Geometry(meshData.getName() + "_Geometry", mesh);
            this.setGeometryMaterialBasedOnAppearance((Spatial)geometry, appearance);
            meshHolder.attachChild((Spatial)geometry);
            this.addAppearanceChangedListener((Graphics3DInstruction)graphics3dObjectAddMeshData, (Spatial)geometry);
        }
        this.currentNode.attachChild((Spatial)meshHolder);
        graphics3dObjectAddMeshData.setMeshChangedListener(new MeshChangedListener(){

            public void meshChanged(final MeshDataHolder newMesh) {
                JMEGraphicsObject.this.checkIfNotImmutable();
                JMEGraphicsObject.this.application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        meshHolder.detachAllChildren();
                        if (newMesh == null) {
                            return null;
                        }
                        Mesh mesh = JMEMeshDataInterpreter.interpretMeshData(newMesh);
                        Geometry geometry = new Geometry("MeshData", mesh);
                        JMEGraphicsObject.this.setGeometryMaterialBasedOnAppearance((Spatial)geometry, graphics3dObjectAddMeshData.getAppearance());
                        meshHolder.attachChild((Spatial)geometry);
                        return null;
                    }
                });
            }
        });
    }

    private void addAppearanceChangedListener(Graphics3DInstruction instruction, final Spatial spatial) {
        instruction.setAppearanceChangedListener(new AppearanceChangedListener(){

            public void appearanceChanged(final AppearanceDefinition newAppearance) {
                JMEGraphicsObject.this.checkIfNotImmutable();
                if (newAppearance != null) {
                    JMEGraphicsObject.this.application.enqueue((Callable)new Callable<Object>(){

                        @Override
                        public Material call() throws Exception {
                            JMEGraphicsObject.this.setGeometryMaterialBasedOnAppearance(spatial, newAppearance);
                            return null;
                        }
                    });
                }
            }
        });
    }

    private void checkIfNotImmutable() {
        if (this.immutable) {
            throw new RuntimeException("Graphics3DObject is not changable. Call Graphics3dObject.isChangable(true) before adding the graphics object");
        }
    }

    private static void printIfDebug(String string) {
    }

    protected void doAddPrimitiveInstruction(PrimitiveGraphics3DInstruction primitiveInstruction) {
        if (primitiveInstruction instanceof CubeGraphics3DInstruction) {
            CubeGraphics3DInstruction cubeInstruction = (CubeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Cube((double)cubeInstruction.getLength(), (double)cubeInstruction.getWidth(), (double)cubeInstruction.getHeight(), (boolean)cubeInstruction.getCenteredInTheCenter(), (boolean[])cubeInstruction.getTextureFaces());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)cubeInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof SphereGraphics3DInstruction) {
            SphereGraphics3DInstruction sphereInstruction = (SphereGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Sphere((double)sphereInstruction.getRadius(), (int)sphereInstruction.getResolution(), (int)sphereInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)sphereInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof WedgeGraphics3DInstruction) {
            WedgeGraphics3DInstruction wedgeInstruction = (WedgeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Wedge((double)wedgeInstruction.getLengthX(), (double)wedgeInstruction.getWidthY(), (double)wedgeInstruction.getHeightZ());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)wedgeInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof CapsuleGraphics3DInstruction) {
            CapsuleGraphics3DInstruction capsuleInstruction = (CapsuleGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Capsule((double)capsuleInstruction.getHeight(), (double)capsuleInstruction.getXRadius(), (double)capsuleInstruction.getYRadius(), (double)capsuleInstruction.getZRadius(), (int)capsuleInstruction.getResolution(), (int)capsuleInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)capsuleInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof EllipsoidGraphics3DInstruction) {
            EllipsoidGraphics3DInstruction ellipsoidInstruction = (EllipsoidGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Ellipsoid((double)ellipsoidInstruction.getXRadius(), (double)ellipsoidInstruction.getYRadius(), (double)ellipsoidInstruction.getZRadius(), (int)ellipsoidInstruction.getResolution(), (int)ellipsoidInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)ellipsoidInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof CylinderGraphics3DInstruction) {
            CylinderGraphics3DInstruction cylinderInstruction = (CylinderGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Cylinder((double)cylinderInstruction.getRadius(), (double)cylinderInstruction.getHeight(), (int)cylinderInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)cylinderInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof ConeGraphics3DInstruction) {
            ConeGraphics3DInstruction coneInstruction = (ConeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Cone((double)coneInstruction.getHeight(), (double)coneInstruction.getRadius(), (int)coneInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)coneInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof TruncatedConeGraphics3DInstruction) {
            TruncatedConeGraphics3DInstruction truncatedConeInstruction = (TruncatedConeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.GenTruncatedCone((double)truncatedConeInstruction.getHeight(), (double)truncatedConeInstruction.getXBaseRadius(), (double)truncatedConeInstruction.getYBaseRadius(), (double)truncatedConeInstruction.getXTopRadius(), (double)truncatedConeInstruction.getYTopRadius(), (int)truncatedConeInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)truncatedConeInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof HemiEllipsoidGraphics3DInstruction) {
            HemiEllipsoidGraphics3DInstruction hemiEllipsoidInstruction = (HemiEllipsoidGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.HemiEllipsoid((double)hemiEllipsoidInstruction.getXRadius(), (double)hemiEllipsoidInstruction.getYRadius(), (double)hemiEllipsoidInstruction.getZRadius(), (int)hemiEllipsoidInstruction.getResolution(), (int)hemiEllipsoidInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)hemiEllipsoidInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof ArcTorusGraphics3DInstruction) {
            ArcTorusGraphics3DInstruction arcTorusInstruction = (ArcTorusGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.ArcTorus((double)arcTorusInstruction.getStartAngle(), (double)arcTorusInstruction.getEndAngle(), (double)arcTorusInstruction.getMajorRadius(), (double)arcTorusInstruction.getMinorRadius(), (int)arcTorusInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)arcTorusInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof PyramidCubeGraphics3DInstruction) {
            PyramidCubeGraphics3DInstruction pyramidInstruction = (PyramidCubeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.PyramidCube((double)pyramidInstruction.getLengthX(), (double)pyramidInstruction.getWidthY(), (double)pyramidInstruction.getHeightZ(), (double)pyramidInstruction.getPyramidHeight());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)pyramidInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof PolygonGraphics3DInstruction) {
            PolygonGraphics3DInstruction polygonInstruction = (PolygonGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Polygon((List)polygonInstruction.getPolygonPoints());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)polygonInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof ExtrudedPolygonGraphics3DInstruction) {
            ExtrudedPolygonGraphics3DInstruction extrudedPolygonInstruction = (ExtrudedPolygonGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.ExtrudedPolygon((List)extrudedPolygonInstruction.getPolygonPoints(), (double)extrudedPolygonInstruction.getExtrusionHeight());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)extrudedPolygonInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else {
            throw new RuntimeException("Need to support that primitive type! primitiveInstruction = " + primitiveInstruction);
        }
    }
}

