/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEMeshDataInterpreter;
import us.ihmc.robotics.Assert;

public class JMEMeshDataInterpreterTest {
    @Test
    public void testForASingleTriangle() {
        Point3D32[] vertices = new Point3D32[]{new Point3D32(0.1f, -1.0f, 0.2f), new Point3D32(0.8f, -0.3f, 0.2f), new Point3D32(-0.4f, 0.6f, 0.2f)};
        MeshDataHolder meshData = MeshDataGenerator.Polygon((Point3DReadOnly[])vertices);
        Mesh interpretMeshData = JMEMeshDataInterpreter.interpretMeshData((MeshDataHolder)meshData);
        Assert.assertEquals(1L, interpretMeshData.getTriangleCount());
        Triangle triangle = new Triangle();
        interpretMeshData.getTriangle(0, triangle);
        Vector3f normal = triangle.getNormal();
        Vector3f expectedNormal = new Vector3f(0.0f, 0.0f, 1.0f);
        this.assertJMEVectorsEqual(expectedNormal, normal);
        this.assertJMEVectorEqualsPoint(triangle.get1(), vertices[0]);
        this.assertJMEVectorEqualsPoint(triangle.get2(), vertices[1]);
        this.assertJMEVectorEqualsPoint(triangle.get3(), vertices[2]);
    }

    @Test
    public void testForASimpleCube() {
        MeshDataHolder meshData = MeshDataGenerator.Cube((float)1.0f, (float)1.0f, (float)1.0f, (boolean)true, null);
        Mesh interpretMeshData = JMEMeshDataInterpreter.interpretMeshData((MeshDataHolder)meshData);
        Assert.assertEquals(12L, interpretMeshData.getTriangleCount());
        Assert.assertEquals(24L, interpretMeshData.getVertexCount());
        for (int i = 0; i < interpretMeshData.getTriangleCount(); ++i) {
            Triangle triangle = new Triangle();
            interpretMeshData.getTriangle(i, triangle);
            Vector3f normal = triangle.getNormal();
            System.out.println("normal = " + normal);
            Vector3f trianglePoint1 = triangle.get1();
            Vector3f trianglePoint2 = triangle.get2();
            Vector3f trianglePoint3 = triangle.get3();
            System.out.println("trianglePoint1 = " + trianglePoint1);
            System.out.println("trianglePoint2 = " + trianglePoint2);
            System.out.println("trianglePoint3 = " + trianglePoint3);
        }
    }

    private void assertJMEVectorEqualsPoint(Vector3f vector, Point3D32 point) {
        this.assertJMEVectorsEqual(vector, new Vector3f(point.getX32(), point.getY32(), point.getZ32()));
    }

    private void assertJMEVectorsEqual(Vector3f vectorOne, Vector3f vectorTwo) {
        Assert.assertEquals(0.0, (double)vectorOne.distance(vectorTwo), 1.0E-7);
    }
}

