/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import com.jme3.system.awt.AwtPanel;
import com.jme3.system.awt.AwtPanelsContext;
import com.jme3.system.awt.PaintMode;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Container;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.junit.jupiter.api.Tag;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanel;
import us.ihmc.jMonkeyEngineToolkit.jme.context.PBOAwtPanelsContext;

@Tag(value="jme")
public class AWTPanelsTest
extends SimpleApplication {
    private static final boolean USE_PBO = true;
    protected Geometry player;

    public void simpleInitApp() {
        Box b = new Box(1.0f, 1.0f, 1.0f);
        this.player = new Geometry("blue cube", (Mesh)b);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", ColorRGBA.Blue);
        this.player.setMaterial(mat);
        this.rootNode.attachChild((Spatial)this.player);
        this.flyCam.setDragToRotate(true);
        if (this.context instanceof AwtPanelsContext) {
            AwtPanelsContext awtPanelsContext = (AwtPanelsContext)this.context;
            AwtPanel panel = awtPanelsContext.createPanel(PaintMode.Accelerated);
            panel.attachTo(true, new ViewPort[]{this.viewPort, this.guiViewPort});
            AWTPanelsTest.createNewWindow((Canvas)panel);
        } else {
            PBOAwtPanelsContext awtPanelsContext = (PBOAwtPanelsContext)this.context;
            PBOAwtPanel panel = awtPanelsContext.createPanel();
            panel.attachTo(true, new ViewPort[]{this.viewPort, this.guiViewPort});
            AWTPanelsTest.createNewWindow((Canvas)panel);
        }
    }

    public void simpleUpdate(float tpf) {
        this.player.rotate(0.0f, 2.0f * tpf, 0.0f);
    }

    private static void createNewWindow(Canvas canvas) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", canvas);
        JFrame jFrame = new JFrame("AWTPanelsTest");
        jFrame.setDefaultCloseOperation(3);
        Container contentPane = jFrame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", panel);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setSize(1920, 1080);
    }

    public static void main(String[] argv) {
        AppSettings appSettings = new AppSettings(true);
        appSettings.setCustomRenderer(PBOAwtPanelsContext.class);
        AWTPanelsTest test = new AWTPanelsTest();
        test.setSettings(appSettings);
        test.setShowSettings(false);
        test.start();
    }
}

