/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import java.util.concurrent.Callable;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.jMonkeyEngineToolkit.GPULidarListener;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DFrameListener;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DWorld;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.JMEGPULidar;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestParameters;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestScan;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMELidarScanVisualizer;
import us.ihmc.jMonkeyEngineToolkit.utils.FlatHeightMap;

@Tag(value="jme")
public class JMEGPULidarParallelSceneGraphTest {
    @Disabled
    @Test
    public void testGPULidarParallelSceneGraph() {
        JMEGraphics3DWorld world = new JMEGraphics3DWorld(this.getClass().getSimpleName(), new JMEGraphics3DAdapter(true));
        final JMERenderer renderer = world.getGraphics3DAdapter().getRenderer();
        final LidarTestParameters scanParameters = new LidarTestParameters();
        scanParameters.setScansPerSweep(720);
        scanParameters.setLidarSweepStartAngle(-0.7853981633974483);
        scanParameters.setLidarSweepEndAngle(0.7853981633974483);
        scanParameters.setMinRange(0.2);
        scanParameters.setMaxRange(1000.0);
        final JMELidarScanVisualizer visualizer = new JMELidarScanVisualizer();
        AppearanceDefinition invisibleSphereAppearance = YoAppearance.Blue();
        invisibleSphereAppearance.setTransparency(0.5);
        Graphics3DObject invisibleSphereObject = new Graphics3DObject((Shape3DReadOnly)new Sphere3D(0.5), invisibleSphereAppearance);
        final Graphics3DNode invisibleSphereNode = new Graphics3DNode("InvisibleSphereNode", Graphics3DNodeType.VISUALIZATION, invisibleSphereObject);
        invisibleSphereNode.translate(1.5, 1.0, 1.0);
        world.addChild(invisibleSphereNode);
        AppearanceDefinition visibleSphereAppearance = YoAppearance.Red();
        invisibleSphereAppearance.setTransparency(0.5);
        Graphics3DObject visibleSphereObject = new Graphics3DObject((Shape3DReadOnly)new Sphere3D(0.5), visibleSphereAppearance);
        final Graphics3DNode visibleSphereNode = new Graphics3DNode("VisibleSphereNode", Graphics3DNodeType.JOINT, visibleSphereObject);
        visibleSphereNode.translate(1.5, -1.0, 1.0);
        world.addChild(visibleSphereNode);
        AppearanceDefinition wallAppearance = YoAppearance.Green();
        wallAppearance.setTransparency(0.5);
        Graphics3DObject wallObject = new Graphics3DObject();
        wallObject.addCube(0.1, 100.0, 100.0, wallAppearance);
        Graphics3DNode wallNode = new Graphics3DNode("WallyTheWall", Graphics3DNodeType.GROUND, wallObject);
        wallNode.translate(2.0, 0.0, -50.0);
        world.addChild(wallNode);
        world.getGraphics3DAdapter().getRenderer().setHeightMap((HeightMap)new FlatHeightMap());
        world.getGraphics3DAdapter().getRenderer().setGroundVisible(true);
        final Graphics3DNode lidarNode = new Graphics3DNode("lidar", Graphics3DNodeType.ROOTJOINT, new Graphics3DObject());
        lidarNode.getGraphics3DObject().addModelFile("models/hokuyo.dae", YoAppearance.Black());
        lidarNode.translate(0.5, Axis3D.Z);
        world.addChild(lidarNode);
        final JMEGPULidar gpuLidar = renderer.createGPULidar(scanParameters.getScansPerSweep(), scanParameters.getScanHeight(), scanParameters.getFieldOfView(), scanParameters.getMinRange(), scanParameters.getMaxRange());
        gpuLidar.setTransformFromWorld(lidarNode.getTransform(), 0.0);
        gpuLidar.addGPULidarListener(new GPULidarListener(){

            public void scan(float[] scan, RigidBodyTransform currentTransform, double time) {
                LidarTestScan lidarScan = new LidarTestScan(scanParameters, currentTransform, currentTransform, scan, 1);
                visualizer.updateLidarNodeTransform(lidarNode.getTransform());
                visualizer.addPointCloud(lidarScan.getAllPoints3f());
                RigidBodyTransform newTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)currentTransform);
                newTransform.appendRollRotation(0.031415926535897934);
                renderer.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        lidarNode.getTransform().appendRollRotation(0.031415926535897934);
                        return null;
                    }
                });
                gpuLidar.setTransformFromWorld(newTransform, 0.0);
            }
        });
        world.startWithGui();
        world.addFrameListener(new Graphics3DFrameListener(){
            double time = 0.0;
            double speed = 0.2;

            public void postFrame(double timePerFrame) {
                this.time += timePerFrame;
                double invisibleY = Math.cos(this.time * this.speed);
                double invisibleZ = -Math.sin(this.time * this.speed) + 1.0;
                double visibleY = Math.cos(this.time * this.speed + Math.PI);
                double visibleZ = Math.sin(this.time * this.speed) + 1.0;
                invisibleSphereNode.translateTo(1.5, invisibleY, invisibleZ);
                visibleSphereNode.translateTo(1.5, visibleY, visibleZ);
            }
        });
        double keepAlive = 5.0;
        world.keepAlive(keepAlive);
        visualizer.keepAlive(keepAlive);
        world.stop();
        visualizer.stop();
    }
}

