/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme;

import java.util.concurrent.Callable;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DFrameListener;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DWorld;
import us.ihmc.jMonkeyEngineToolkit.jme.JMERenderer;
import us.ihmc.jMonkeyEngineToolkit.utils.CoordinateFrameNode;
import us.ihmc.jMonkeyEngineToolkit.utils.FlatHeightMap;
import us.ihmc.robotics.Assert;

@Tag(value="jme")
public class JMERendererTest {
    @Test
    public void testInitialization() {
        JMEGraphics3DWorld world = new JMEGraphics3DWorld(new JMEGraphics3DAdapter());
        JMERenderer renderer = world.getGraphics3DAdapter().getRenderer();
        world.startWithoutGui();
        Assert.assertNotNull(renderer);
        world.stop();
    }

    @Test
    public void testSetGroundVisible() {
        JMEGraphics3DWorld world = new JMEGraphics3DWorld(new JMEGraphics3DAdapter());
        JMERenderer renderer = world.getGraphics3DAdapter().getRenderer();
        world.startWithGui();
        renderer.setHeightMap((HeightMap)new FlatHeightMap());
        for (int i = 0; i < 5; ++i) {
            world.keepAlive(0.2);
            renderer.setGroundVisible(true);
            world.keepAlive(0.2);
            renderer.setGroundVisible(false);
        }
        world.stop();
    }

    @Disabled
    @Test
    public void testFreezeFrame() {
        final JMEGraphics3DWorld world = new JMEGraphics3DWorld(new JMEGraphics3DAdapter());
        JMERenderer renderer = world.getGraphics3DAdapter().getRenderer();
        world.startWithGui();
        final Graphics3DNode sphereNode = new Graphics3DNode("SphereNode", new Graphics3DObject((Shape3DReadOnly)new Sphere3D(1.0), YoAppearance.Green()));
        world.addChild(sphereNode);
        world.addChild((Graphics3DNode)new CoordinateFrameNode());
        world.addFrameListener(new Graphics3DFrameListener(){
            double totalTime = 0.0;

            public void postFrame(final double timePerFrame) {
                world.getGraphics3DAdapter().getRenderer().enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        double angularVelocity = 100000.0;
                        double radiusOfMotion = 3.0;
                        totalTime += angularVelocity * timePerFrame;
                        double x = radiusOfMotion * Math.cos(totalTime);
                        double y = radiusOfMotion * Math.sin(totalTime);
                        double z = 1.0;
                        Vector3D translation = new Vector3D(x, y, z);
                        sphereNode.translateTo((Tuple3DReadOnly)translation);
                        return null;
                    }
                });
            }
        });
        for (int i = 0; i < 5; ++i) {
            world.keepAlive(0.5);
            renderer.freezeFrame(sphereNode);
        }
        world.keepAlive(0.5);
        world.stop();
    }
}

