/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit.jme.util;

import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.Random;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DWorld;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestParameters;
import us.ihmc.jMonkeyEngineToolkit.jme.lidar.LidarTestScan;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEPointCloudGenerator;

public class JMEPointCloudGeneratorTest {
    public static void main(String[] args) {
        new JMEPointCloudGeneratorTest().testJmePointCloudGenerator();
    }

    public void testJmePointCloudGenerator() {
        JMEGraphics3DAdapter jmeGraphics3DAdapter = new JMEGraphics3DAdapter(false);
        Graphics3DWorld world = new Graphics3DWorld((Graphics3DAdapter)jmeGraphics3DAdapter);
        Graphics3DObject coordinateFrameObject = new Graphics3DObject();
        coordinateFrameObject.addCoordinateSystem(1.0);
        Graphics3DNode coordinateFrameNode = new Graphics3DNode(this.getClass().getSimpleName() + "CoordinateFrame", coordinateFrameObject);
        world.addChild(coordinateFrameNode);
        Random random = new Random();
        int numPoints = 1000;
        float[] ranges = RandomNumbers.nextFloatArray((Random)random, (int)numPoints, (float)5.0f);
        LidarTestParameters lidarScanParameters = new LidarTestParameters();
        lidarScanParameters.setScansPerSweep(numPoints);
        lidarScanParameters.setLidarSweepStartAngle(-Math.PI);
        lidarScanParameters.setLidarSweepEndAngle(Math.PI);
        lidarScanParameters.setMinRange(0.0);
        lidarScanParameters.setMaxRange(Double.POSITIVE_INFINITY);
        RigidBodyTransform startTransform = new RigidBodyTransform();
        RigidBodyTransform endTransform = new RigidBodyTransform();
        endTransform.setRotationRollAndZeroTranslation(0.7853981633974483);
        LidarTestScan lidarScan = new LidarTestScan(lidarScanParameters, startTransform, endTransform, ranges, 1);
        JMEPointCloudGenerator jmePointCloudGenerator = new JMEPointCloudGenerator(jmeGraphics3DAdapter.getRenderer().getAssetManager());
        Node pointCloudNode = jmePointCloudGenerator.generatePointCloudGraph(lidarScan.getAllPoints3f());
        jmeGraphics3DAdapter.getRenderer().getZUpNode().attachChild((Spatial)pointCloudNode);
        world.startWithGui();
    }
}

