/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.jMonkeyEngineToolkit;

import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.shape.primitives.Sphere3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DWorld;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;

@Tag(value="jme")
public class Graphics3DWorldTest {
    @Test
    public void testShowGui() {
        Graphics3DWorld world = new Graphics3DWorld("testWorld", (Graphics3DAdapter)new JMEGraphics3DAdapter());
        world.startWithGui();
        world.keepAlive(1.0);
        world.stop();
    }

    @Test
    public void testWithoutGui() {
        Graphics3DWorld world = new Graphics3DWorld("testWorld", (Graphics3DAdapter)new JMEGraphics3DAdapter());
        world.startWithoutGui();
        world.keepAlive(1.0);
        world.stop();
    }

    @Test
    public void addASphere() {
        Graphics3DWorld world = new Graphics3DWorld("testWorld", (Graphics3DAdapter)new JMEGraphics3DAdapter());
        world.startWithoutGui();
        world.addChild(new Graphics3DNode("Sphere", new Graphics3DObject((Shape3DReadOnly)new Sphere3D(), YoAppearance.Glass())));
        world.keepAlive(1.0);
        world.stop();
    }

    @Test
    public void addASphereAfterGuiStarted() {
        Graphics3DWorld world = new Graphics3DWorld("testWorld", (Graphics3DAdapter)new JMEGraphics3DAdapter());
        world.startWithoutGui();
        world.addChild(new Graphics3DNode("Sphere", new Graphics3DObject((Shape3DReadOnly)new Sphere3D())));
        world.keepAlive(1.0);
        world.stop();
    }

    @Test
    public void testSetCameraPosition() {
        Graphics3DWorld world = new Graphics3DWorld("testWorld", (Graphics3DAdapter)new JMEGraphics3DAdapter());
        world.startWithGui();
        world.addChild(new Graphics3DNode("Sphere", new Graphics3DObject((Shape3DReadOnly)new Sphere3D(), YoAppearance.Glass((double)0.2))));
        world.setCameraPosition(5.0, 5.0, 5.0);
        world.keepAlive(1.0);
        world.stop();
    }

    @Test
    public void fixCameraOnSphere() {
        Graphics3DWorld world = new Graphics3DWorld("testWorld", (Graphics3DAdapter)new JMEGraphics3DAdapter());
        Graphics3DNode sphereNode = new Graphics3DNode("Sphere", new Graphics3DObject((Shape3DReadOnly)new Sphere3D()));
        world.startWithGui();
        world.addChild(sphereNode);
        world.setCameraPosition(5.0, 5.0, 5.0);
        world.fixCameraOnNode(sphereNode);
        world.keepAlive(1.0);
        world.stop();
    }
}

