/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Path;
import us.ihmc.tools.io.HybridDirectory;
import us.ihmc.tools.io.HybridResourceMode;
import us.ihmc.tools.io.WorkspaceFile;

public class HybridFile {
    protected Path externalFile;
    protected WorkspaceFile workspaceFile;
    protected HybridResourceMode mode = HybridResourceMode.WORKSPACE;

    protected HybridFile() {
    }

    public HybridFile(HybridDirectory directory, String subsequentPathToFile) {
        this.externalFile = directory.getExternalDirectory().resolve(subsequentPathToFile);
        this.workspaceFile = new WorkspaceFile(directory.getWorkspaceDirectoryInternal(), subsequentPathToFile);
    }

    public boolean isWorkspaceFileAccessAvailable() {
        return this.workspaceFile.isFileAccessAvailable();
    }

    public void setMode(HybridResourceMode mode) {
        this.mode = mode;
    }

    public HybridResourceMode getMode() {
        return this.mode;
    }

    public Path getFileForWriting() {
        return this.mode == HybridResourceMode.WORKSPACE ? this.workspaceFile.getFilesystemFile() : this.externalFile;
    }

    public boolean isWritingAvailable() {
        boolean isWritingAvailable = this.mode == HybridResourceMode.WORKSPACE ? this.isWorkspaceFileAccessAvailable() : true;
        return isWritingAvailable;
    }

    public Path getExternalFile() {
        return this.externalFile;
    }

    public Path getWorkspaceFile() {
        return this.workspaceFile.getFilesystemFile();
    }
}

