/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;

public class ExceptionHandlingThreadScheduler {
    public static final ExceptionHandler DEFAULT_HANDLER = t -> {
        LogTools.error((String)t.getMessage());
        t.printStackTrace();
        LogTools.error((String)"{} is terminating due to an exception.", (Object)Thread.currentThread().getName());
    };
    private volatile ScheduledExecutorService executorService;
    private final ExceptionHandler exceptionHandler;
    private final long crashesBeforeGivingUp;
    private long crashCount = 0L;
    private Runnable runnable;
    private ScheduledFuture<?> scheduledFuture;
    private volatile boolean isRunningTask = false;

    public ExceptionHandlingThreadScheduler(String name) {
        this(name, DEFAULT_HANDLER, 0L);
    }

    public ExceptionHandlingThreadScheduler(String name, ExceptionHandler exceptionHandler) {
        this(name, exceptionHandler, 0L);
    }

    public ExceptionHandlingThreadScheduler(String prefix, ExceptionHandler exceptionHandler, long crashesBeforeGivingUp) {
        this(prefix, exceptionHandler, crashesBeforeGivingUp, false);
    }

    public ExceptionHandlingThreadScheduler(String prefix, ExceptionHandler exceptionHandler, long crashesBeforeGivingUp, boolean runAsDaemon) {
        this.executorService = runAsDaemon ? ThreadTools.newSingleDaemonThreadScheduledExecutor((String)prefix) : ThreadTools.newSingleThreadScheduledExecutor((String)prefix);
        this.exceptionHandler = exceptionHandler;
        this.crashesBeforeGivingUp = crashesBeforeGivingUp;
    }

    public ScheduledFuture<?> schedule(Runnable runnable, double period) {
        return this.schedule(runnable, Conversions.secondsToNanoseconds((double)period), TimeUnit.NANOSECONDS);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long period, TimeUnit timeunit) {
        this.runnable = runnable;
        ExceptionTools.handle(() -> {
            this.scheduledFuture = this.executorService.scheduleAtFixedRate(this::printingRunnableWrapper, 0L, period, timeunit);
            return this.scheduledFuture;
        }, exception -> LogTools.error((String)exception.getMessage()));
        return this.scheduledFuture;
    }

    public ScheduledFuture<?> scheduleOnce(Runnable runnable) {
        this.runnable = runnable;
        ExceptionTools.handle(() -> {
            this.scheduledFuture = this.executorService.schedule(this::printingRunnableWrapper, 0L, TimeUnit.MILLISECONDS);
            return this.scheduledFuture;
        }, exception -> LogTools.error((String)exception.getMessage()));
        return this.scheduledFuture;
    }

    private void printingRunnableWrapper() {
        this.isRunningTask = true;
        try {
            this.runnable.run();
        }
        catch (Throwable t) {
            this.exceptionHandler.handleException(t);
            ++this.crashCount;
            if (this.crashesBeforeGivingUp > 0L && this.crashCount > this.crashesBeforeGivingUp) {
                throw t;
            }
        }
        finally {
            this.isRunningTask = false;
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public void shutdownNow() {
        this.executorService.shutdownNow();
    }

    public boolean isRunningTask() {
        return this.isRunningTask;
    }
}

