/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.calibration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class CalibrationProperties {
    private final Properties properties;
    private final String defaultDirectory;
    private final String propertiesFile;

    public CalibrationProperties() {
        this("./calibration", "currentCalibration.property");
    }

    public CalibrationProperties(String directory, String currentPropertiesFile) {
        this.defaultDirectory = directory;
        this.propertiesFile = this.defaultDirectory + "/" + currentPropertiesFile;
        this.properties = new Properties();
        try {
            FileInputStream inStream = new FileInputStream(this.propertiesFile);
            this.properties.load(inStream);
            inStream.close();
        }
        catch (IOException e) {
            System.out.println("Properties file does not exist. No properties were set and a new file will be created when save is called.");
        }
    }

    public double getDoubleProperty(String key) {
        String stringProperty = this.properties.getProperty(key);
        if (stringProperty == null) {
            double defaultValue = 0.0;
            System.out.println("Property " + key + " not found. Creating it and defaulting to " + defaultValue);
            this.properties.setProperty(key, Double.toString(defaultValue));
            return defaultValue;
        }
        double property = Double.valueOf(stringProperty);
        return property;
    }

    public int getIntegerProperty(String key) {
        String stringProperty = this.properties.getProperty(key);
        if (stringProperty == null) {
            int defaultValue = 0;
            System.out.println("Property " + key + " not found. Creating it and defaulting to " + defaultValue);
            this.properties.setProperty(key, Integer.toString(defaultValue));
            return defaultValue;
        }
        int property = (int)this.expressionToValue(stringProperty);
        return property;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public void setProperty(String key, double value) {
        this.setProperty(key, Double.toString(value));
    }

    public void setProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public void save() {
        File dir = new File(this.defaultDirectory);
        if (!dir.exists()) {
            System.out.println("CREATED DIRECTORY:" + dir.mkdir());
        }
        try {
            FileOutputStream outStream = new FileOutputStream(this.propertiesFile);
            this.properties.store(outStream, null);
            outStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void replaceExpressionsByValuesAndSave() {
        Enumeration<?> propertyNameEnumeration = this.properties.propertyNames();
        while (propertyNameEnumeration.hasMoreElements()) {
            String propertyName = (String)propertyNameEnumeration.nextElement();
            String expression = this.properties.getProperty(propertyName);
            double value = this.expressionToValue(expression);
            this.setProperty(propertyName, value);
        }
        this.save();
    }

    private double expressionToValue(String expression) {
        boolean returnDelims = true;
        String plusToken = "+";
        String minusToken = "-";
        String operationTokens = plusToken + minusToken;
        StringTokenizer tokenizer = new StringTokenizer(expression, operationTokens, returnDelims);
        double ret = 0.0;
        int tokenCount = tokenizer.countTokens();
        int nextOperation = 1;
        for (int i = 0; i < tokenCount; ++i) {
            String token = tokenizer.nextToken().trim();
            if (token.equals(plusToken) || token.equals(minusToken)) {
                int operationValue;
                int n = operationValue = token.equals(plusToken) ? 1 : -1;
                if (nextOperation == 0) {
                    nextOperation = operationValue;
                    continue;
                }
                nextOperation *= operationValue;
                continue;
            }
            double doubleValue = Double.valueOf(token);
            ret += (double)nextOperation * doubleValue;
            nextOperation = 0;
        }
        return ret;
    }
}

