/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.time;

import java.util.ArrayDeque;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;
import us.ihmc.tools.Timer;
import us.ihmc.tools.UnitConversions;
import us.ihmc.tools.string.StringTools;
import us.ihmc.tools.thread.PausablePeriodicThread;

public class FrequencyStatisticPrinter {
    boolean newEvents;
    private double averageRate;
    private double minDelay;
    private double maxDelay;
    private double standardDeviation;
    private int window;
    private final ArrayDeque<Double> deltas = new ArrayDeque();
    private final Stopwatch stopwatch = new Stopwatch();
    private PausablePeriodicThread pausablePeriodicThread;
    private final double expiration = 1.0;
    private final Timer expirationTimer = new Timer();

    public FrequencyStatisticPrinter() {
        this(null);
    }

    public FrequencyStatisticPrinter(Runnable onLogReport) {
        this.reset();
        boolean runAsDaemon = true;
        this.pausablePeriodicThread = new PausablePeriodicThread(this.getClass().getSimpleName(), 1.0, 0, runAsDaemon, () -> {
            this.logReport();
            if (onLogReport != null) {
                onLogReport.run();
            }
        });
        this.pausablePeriodicThread.start();
    }

    private void logReport() {
        if (!this.newEvents) {
            this.reset();
            LogTools.info((String)"no new events");
        } else if (!this.expirationTimer.isRunning(1.0)) {
            this.reset();
        } else {
            LogTools.info(StringTools.format3D("averate rate: {}\n        min: {}s max: {}s std dev: {}s window: {}", this.averageRate, this.minDelay, this.maxDelay, this.standardDeviation, this.window));
        }
    }

    public synchronized void ping() {
        this.newEvents = true;
        ++this.window;
        this.expirationTimer.reset();
        double elapsed = this.stopwatch.lap();
        if (Double.isNaN(this.minDelay) || elapsed < this.minDelay) {
            this.minDelay = elapsed;
        }
        if (Double.isNaN(this.maxDelay) || elapsed > this.maxDelay) {
            this.maxDelay = elapsed;
        }
        this.deltas.addLast(elapsed);
        while (this.deltas.size() > 10) {
            this.deltas.removeFirst();
        }
        double totalElapsed = 0.0;
        for (Double delta : this.deltas) {
            totalElapsed += delta.doubleValue();
        }
        this.averageRate = UnitConversions.secondsToHertz(totalElapsed / (double)this.deltas.size());
        if (this.deltas.size() < 2) {
            this.standardDeviation = 0.0;
        } else {
            double average = this.stopwatch.averageLap();
            double sumOfSquares = 0.0;
            for (Double delta : this.deltas) {
                sumOfSquares += Math.pow(delta - average, 2.0);
            }
            this.standardDeviation = Math.sqrt(sumOfSquares / (double)this.deltas.size());
        }
    }

    public synchronized void reset() {
        this.newEvents = false;
        this.minDelay = Double.NaN;
        this.maxDelay = Double.NaN;
        this.standardDeviation = Double.NaN;
        this.window = -1;
        this.stopwatch.reset();
    }

    public void destroy() {
        this.pausablePeriodicThread.destroy();
    }
}

