/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.time;

import java.util.ArrayDeque;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.tools.UnitConversions;

public class FrequencyCalculator {
    private volatile double frequency;
    private final ArrayDeque<Double> deltas = new ArrayDeque();
    private final Stopwatch stopwatch = new Stopwatch().start();
    private final int history;

    public FrequencyCalculator() {
        this(3);
    }

    public FrequencyCalculator(int history) {
        this.history = history;
    }

    public void ping() {
        double elapsed = this.stopwatch.lap();
        this.deltas.addLast(elapsed);
        while (this.deltas.size() > this.history) {
            this.deltas.removeFirst();
        }
        double totalElapsed = 0.0;
        for (Double delta : this.deltas) {
            totalElapsed += delta.doubleValue();
        }
        this.frequency = UnitConversions.secondsToHertz(totalElapsed / (double)this.deltas.size());
    }

    public double getFrequency() {
        return this.frequency;
    }

    public boolean anyPingsYet() {
        return !this.deltas.isEmpty();
    }
}

