/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.function.Consumer;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;

public class JSONTools {
    public static void toJSON(ObjectNode jsonNode, RigidBodyTransformReadOnly rigidBodyTransform) {
        jsonNode.put("x", (float)MathTools.roundToPrecision((double)rigidBodyTransform.getTranslation().getX(), (double)5.0E-4));
        jsonNode.put("y", (float)MathTools.roundToPrecision((double)rigidBodyTransform.getTranslation().getY(), (double)5.0E-4));
        jsonNode.put("z", (float)MathTools.roundToPrecision((double)rigidBodyTransform.getTranslation().getZ(), (double)5.0E-4));
        jsonNode.put("rollInDegrees", (float)MathTools.roundToPrecision((double)Math.toDegrees(rigidBodyTransform.getRotation().getRoll()), (double)0.02));
        jsonNode.put("pitchInDegrees", (float)MathTools.roundToPrecision((double)Math.toDegrees(rigidBodyTransform.getRotation().getPitch()), (double)0.02));
        jsonNode.put("yawInDegrees", (float)MathTools.roundToPrecision((double)Math.toDegrees(rigidBodyTransform.getRotation().getYaw()), (double)0.02));
    }

    public static void toEuclid(JsonNode jsonNode, RigidBodyTransformBasics rigidBodyTransform) {
        rigidBodyTransform.getTranslation().setX(jsonNode.get("x").asDouble());
        rigidBodyTransform.getTranslation().setY(jsonNode.get("y").asDouble());
        rigidBodyTransform.getTranslation().setZ(jsonNode.get("z").asDouble());
        rigidBodyTransform.getRotation().setYawPitchRoll(Math.toRadians(jsonNode.get("yawInDegrees").asDouble()), Math.toRadians(jsonNode.get("pitchInDegrees").asDouble()), Math.toRadians(jsonNode.get("rollInDegrees").asDouble()));
    }

    public static void forEachArrayElement(JsonNode parentNode, String arrayName, Consumer<JsonNode> nodeConsumer) {
        Iterator actionNodeIterator = parentNode.withArray(arrayName).elements();
        while (actionNodeIterator.hasNext()) {
            nodeConsumer.accept((JsonNode)actionNodeIterator.next());
        }
    }
}

