/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import us.ihmc.commons.Conversions;
import us.ihmc.tools.Timer;

public class Throttler {
    private final Timer timer = new Timer();
    private double optionallySetPeriod = Double.NaN;

    public Throttler setPeriod(double period) {
        this.optionallySetPeriod = period;
        return this;
    }

    public Throttler setFrequency(double frequency) {
        this.optionallySetPeriod = Conversions.hertzToSeconds((double)frequency);
        return this;
    }

    public boolean run() {
        return this.run(this.optionallySetPeriod);
    }

    public boolean run(double period) {
        boolean run;
        boolean bl = run = !this.timer.isRunning(period);
        if (run) {
            this.timer.reset();
        }
        return run;
    }

    public void waitAndRun() {
        this.waitAndRun(this.optionallySetPeriod);
    }

    public void waitAndRun(double period) {
        this.timer.sleepUntilExpiration(period);
        this.timer.reset();
    }
}

