/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class SwapReference<T> {
    private final T a;
    private final T b;
    private T forThreadOne;
    private T forThreadTwo;

    public SwapReference(Supplier<T> supplier) {
        this(supplier.get(), supplier.get());
    }

    public SwapReference(T a, T b) {
        this.a = a;
        this.b = b;
        this.forThreadOne = a;
        this.forThreadTwo = b;
    }

    public void initializeBoth(Consumer<T> consumer) {
        consumer.accept(this.a);
        consumer.accept(this.b);
    }

    public T getA() {
        return this.a;
    }

    public T getB() {
        return this.b;
    }

    public T getForThreadOne() {
        return this.forThreadOne;
    }

    public T getForThreadTwo() {
        return this.forThreadTwo;
    }

    public boolean isThreadOneA() {
        return this.forThreadOne == this.a;
    }

    public synchronized void swap() {
        T temp = this.forThreadOne;
        this.forThreadOne = this.forThreadTwo;
        this.forThreadTwo = temp;
    }
}

