/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.concurrent.atomic.AtomicReference;

public class ActivationReference<T> {
    private final AtomicReference<T> atomicReference;
    private final T activatedValue;
    private boolean activationChanged = false;
    private T lastValue;

    public ActivationReference(AtomicReference<T> atomicReference, T activatedValue) {
        this.atomicReference = atomicReference;
        this.activatedValue = activatedValue;
        this.lastValue = atomicReference.get();
    }

    public boolean poll() {
        boolean lastValueActivated;
        T newValue = this.atomicReference.get();
        boolean newValueActivated = this.isValueActivated(newValue);
        this.activationChanged = newValueActivated != (lastValueActivated = this.isValueActivated(this.lastValue));
        this.lastValue = newValue;
        return newValueActivated;
    }

    public boolean peek() {
        T newValue = this.atomicReference.get();
        return this.isValueActivated(newValue);
    }

    public boolean hasChanged() {
        return this.activationChanged;
    }

    private boolean isValueActivated(T value) {
        boolean activated = value == this.activatedValue ? true : (value == null ? false : value.equals(this.activatedValue));
        return activated;
    }
}

