/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.nio.PathTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.WorkingDirectoryPathComponents;

public class WorkspacePathTools {
    public static Path findPathToResource(String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String resourcePathString) {
        Path directoryInline = PathTools.findDirectoryInline((String)directoryNameToAssumePresent);
        if (directoryInline != null) {
            return directoryInline.resolve(subsequentPathToResourceFolder).resolve(resourcePathString).toAbsolutePath().normalize();
        }
        return null;
    }

    public static Path handleWorkingDirectoryFuzziness(String directoryNameToFind) {
        Path absoluteWorkingDirectory = WorkspacePathTools.getWorkingDirectory();
        Path pathBuiltFromSystemRoot = Paths.get("/", new String[0]).toAbsolutePath().normalize();
        boolean directoryFound = false;
        for (Path path : absoluteWorkingDirectory) {
            pathBuiltFromSystemRoot = pathBuiltFromSystemRoot.resolve(path);
            if (!path.toString().equals(directoryNameToFind)) continue;
            directoryFound = true;
            break;
        }
        if (!directoryFound && Files.exists(pathBuiltFromSystemRoot.resolve(directoryNameToFind), new LinkOption[0])) {
            pathBuiltFromSystemRoot = pathBuiltFromSystemRoot.resolve(directoryNameToFind);
            directoryFound = true;
        }
        if (!directoryFound) {
            LogTools.warn((String)"{} directory could not be found. Working directory: {} Search stopped at: {}", (Object)directoryNameToFind, (Object)absoluteWorkingDirectory, (Object)pathBuiltFromSystemRoot);
            return null;
        }
        return pathBuiltFromSystemRoot;
    }

    public static Path getWorkingDirectory() {
        return Paths.get(".", new String[0]).toAbsolutePath().normalize();
    }

    public static WorkingDirectoryPathComponents inferWorkingDirectoryPathComponents(Class<?> classForLoading) {
        WorkingDirectoryPathComponents inferredPathComponents = null;
        try {
            URI locationURI;
            ProtectionDomain protectionDomain = classForLoading.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URL location = codeSource == null ? null : codeSource.getLocation();
            URI uRI = locationURI = location == null ? null : (URI)ExceptionTools.handle(location::toURI, (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
            if (locationURI != null && !location.getPath().isEmpty()) {
                Path codeSourceDirectory = Paths.get(locationURI);
                LogTools.debug((String)"Code source directory: {}", (Object)codeSourceDirectory);
                Path workingDirectory = WorkspacePathTools.getWorkingDirectory();
                LogTools.debug((String)"Working directory: {}", (Object)workingDirectory);
                if (codeSourceDirectory.getNameCount() < 1 || workingDirectory.getNameCount() < 1 || !codeSourceDirectory.getName(0).toString().equals(workingDirectory.getName(0).toString())) {
                    throw new RuntimeException("The code source directory and working directory need to share a common root.\n   Code source path: %s\n   Working directory: %s\n".formatted(codeSourceDirectory, workingDirectory));
                }
                int lastIndexOfSrc = -1;
                for (int nameElementIndex = 0; nameElementIndex < codeSourceDirectory.getNameCount(); ++nameElementIndex) {
                    if (!codeSourceDirectory.getName(nameElementIndex).toString().equals("src")) continue;
                    lastIndexOfSrc = nameElementIndex;
                }
                if (lastIndexOfSrc >= 0) {
                    Path pathBeforeResources = codeSourceDirectory.subpath(0, lastIndexOfSrc + 2);
                    LogTools.debug((String)"Path before resources: {}", (Object)pathBeforeResources);
                    Path pathWithResources = pathBeforeResources.resolve("resources").normalize();
                    LogTools.debug((String)"Path with resources: {}", (Object)pathWithResources);
                    int afterLastCommonPathElement = -1;
                    for (int pathNameElement = 0; pathNameElement < pathWithResources.getNameCount() && pathNameElement < workingDirectory.getNameCount(); ++pathNameElement) {
                        if (!pathWithResources.getName(pathNameElement).toString().equals(workingDirectory.getName(pathNameElement).toString())) continue;
                        afterLastCommonPathElement = pathNameElement + 1;
                    }
                    if (afterLastCommonPathElement >= lastIndexOfSrc) {
                        afterLastCommonPathElement = lastIndexOfSrc - 1;
                    }
                    String directoryNameToAssumePresent = pathWithResources.getName(afterLastCommonPathElement).toString();
                    int firstElementOfSubsequentPath = afterLastCommonPathElement + 1;
                    String subsequentPathToResourceFolder = pathWithResources.subpath(firstElementOfSubsequentPath, pathWithResources.getNameCount()).toString();
                    inferredPathComponents = new WorkingDirectoryPathComponents(directoryNameToAssumePresent, subsequentPathToResourceFolder);
                    LogTools.info((String)"Inferred workspace directory components:\n Directory name to assume present: {}\n Subsequent path to resource folder: {}", (Object)directoryNameToAssumePresent, (Object)subsequentPathToResourceFolder);
                } else {
                    LogTools.warn((String)"No src folder found.");
                }
            } else {
                LogTools.warn((String)"This class is not normally compiled or JAR not normally built.");
            }
        }
        catch (SecurityException securityException) {
            LogTools.error((String)securityException.getMessage());
        }
        return inferredPathComponents;
    }
}

