/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick.mapping;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Event;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.tools.inputDevices.joystick.JoystickCompatibilityFilter;
import us.ihmc.tools.inputDevices.joystick.mapping.JoystickMapping;

public enum XBoxOneMapping implements JoystickMapping
{
    A,
    B,
    X,
    Y,
    LEFT_BUMPER,
    RIGHT_BUMPER,
    SELECT,
    START,
    XBOX_BUTTON,
    LEFT_TRIGGER,
    RIGHT_TRIGGER,
    LEFT_STICK_X,
    LEFT_STICK_Y,
    RIGHT_STICK_X,
    RIGHT_STICK_Y,
    LEFT_STICK_BUTTON,
    RIGHT_STICK_BUTTON,
    DPAD,
    DPAD_UP,
    DPAD_DOWN,
    DPAD_LEFT,
    DPAD_RIGHT,
    SLIDER;

    public static final XBoxOneMapping[] values;
    private static final BiMap<Component.Identifier, XBoxOneMapping> windowsBiMap;
    private static final BiMap<Component.Identifier, XBoxOneMapping> macBiMap;
    private static final BiMap<Component.Identifier, XBoxOneMapping> linuxBiMap;

    private static void mapValues(XBoxOneMapping mapping, Component.Identifier windowsIdentifier, Component.Identifier macIdentifier, Component.Identifier linuxIdentifier) {
        windowsBiMap.put((Object)windowsIdentifier, (Object)mapping);
        macBiMap.put((Object)macIdentifier, (Object)mapping);
        linuxBiMap.put((Object)linuxIdentifier, (Object)mapping);
    }

    public static List<JoystickCompatibilityFilter> getCompatibilityFilters() {
        ArrayList<JoystickCompatibilityFilter> compatibilityFilters = new ArrayList<JoystickCompatibilityFilter>();
        if (SystemUtils.IS_OS_LINUX) {
            compatibilityFilters.add(new JoystickCompatibilityFilter(LEFT_TRIGGER, false, 1.0, 0.5));
            compatibilityFilters.add(new JoystickCompatibilityFilter(RIGHT_TRIGGER, false, 1.0, 0.5));
        }
        return compatibilityFilters;
    }

    @Override
    public Component.Identifier getIdentifier() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return (Component.Identifier)windowsBiMap.inverse().get((Object)this);
        }
        if (SystemUtils.IS_OS_MAC) {
            return (Component.Identifier)macBiMap.inverse().get((Object)this);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return (Component.Identifier)linuxBiMap.inverse().get((Object)this);
        }
        return null;
    }

    public static XBoxOneMapping getMapping(Component.Identifier identifier) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return (XBoxOneMapping)windowsBiMap.get((Object)identifier);
        }
        if (SystemUtils.IS_OS_MAC) {
            return (XBoxOneMapping)macBiMap.get((Object)identifier);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return (XBoxOneMapping)linuxBiMap.get((Object)identifier);
        }
        return null;
    }

    private static XBoxOneMapping getMapping(Component component) {
        return XBoxOneMapping.getMapping(component.getIdentifier());
    }

    public static XBoxOneMapping getMapping(Event event) {
        return XBoxOneMapping.getMapping(event.getComponent());
    }

    static {
        values = XBoxOneMapping.values();
        windowsBiMap = HashBiMap.create((int)values.length);
        macBiMap = HashBiMap.create((int)values.length);
        linuxBiMap = HashBiMap.create((int)values.length);
        XBoxOneMapping.mapValues(A, (Component.Identifier)Component.Identifier.Button._0, (Component.Identifier)Component.Identifier.Button._0, (Component.Identifier)Component.Identifier.Button.A);
        XBoxOneMapping.mapValues(B, (Component.Identifier)Component.Identifier.Button._1, (Component.Identifier)Component.Identifier.Button._1, (Component.Identifier)Component.Identifier.Button.B);
        XBoxOneMapping.mapValues(X, (Component.Identifier)Component.Identifier.Button._2, (Component.Identifier)Component.Identifier.Button._2, (Component.Identifier)Component.Identifier.Button.X);
        XBoxOneMapping.mapValues(Y, (Component.Identifier)Component.Identifier.Button._3, (Component.Identifier)Component.Identifier.Button._3, (Component.Identifier)Component.Identifier.Button.Y);
        XBoxOneMapping.mapValues(LEFT_BUMPER, (Component.Identifier)Component.Identifier.Button._4, (Component.Identifier)Component.Identifier.Button._4, (Component.Identifier)Component.Identifier.Button.LEFT_THUMB);
        XBoxOneMapping.mapValues(RIGHT_BUMPER, (Component.Identifier)Component.Identifier.Button._5, (Component.Identifier)Component.Identifier.Button._5, (Component.Identifier)Component.Identifier.Button.RIGHT_THUMB);
        XBoxOneMapping.mapValues(SELECT, (Component.Identifier)Component.Identifier.Button._6, (Component.Identifier)Component.Identifier.Button._9, (Component.Identifier)Component.Identifier.Button.SELECT);
        XBoxOneMapping.mapValues(START, (Component.Identifier)Component.Identifier.Button._7, (Component.Identifier)Component.Identifier.Button._8, (Component.Identifier)Component.Identifier.Button.START);
        XBoxOneMapping.mapValues(XBOX_BUTTON, (Component.Identifier)Component.Identifier.Button._10, (Component.Identifier)Component.Identifier.Button._10, (Component.Identifier)Component.Identifier.Button.MODE);
        XBoxOneMapping.mapValues(LEFT_TRIGGER, (Component.Identifier)Component.Identifier.Axis.Z, (Component.Identifier)Component.Identifier.Axis.Z, (Component.Identifier)Component.Identifier.Axis.Z);
        XBoxOneMapping.mapValues(RIGHT_TRIGGER, (Component.Identifier)Component.Identifier.Axis.RZ, (Component.Identifier)Component.Identifier.Axis.RZ, (Component.Identifier)Component.Identifier.Axis.RZ);
        XBoxOneMapping.mapValues(LEFT_STICK_X, (Component.Identifier)Component.Identifier.Axis.X, (Component.Identifier)Component.Identifier.Axis.X, (Component.Identifier)Component.Identifier.Axis.X);
        XBoxOneMapping.mapValues(LEFT_STICK_Y, (Component.Identifier)Component.Identifier.Axis.Y, (Component.Identifier)Component.Identifier.Axis.Y, (Component.Identifier)Component.Identifier.Axis.Y);
        XBoxOneMapping.mapValues(RIGHT_STICK_X, (Component.Identifier)Component.Identifier.Axis.RX, (Component.Identifier)Component.Identifier.Axis.RX, (Component.Identifier)Component.Identifier.Axis.RX);
        XBoxOneMapping.mapValues(RIGHT_STICK_Y, (Component.Identifier)Component.Identifier.Axis.RY, (Component.Identifier)Component.Identifier.Axis.RY, (Component.Identifier)Component.Identifier.Axis.RY);
        XBoxOneMapping.mapValues(LEFT_STICK_BUTTON, (Component.Identifier)Component.Identifier.Button._8, (Component.Identifier)Component.Identifier.Button._6, (Component.Identifier)Component.Identifier.Button.LEFT_THUMB3);
        XBoxOneMapping.mapValues(RIGHT_STICK_BUTTON, (Component.Identifier)Component.Identifier.Button._9, (Component.Identifier)Component.Identifier.Button._7, (Component.Identifier)Component.Identifier.Button.RIGHT_THUMB3);
        XBoxOneMapping.mapValues(DPAD, (Component.Identifier)Component.Identifier.Axis.POV, (Component.Identifier)Component.Identifier.Button.UNKNOWN, (Component.Identifier)Component.Identifier.Axis.POV);
        XBoxOneMapping.mapValues(DPAD_UP, (Component.Identifier)Component.Identifier.Button.UNKNOWN, (Component.Identifier)Component.Identifier.Button._11, (Component.Identifier)Component.Identifier.Button.UNKNOWN);
        XBoxOneMapping.mapValues(DPAD_DOWN, (Component.Identifier)Component.Identifier.Button.UNKNOWN, (Component.Identifier)Component.Identifier.Button._12, (Component.Identifier)Component.Identifier.Button.UNKNOWN);
        XBoxOneMapping.mapValues(DPAD_LEFT, (Component.Identifier)Component.Identifier.Button.UNKNOWN, (Component.Identifier)Component.Identifier.Button._13, (Component.Identifier)Component.Identifier.Button.UNKNOWN);
        XBoxOneMapping.mapValues(DPAD_RIGHT, (Component.Identifier)Component.Identifier.Button.UNKNOWN, (Component.Identifier)Component.Identifier.Button._14, (Component.Identifier)Component.Identifier.Button.UNKNOWN);
        XBoxOneMapping.mapValues(SLIDER, (Component.Identifier)Component.Identifier.Axis.SLIDER, (Component.Identifier)Component.Identifier.Axis.SLIDER, (Component.Identifier)Component.Identifier.Axis.SLIDER);
    }
}

