/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.time;

import java.util.ArrayDeque;
import us.ihmc.commons.time.Stopwatch;

public class DurationCalculator {
    private volatile double duration;
    private final ArrayDeque<Double> deltas = new ArrayDeque();
    private final Stopwatch stopwatch = new Stopwatch().start();
    private int history = 3;

    public synchronized void pause() {
        this.stopwatch.suspend();
    }

    public synchronized void ping() {
        this.stopwatch.resume();
        double elapsed = this.stopwatch.lap();
        this.deltas.addLast(elapsed);
        while (this.deltas.size() > this.history) {
            this.deltas.removeFirst();
        }
        double totalElapsed = 0.0;
        for (Double delta : this.deltas) {
            totalElapsed += delta.doubleValue();
        }
        this.duration = totalElapsed / (double)this.deltas.size();
    }

    public synchronized double getDuration() {
        return this.duration;
    }
}

