/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.processManagement;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SystemUtils;

public class ProcessTools {
    public static ArrayList<String> getAllSystemProcesses() {
        try {
            String line;
            Process psSystemCommand = null;
            if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
                psSystemCommand = Runtime.getRuntime().exec("ps -e");
            } else if (SystemUtils.IS_OS_WINDOWS) {
                psSystemCommand = Runtime.getRuntime().exec(System.getenv("windir") + "\\system32\\tasklist.exe");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(psSystemCommand.getInputStream()));
            ArrayList<String> processLines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                processLines.add(line);
            }
            return processLines;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] getCurrentJVMProperties() {
        Properties properties = System.getProperties();
        String[] propertyStrings = new String[properties.size()];
        int i = 0;
        for (String stringPropertyName : properties.stringPropertyNames()) {
            propertyStrings[i] = "-D" + stringPropertyName + "=" + System.getProperty(stringPropertyName);
            ++i;
        }
        return propertyStrings;
    }

    public static String[] constructJavaProcessCommand(String javaHome, String nativeLibraryPath, String classpath, Class<?> mainClass, String[] javaArgs, String[] programArgs) {
        Object[] spawnString = new String[]{javaHome + "/bin/java"};
        if (javaArgs != null) {
            spawnString = (String[])ArrayUtils.addAll((Object[])spawnString, (Object[])javaArgs);
        }
        if (nativeLibraryPath != null) {
            spawnString = (String[])ArrayUtils.addAll((Object[])spawnString, (Object[])new String[]{"-Djava.library.path=" + nativeLibraryPath});
        }
        if (classpath != null) {
            spawnString = (String[])ArrayUtils.addAll((Object[])spawnString, (Object[])new String[]{"-cp", classpath});
        }
        spawnString = (String[])ArrayUtils.addAll((Object[])spawnString, (Object[])new String[]{mainClass.getCanonicalName()});
        if (programArgs != null) {
            spawnString = (String[])ArrayUtils.addAll((Object[])spawnString, (Object[])programArgs);
        }
        return spawnString;
    }

    public static String execSimpleCommand(String command) {
        Runtime runtime = Runtime.getRuntime();
        try {
            int read;
            Process process = runtime.exec(command);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder output = new StringBuilder();
            while ((read = bufferedReader.read()) > -1) {
                output.append((char)read);
            }
            process.waitFor();
            return output.toString();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PrintStream createJansiFilteredStream(Path outputFile) throws IOException {
        return new PrintStream(Files.newOutputStream(outputFile, new OpenOption[0]));
    }
}

