/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.processManagement;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import us.ihmc.tools.processManagement.ExitListener;
import us.ihmc.tools.processManagement.UnixProcessSpawner;

public class ForkedShellProcessSpawner
extends UnixProcessSpawner {
    private final String shellEnvironment;
    private final String[] shellEnvironmentArguments;

    public ForkedShellProcessSpawner(boolean killChildProcessesOnShutdown, String shellEnvironment, String[] shellEnvironmentArguments) {
        super(killChildProcessesOnShutdown);
        this.shellEnvironment = shellEnvironment;
        this.shellEnvironmentArguments = shellEnvironmentArguments;
    }

    public ForkedShellProcessSpawner(boolean shouldKillChildProcessesOnShutdown) {
        this(shouldKillChildProcessesOnShutdown, "/bin/sh", new String[]{"-l", "-c"});
    }

    public Process spawn(String command) {
        return this.spawn(command, null, null, null, null);
    }

    public Process spawn(String command, String[] arguments) {
        return this.spawn(command, arguments, null, null, null);
    }

    public Process spawn(String command, String[] arguments, File outputLog, File errorLog, ExitListener exitListener) {
        if (this.shellEnvironment == null || this.shellEnvironment.isEmpty()) {
            throw new RuntimeException("Shell environment set up incorrectly. Shell environment string: " + this.shellEnvironment);
        }
        if (this.shellEnvironmentArguments == null || this.shellEnvironmentArguments.length < 1) {
            throw new RuntimeException("Shell environment arguments seem bad. Arguments: " + Arrays.toString(this.shellEnvironmentArguments));
        }
        Object[] spawnString = new String[]{};
        spawnString = (String[])ArrayUtils.add((Object[])spawnString, (Object)this.shellEnvironment);
        spawnString = (String[])ArrayUtils.addAll((Object[])spawnString, (Object[])this.shellEnvironmentArguments);
        StringBuilder commandStringBuilder = new StringBuilder();
        commandStringBuilder.append(command);
        if (arguments == null) {
            arguments = new String[]{};
        }
        for (String argument : arguments) {
            commandStringBuilder.append(" ").append(argument);
        }
        spawnString = (String[])ArrayUtils.add((Object[])spawnString, (Object)commandStringBuilder.toString().trim());
        ProcessBuilder builder = new ProcessBuilder((String[])spawnString);
        return this.spawn(command, (String[])spawnString, builder, outputLog, errorLog, exitListener);
    }
}

