/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick.mapping;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Event;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.tools.inputDevices.joystick.JoystickCompatibilityFilter;
import us.ihmc.tools.inputDevices.joystick.mapping.JoystickMapping;

public enum Thrustmaster16000M implements JoystickMapping
{
    TRIGGER,
    THROTTLE,
    STICK_ROLL,
    STICK_PITCH,
    STICK_YAW,
    HAT,
    THUMB_BUTTON_CENTER,
    THUMB_BUTTON_LEFT,
    THUMB_BUTTON_RIGHT,
    BASE_BUTTON_LEFT_SIDE_UPPER_LEFT,
    BASE_BUTTON_LEFT_SIDE_UPPER_CENTER,
    BASE_BUTTON_LEFT_SIDE_UPPER_RIGHT,
    BASE_BUTTON_LEFT_SIDE_LOWER_LEFT,
    BASE_BUTTON_LEFT_SIDE_LOWER_CENTER,
    BASE_BUTTON_LEFT_SIDE_LOWER_RIGHT,
    BASE_BUTTON_RIGHT_SIDE_UPPER_LEFT,
    BASE_BUTTON_RIGHT_SIDE_UPPER_CENTER,
    BASE_BUTTON_RIGHT_SIDE_UPPER_RIGHT,
    BASE_BUTTON_RIGHT_SIDE_LOWER_LEFT,
    BASE_BUTTON_RIGHT_SIDE_LOWER_CENTER,
    BASE_BUTTON_RIGHT_SIDE_LOWER_RIGHT;

    public static final Thrustmaster16000M[] values;
    private static final BiMap<Component.Identifier, Thrustmaster16000M> windowsBiMap;
    private static final BiMap<Component.Identifier, Thrustmaster16000M> macBiMap;
    private static final BiMap<Component.Identifier, Thrustmaster16000M> linuxBiMap;

    private static void mapValues(Thrustmaster16000M mapping, Component.Identifier windowsIdentifier, Component.Identifier macIdentifier, Component.Identifier linuxIdentifier) {
        windowsBiMap.put((Object)windowsIdentifier, (Object)mapping);
        macBiMap.put((Object)macIdentifier, (Object)mapping);
        linuxBiMap.put((Object)linuxIdentifier, (Object)mapping);
    }

    public static List<JoystickCompatibilityFilter> getCompatibilityFilters() {
        ArrayList<JoystickCompatibilityFilter> compatibilityFilters = new ArrayList<JoystickCompatibilityFilter>();
        return compatibilityFilters;
    }

    @Override
    public Component.Identifier getIdentifier() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return (Component.Identifier)windowsBiMap.inverse().get((Object)this);
        }
        if (SystemUtils.IS_OS_MAC) {
            return (Component.Identifier)macBiMap.inverse().get((Object)this);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return (Component.Identifier)linuxBiMap.inverse().get((Object)this);
        }
        return null;
    }

    public static Thrustmaster16000M getMapping(Component.Identifier identifier) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return (Thrustmaster16000M)windowsBiMap.get((Object)identifier);
        }
        if (SystemUtils.IS_OS_MAC) {
            return (Thrustmaster16000M)macBiMap.get((Object)identifier);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return (Thrustmaster16000M)linuxBiMap.get((Object)identifier);
        }
        return null;
    }

    private static Thrustmaster16000M getMapping(Component component) {
        return Thrustmaster16000M.getMapping(component.getIdentifier());
    }

    public static Thrustmaster16000M getMapping(Event event) {
        return Thrustmaster16000M.getMapping(event.getComponent());
    }

    static {
        values = Thrustmaster16000M.values();
        windowsBiMap = HashBiMap.create((int)values.length);
        macBiMap = HashBiMap.create((int)values.length);
        linuxBiMap = HashBiMap.create((int)values.length);
        Thrustmaster16000M.mapValues(TRIGGER, (Component.Identifier)Component.Identifier.Button._0, (Component.Identifier)Component.Identifier.Button._0, (Component.Identifier)Component.Identifier.Button.TRIGGER);
        Thrustmaster16000M.mapValues(THROTTLE, (Component.Identifier)Component.Identifier.Axis.SLIDER, (Component.Identifier)Component.Identifier.Axis.SLIDER, (Component.Identifier)Component.Identifier.Axis.SLIDER);
        Thrustmaster16000M.mapValues(STICK_ROLL, (Component.Identifier)Component.Identifier.Axis.X, (Component.Identifier)Component.Identifier.Axis.X, (Component.Identifier)Component.Identifier.Axis.X);
        Thrustmaster16000M.mapValues(STICK_PITCH, (Component.Identifier)Component.Identifier.Axis.Y, (Component.Identifier)Component.Identifier.Axis.Y, (Component.Identifier)Component.Identifier.Axis.Y);
        Thrustmaster16000M.mapValues(STICK_YAW, (Component.Identifier)Component.Identifier.Axis.RZ, (Component.Identifier)Component.Identifier.Axis.RZ, (Component.Identifier)Component.Identifier.Axis.RZ);
        Thrustmaster16000M.mapValues(HAT, (Component.Identifier)Component.Identifier.Axis.POV, (Component.Identifier)Component.Identifier.Axis.POV, (Component.Identifier)Component.Identifier.Axis.POV);
        Thrustmaster16000M.mapValues(THUMB_BUTTON_CENTER, (Component.Identifier)Component.Identifier.Button._1, null, (Component.Identifier)Component.Identifier.Button.THUMB);
        Thrustmaster16000M.mapValues(THUMB_BUTTON_LEFT, (Component.Identifier)Component.Identifier.Button._2, null, (Component.Identifier)Component.Identifier.Button.THUMB2);
        Thrustmaster16000M.mapValues(THUMB_BUTTON_RIGHT, (Component.Identifier)Component.Identifier.Button._3, null, (Component.Identifier)Component.Identifier.Button.TOP);
        Thrustmaster16000M.mapValues(BASE_BUTTON_LEFT_SIDE_UPPER_LEFT, (Component.Identifier)Component.Identifier.Button._4, (Component.Identifier)Component.Identifier.Button._4, (Component.Identifier)Component.Identifier.Button.TOP2);
        Thrustmaster16000M.mapValues(BASE_BUTTON_LEFT_SIDE_UPPER_CENTER, (Component.Identifier)Component.Identifier.Button._5, (Component.Identifier)Component.Identifier.Button._5, (Component.Identifier)Component.Identifier.Button.PINKIE);
        Thrustmaster16000M.mapValues(BASE_BUTTON_LEFT_SIDE_UPPER_RIGHT, (Component.Identifier)Component.Identifier.Button._6, (Component.Identifier)Component.Identifier.Button._6, (Component.Identifier)Component.Identifier.Button.BASE);
        Thrustmaster16000M.mapValues(BASE_BUTTON_LEFT_SIDE_LOWER_LEFT, (Component.Identifier)Component.Identifier.Button._9, (Component.Identifier)Component.Identifier.Button._9, (Component.Identifier)Component.Identifier.Button.BASE4);
        Thrustmaster16000M.mapValues(BASE_BUTTON_LEFT_SIDE_LOWER_CENTER, (Component.Identifier)Component.Identifier.Button._8, (Component.Identifier)Component.Identifier.Button._8, (Component.Identifier)Component.Identifier.Button.BASE3);
        Thrustmaster16000M.mapValues(BASE_BUTTON_LEFT_SIDE_LOWER_RIGHT, (Component.Identifier)Component.Identifier.Button._7, (Component.Identifier)Component.Identifier.Button._7, (Component.Identifier)Component.Identifier.Button.BASE2);
        Thrustmaster16000M.mapValues(BASE_BUTTON_RIGHT_SIDE_UPPER_LEFT, (Component.Identifier)Component.Identifier.Button._12, (Component.Identifier)Component.Identifier.Button._12, (Component.Identifier)Component.Identifier.Button.UNKNOWN);
        Thrustmaster16000M.mapValues(BASE_BUTTON_RIGHT_SIDE_UPPER_CENTER, (Component.Identifier)Component.Identifier.Button._11, (Component.Identifier)Component.Identifier.Button._11, (Component.Identifier)Component.Identifier.Button.BASE6);
        Thrustmaster16000M.mapValues(BASE_BUTTON_RIGHT_SIDE_UPPER_RIGHT, (Component.Identifier)Component.Identifier.Button._10, (Component.Identifier)Component.Identifier.Button._10, (Component.Identifier)Component.Identifier.Button.BASE5);
        Thrustmaster16000M.mapValues(BASE_BUTTON_RIGHT_SIDE_LOWER_LEFT, (Component.Identifier)Component.Identifier.Button._13, (Component.Identifier)Component.Identifier.Button._13, (Component.Identifier)Component.Identifier.Button.UNKNOWN);
        Thrustmaster16000M.mapValues(BASE_BUTTON_RIGHT_SIDE_LOWER_CENTER, (Component.Identifier)Component.Identifier.Button._14, (Component.Identifier)Component.Identifier.Button._14, (Component.Identifier)Component.Identifier.Button.UNKNOWN);
        Thrustmaster16000M.mapValues(BASE_BUTTON_RIGHT_SIDE_LOWER_RIGHT, (Component.Identifier)Component.Identifier.Button._15, (Component.Identifier)Component.Identifier.Button._15, (Component.Identifier)Component.Identifier.Button.DEAD);
    }
}

