/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.concurrent.ExecutorService;
import us.ihmc.commons.thread.ThreadTools;

public class ResettableSingleThreadExecutor {
    private final String prefix;
    private ExecutorService executor;

    public ResettableSingleThreadExecutor(String prefix) {
        this.prefix = prefix;
        this.recreate();
    }

    private void recreate() {
        this.executor = ThreadTools.newSingleThreadExecutor((String)this.prefix);
    }

    public void queueExecution(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public void interruptAndReset() {
        this.executor.shutdownNow();
        this.recreate();
    }
}

