/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

public abstract class InterruptableWorker
implements Runnable {
    private STATE currentState = STATE.UNINITIALIZED;

    public abstract STATE doWork();

    public abstract Object getCurrentResult();

    public void reset() {
        this.setCurrentState(STATE.INITIALIZED);
    }

    public synchronized STATE getCurrentState() {
        return this.currentState;
    }

    public void startWorkOnANewThread() {
        this.setCurrentState(STATE.WORKING);
        Thread thread = new Thread((Runnable)this, "IHMC-InterruptableWorker");
        thread.setDaemon(true);
        thread.start();
    }

    public void startWorkOnThisThread() {
        this.setCurrentState(STATE.WORKING);
        this.run();
    }

    @Override
    public void run() {
        STATE state = this.doWork();
        if (state != STATE.SUCCESSFULLY_COMPLETED && state != STATE.UNSUCCESSFULLY_COMPLETED && state != STATE.INTERRUPTED) {
            throw new RuntimeException("Worker returned an invalid state: " + (Object)((Object)state) + "(must be STATE.SUCCESSFULLY_COMPLETED || STATE.UNSUCCESSFULLY_COMPLETED || state != STATE.INTERRUPTED)");
        }
        this.setCurrentState(state);
    }

    public synchronized void setCurrentState(STATE state) {
        this.currentState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWork() {
        InterruptableWorker interruptableWorker = this;
        synchronized (interruptableWorker) {
            if (this.currentState == STATE.WORKING) {
                this.setCurrentState(STATE.PENDING_INTERRUPTION);
            }
        }
        while (this.currentState == STATE.PENDING_INTERRUPTION) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void waitForResult(long timeout) {
        boolean isTimeRemaining;
        long startTime = System.currentTimeMillis();
        boolean bl = isTimeRemaining = System.currentTimeMillis() - startTime < timeout;
        while ((this.currentState == STATE.WORKING || this.currentState == STATE.PENDING_INTERRUPTION) && isTimeRemaining) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            isTimeRemaining = System.currentTimeMillis() - startTime < timeout;
        }
        if (this.currentState == STATE.WORKING) {
            this.stopWork();
        }
    }

    public boolean isInterrupted() {
        return this.currentState == STATE.PENDING_INTERRUPTION || this.currentState == STATE.INTERRUPTED;
    }

    public boolean isWorkingOrPendingInterruption() {
        return this.currentState == STATE.WORKING || this.currentState == STATE.PENDING_INTERRUPTION;
    }

    public static enum STATE {
        UNINITIALIZED,
        INITIALIZED,
        WORKING,
        SUCCESSFULLY_COMPLETED,
        UNSUCCESSFULLY_COMPLETED,
        PENDING_INTERRUPTION,
        INTERRUPTED;

    }
}

